#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-06-11 12:40:47.360445

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""

from pycatia.system_interfaces.setting_controller import SettingController


class PrintersSettingAtt(SettingController):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     System.SettingController
                |                         PrintersSettingAtt
                | 
                | Represents a setting controller for the printer settings.
                | Role: This interface is implemented by a component which represents the
                | controller of the printer settings.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.printers_setting_att = com_object

    def add_printer_directory(self, i_printer_dir: str, i_printer_dir_state: int) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384))
                | o Sub AddPrinterDirectory(CATBSTR iPrinterDir,
                | CatPrinterDirState iPrinterDirState)
                | 
                |     Add a printer file directory to printer directories list and define its
                |     state.
                | 
                |     Parameters:
                | 
                |         iPrinterDir
                |             directory where some 3DPLM printers are defined.
                |             The printers defined in this directory will be available for each
                |             user. 
                |         iPrinterDirState
                |             printer directory state.
                |             Each directory can be protected to prevent user access to the
                |             printers it contains.
                |             The state could be protect or free.
                |             If the state is CatPrinterDirProtect, the parameters of each
                |             printer included in the directory cannot be
                |             changed.
                |             If the state is CatPrinterDirFree, the parameters of each printer
                |             included in the directory can be changed, and the printers can be
                |             removed.
                |             Legal values:
                |             CatPrinterDirProtect : the printers included in the directory are protected.
                |             CatPrinterDirFree : the printers included in the directory are free.

        :param str i_printer_dir:
        :param int i_printer_dir_state:
        :return: None
        :rtype: None
        """
        return self.printers_setting_att.AddPrinterDirectory(i_printer_dir, i_printer_dir_state)

    def add_printer_group(self, i_printer_group_name: str, i_printer_names: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384))
                | o Sub AddPrinterGroup(CATBSTR iPrinterGroupName,
                | CATSafeArrayVariant iPrinterNames)
                | 
                |     Add a printer group and define the printers included in this
                |     group.
                | 
                |     Parameters:
                | 
                |         iPrinterGroupName
                |             printer group name 
                |         iPrinterNames
                |             array of printers included in the group.

        :param str i_printer_group_name:
        :param tuple i_printer_names:
        :return: None
        :rtype: None
        """
        return self.printers_setting_att.AddPrinterGroup(i_printer_group_name, i_printer_names)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add_printer_group'
        # # vba_code = """
        # # Public Function add_printer_group(printers_setting_att)
        # #     Dim iPrinterGroupName (2)
        # #     printers_setting_att.AddPrinterGroup iPrinterGroupName
        # #     add_printer_group = iPrinterGroupName
        # # End Function
        # # """

        # # system_service = self.application.system_service
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_driver_configuration_path(self, o_driver_cfg_path: str) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384))
                | o Sub GetDriverConfigurationPath(CATBSTR oDriverCfgPath)
                | 
                |     Returns the driver configuration file.
                | 
                |     Parameters:
                | 
                |         oDriverCfgPath
                |             path of the driver configuration file

        :param str o_driver_cfg_path:
        :return: None
        :rtype: None
        """
        return self.printers_setting_att.GetDriverConfigurationPath(o_driver_cfg_path)

    def get_driver_configuration_path_info(self, o_admin_level: str, o_locked: str) -> bool:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384))
                | o Func GetDriverConfigurationPathInfo(CATBSTR oAdminLevel,
                | CATBSTR oLocked) As boolean
                | 
                |     Retrieves environment informations for the driver configuration
                |     file.
                |     Role: Retrieves the state of the driver configuration file in the current
                |     environment.
                | 
                |     Parameters:
                | 
                |         oAdminLevel
                |             If the parameter is locked, oAdminLevel gives the administration
                |             level that imposes the value of the parameter.
                |             If the parameter is not locked, oAdminLevel gives the
                |             administration level that will give the value of the parameter after a reset.
                |             
                |         oLocked
                |             Indicates if the parameter has been locked. 
                | 
                |     Returns:
                |         Indicates if the parameter has been explicitly modified or remain to
                |         the administrated value.

        :param str o_admin_level:
        :param str o_locked:
        :return: bool
        :rtype: bool
        """
        return self.printers_setting_att.GetDriverConfigurationPathInfo(o_admin_level, o_locked)

    def get_new_printer_directory(self, o_new_printer_dir: str) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384))
                | o Sub GetNewPrinterDirectory(CATBSTR oNewPrinterDir)
                | 
                |     Returns the directory where new printers will be added.
                | 
                |     Parameters:
                | 
                |         oNewPrinterDir
                |             directory to add new printers
                |             Role: Each new printer created by an user is added in this
                |             directory.

        :param str o_new_printer_dir:
        :return: None
        :rtype: None
        """
        return self.printers_setting_att.GetNewPrinterDirectory(o_new_printer_dir)

    def get_new_printer_directory_info(self, o_admin_level: str, o_locked: str) -> bool:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384))
                | o Func GetNewPrinterDirectoryInfo(CATBSTR oAdminLevel,
                | CATBSTR oLocked) As boolean
                | 
                |     Retrieves environment informations for the directory where printers will be
                |     added.
                |     Role: Retrieves the state of the directory where printers will be added in
                |     the current environment.
                | 
                |     Parameters:
                | 
                |         oAdminLevel
                |             If the parameter is locked, oAdminLevel gives the administration
                |             level that imposes the value of the parameter.
                |             If the parameter is not locked, oAdminLevel gives the
                |             administration level that will give the value of the parameter after a reset.
                |             
                |         oLocked
                |             Indicates if the parameter has been locked. 
                | 
                |     Returns:
                |         Indicates if the parameter has been explicitly modified or remain to
                |         the administrated value.

        :param str o_admin_level:
        :param str o_locked:
        :return: bool
        :rtype: bool
        """
        return self.printers_setting_att.GetNewPrinterDirectoryInfo(o_admin_level, o_locked)

    def get_printer_array_for_group(self, i_printer_group_name: str) -> tuple:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384))
                | o Func GetPrinterArrayForGroup(CATBSTR iPrinterGroupName) As
                | CATSafeArrayVariant
                | 
                |     Returns the definition of the printer group.
                | 
                |     Parameters:
                | 
                |         iPrinterGroupName
                |             printer group name 
                | 
                |     Returns:
                |         array of printers included in the group.

        :param str i_printer_group_name:
        :return: tuple
        :rtype: tuple
        """
        return self.printers_setting_att.GetPrinterArrayForGroup(i_printer_group_name)

    def get_printer_directories(self) -> tuple:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384))
                | o Func GetPrinterDirectories() As CATSafeArrayVariant
                | 
                |     Returns the directories of printer files.
                | 
                |     Returns:
                |         array of directories where 3DPLM printers are defined.

        :return: tuple
        :rtype: tuple
        """
        return self.printers_setting_att.GetPrinterDirectories()

    def get_printer_directories_info(self, o_admin_level: str, o_locked: str) -> bool:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384))
                | o Func GetPrinterDirectoriesInfo(CATBSTR oAdminLevel,
                | CATBSTR oLocked) As boolean
                | 
                |     Retrieves environment informations for the directories of printer files and
                |     their states.
                |     Role: Retrieves the state of the directories of printer files and their
                |     states in the current environment.
                | 
                |     Parameters:
                | 
                |         oAdminLevel
                |             If the parameter is locked, oAdminLevel gives the administration
                |             level that imposes the value of the parameter.
                |             If the parameter is not locked, oAdminLevel gives the
                |             administration level that will give the value of the parameter after a reset.
                |             
                |         oLocked
                |             Indicates if the parameter has been locked. 
                | 
                |     Returns:
                |         Indicates if the parameter has been explicitly modified or remain to
                |         the administrated value.

        :param str o_admin_level:
        :param str o_locked:
        :return: bool
        :rtype: bool
        """
        return self.printers_setting_att.GetPrinterDirectoriesInfo(o_admin_level, o_locked)

    def get_printer_directory_state(self, i_printer_dir: str) -> int:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384))
                | o Func GetPrinterDirectoryState(CATBSTR iPrinterDir) As
                | CatPrinterDirState
                | 
                |     Returns the state of the directory of printer files.
                | 
                |     Parameters:
                | 
                |         iPrinterDir
                |             directory where some 3DPLM printers are defined. 
                | 
                |     Returns:
                |         printer directory state.
                |         Each directory can be protected to prevent user access to the printers
                |         it contains.
                |         The state could be protect or free.
                |         If the state is CatPrinterDirProtect, the parameters of each printer
                |         included in the directory cannot be changed.
                |         If the state is CatPrinterDirFree, the parameters of each printer
                |         included in the directory can be changed, and the printers can be
                |         removed.
                |         Legal values:
                |         CatPrinterDirProtect : the printers included in the directory are protected.
                |         CatPrinterDirFree : the printers included in the directory are free.

        :param str i_printer_dir:
        :return: int
        :rtype: int
        """
        return self.printers_setting_att.GetPrinterDirectoryState(i_printer_dir)

    def get_printer_groups(self) -> tuple:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384))
                | o Func GetPrinterGroups() As CATSafeArrayVariant
                | 
                |     Returns the printer groups.
                | 
                |     Returns:
                |         array of printer group names

        :return: tuple
        :rtype: tuple
        """
        return self.printers_setting_att.GetPrinterGroups()

    def get_printer_groups_info(self, o_admin_level: str, o_locked: str) -> bool:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384))
                | o Func GetPrinterGroupsInfo(CATBSTR oAdminLevel,
                | CATBSTR oLocked) As boolean
                | 
                |     Retrieves environment informations for the definition of each printer
                |     group.
                |     Role: Retrieves the state of the definition of each printer group in the
                |     current environment.
                | 
                |     Parameters:
                | 
                |         oAdminLevel
                |             If the parameter is locked, oAdminLevel gives the administration
                |             level that imposes the value of the parameter.
                |             If the parameter is not locked, oAdminLevel gives the
                |             administration level that will give the value of the parameter after a reset.
                |             
                |         oLocked
                |             Indicates if the parameter has been locked. 
                | 
                |     Returns:
                |         Indicates if the parameter has been explicitly modified or remain to
                |         the administrated value.

        :param str o_admin_level:
        :param str o_locked:
        :return: bool
        :rtype: bool
        """
        return self.printers_setting_att.GetPrinterGroupsInfo(o_admin_level, o_locked)

    def modify_printer_array_for_group(self, i_printer_group_name: str, i_printer_names: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384))
                | o Sub ModifyPrinterArrayForGroup(CATBSTR iPrinterGroupName,
                | CATSafeArrayVariant iPrinterNames)
                | 
                |     Modify a printer group: redefine the array of printers included in this
                |     group.
                | 
                |     Parameters:
                | 
                |         iPrinterGroupName
                |             printer group name 
                |         iPrinterNames
                |             array of printers included in the group.

        :param str i_printer_group_name:
        :param tuple i_printer_names:
        :return: None
        :rtype: None
        """
        return self.printers_setting_att.ModifyPrinterArrayForGroup(i_printer_group_name, i_printer_names)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'modify_printer_array_for_group'
        # # vba_code = """
        # # Public Function modify_printer_array_for_group(printers_setting_att)
        # #     Dim iPrinterGroupName (2)
        # #     printers_setting_att.ModifyPrinterArrayForGroup iPrinterGroupName
        # #     modify_printer_array_for_group = iPrinterGroupName
        # # End Function
        # # """

        # # system_service = self.application.system_service
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def modify_printer_directory_state(self, i_printer_dir: str, i_printer_dir_state: int) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384))
                | o Sub ModifyPrinterDirectoryState(CATBSTR iPrinterDir,
                | CatPrinterDirState iPrinterDirState)
                | 
                |     Modify a printer file directory state.
                | 
                |     Parameters:
                | 
                |         iPrinterDir
                |             directory where some 3DPLM printers are defined. 
                |         iPrinterDirState
                |             printer directory state.
                |             Each directory can be protected to prevent user access to the
                |             printers it contains.
                |             The state could be protect or free.
                |             If the state is CatPrinterDirProtect, the parameters of each
                |             printer included in the directory cannot be
                |             changed.
                |             If the state is CatPrinterDirFree, the parameters of each printer
                |             included in the directory can be changed, and the printers can be
                |             removed.
                |             Legal values:
                |             CatPrinterDirProtect : the printers included in the directory are protected.
                |             CatPrinterDirFree : the printers included in the directory are free.

        :param str i_printer_dir:
        :param int i_printer_dir_state:
        :return: None
        :rtype: None
        """
        return self.printers_setting_att.ModifyPrinterDirectoryState(i_printer_dir, i_printer_dir_state)

    def remove_all_printer_directories(self) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384))
                | o Sub RemoveAllPrinterDirectories()
                | 
                |     Remove all the directories including printer files.

        :return: None
        :rtype: None
        """
        return self.printers_setting_att.RemoveAllPrinterDirectories()

    def remove_all_printer_groups(self) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384))
                | o Sub RemoveAllPrinterGroups()
                | 
                |     Remove all the groups of printers.

        :return: None
        :rtype: None
        """
        return self.printers_setting_att.RemoveAllPrinterGroups()

    def remove_printer_directory(self, i_printer_dir: str) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384))
                | o Sub RemovePrinterDirectory(CATBSTR iPrinterDir)
                | 
                |     Remove a directory of printer files from the directories
                |     list.
                | 
                |     Parameters:
                | 
                |         iPrinterDir
                |             directory where some 3DPLM printers are defined.

        :param str i_printer_dir:
        :return: None
        :rtype: None
        """
        return self.printers_setting_att.RemovePrinterDirectory(i_printer_dir)

    def remove_printer_group(self, i_printer_group_name: str) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384))
                | o Sub RemovePrinterGroup(CATBSTR iPrinterGroupName)
                | 
                |     Remove a group of printers.
                | 
                |     Parameters:
                | 
                |         iPrinterGroupName
                |             name of the group to remove.

        :param str i_printer_group_name:
        :return: None
        :rtype: None
        """
        return self.printers_setting_att.RemovePrinterGroup(i_printer_group_name)

    def set_driver_configuration_path(self, i_driver_cfg_path: str) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384))
                | o Sub SetDriverConfigurationPath(CATBSTR iDriverCfgPath)
                | 
                |     Sets the driver configuration file.
                | 
                |     Parameters:
                | 
                |         iDriverCfgPath
                |             path of the driver configuration file

        :param str i_driver_cfg_path:
        :return: None
        :rtype: None
        """
        return self.printers_setting_att.SetDriverConfigurationPath(i_driver_cfg_path)

    def set_driver_configuration_path_lock(self, i_lock: bool) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384))
                | o Sub SetDriverConfigurationPathLock(boolean iLock)
                | 
                |     Locks or unlocks the driver configuration file.
                |     Role: Locks or unlocks the driver configuration file if it is possible in
                |     the current administrative context. In user mode this method will always return
                |     E_FAIL.
                | 
                |     Parameters:
                | 
                |         iLocked
                |             the locking operation to be performed
                |             Legal values:
                |             TRUE : to lock the parameter.
                |             FALSE: to unlock the parameter.

        :param bool i_lock:
        :return: None
        :rtype: None
        """
        return self.printers_setting_att.SetDriverConfigurationPathLock(i_lock)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_driver_configuration_path_lock'
        # # vba_code = """
        # # Public Function set_driver_configuration_path_lock(printers_setting_att)
        # #     Dim iLock (2)
        # #     printers_setting_att.SetDriverConfigurationPathLock iLock
        # #     set_driver_configuration_path_lock = iLock
        # # End Function
        # # """

        # # system_service = self.application.system_service
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_new_printer_directory(self, i_new_printer_dir: str) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384))
                | o Sub SetNewPrinterDirectory(CATBSTR iNewPrinterDir)
                | 
                |     Sets the directory where new printers will be added.
                | 
                |     Parameters:
                | 
                |         iNewPrinterDir
                |             directory to add new printers
                |             Role: Each new printer created by an user is added in this
                |             directory.

        :param str i_new_printer_dir:
        :return: None
        :rtype: None
        """
        return self.printers_setting_att.SetNewPrinterDirectory(i_new_printer_dir)

    def set_new_printer_directory_lock(self, i_lock: bool) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384))
                | o Sub SetNewPrinterDirectoryLock(boolean iLock)
                | 
                |     Locks or unlocks the directory where printers will be
                |     added.
                |     Role: Locks or unlocks the directory where printers will be added if it is
                |     possible in the current administrative context. In user mode this method will
                |     always return E_FAIL.
                | 
                |     Parameters:
                | 
                |         iLocked
                |             the locking operation to be performed
                |             Legal values:
                |             TRUE : to lock the parameter.
                |             FALSE: to unlock the parameter.

        :param bool i_lock:
        :return: None
        :rtype: None
        """
        return self.printers_setting_att.SetNewPrinterDirectoryLock(i_lock)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_new_printer_directory_lock'
        # # vba_code = """
        # # Public Function set_new_printer_directory_lock(printers_setting_att)
        # #     Dim iLock (2)
        # #     printers_setting_att.SetNewPrinterDirectoryLock iLock
        # #     set_new_printer_directory_lock = iLock
        # # End Function
        # # """

        # # system_service = self.application.system_service
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_printer_directories_lock(self, i_lock: bool) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384))
                | o Sub SetPrinterDirectoriesLock(boolean iLock)
                | 
                |     Locks or unlocks the directories of printer files and their
                |     states.
                |     Role: Locks or unlocks the directories of printer files and their states if
                |     it is possible in the current administrative context. In user mode this method
                |     will always return E_FAIL.
                | 
                |     Parameters:
                | 
                |         iLocked
                |             the locking operation to be performed
                |             Legal values:
                |             TRUE : to lock the parameter.
                |             FALSE: to unlock the parameter.

        :param bool i_lock:
        :return: None
        :rtype: None
        """
        return self.printers_setting_att.SetPrinterDirectoriesLock(i_lock)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_printer_directories_lock'
        # # vba_code = """
        # # Public Function set_printer_directories_lock(printers_setting_att)
        # #     Dim iLock (2)
        # #     printers_setting_att.SetPrinterDirectoriesLock iLock
        # #     set_printer_directories_lock = iLock
        # # End Function
        # # """

        # # system_service = self.application.system_service
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_printer_groups_lock(self, i_lock: bool) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384))
                | o Sub SetPrinterGroupsLock(boolean iLock)
                | 
                |     Locks or unlocks the definition of each printer group.
                |     Role: Locks or unlocks the definition of each printer group if it is
                |     possible in the current administrative context. In user mode this method will
                |     always return E_FAIL.
                | 
                |     Parameters:
                | 
                |         iLocked
                |             the locking operation to be performed
                |             Legal values:
                |             TRUE : to lock the parameter.
                |             FALSE: to unlock the parameter.

        :param bool i_lock:
        :return: None
        :rtype: None
        """
        return self.printers_setting_att.SetPrinterGroupsLock(i_lock)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_printer_groups_lock'
        # # vba_code = """
        # # Public Function set_printer_groups_lock(printers_setting_att)
        # #     Dim iLock (2)
        # #     printers_setting_att.SetPrinterGroupsLock iLock
        # #     set_printer_groups_lock = iLock
        # # End Function
        # # """

        # # system_service = self.application.system_service
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'PrintersSettingAtt(name="{self.name}")'
