#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-06-11 12:40:47.360445

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.in_interfaces.reference import Reference
from pycatia.in_interfaces.references import References
from pycatia.part_interfaces.surface_based_shape import SurfaceBasedShape


class ReplaceFace(SurfaceBasedShape):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     MecModInterfaces.Shape
                |                         PartInterfaces.SurfaceBasedShape
                |                             ReplaceFace
                | 
                | Represents the Replace Face operation.
                | It replaces a face or a set of faces obtained by tangency continuity by a
                | replacing element, such as a surface or a face or a skin.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.replace_face = com_object

    @property
    def remove_face(self) -> References:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384)
                | o Property RemoveFace() As References (Read Only)
                | 
                |     Returns the face to be removed.

        :return: References
        :rtype: References
        """

        return References(self.replace_face.RemoveFace)

    @property
    def splitting_side(self) -> int:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384)
                | o Property SplittingSide() As CatSplitSide
                | 
                |     Returns or sets the splitting side . The splitting side is the side of the
                |     body kept after the splitting. A positive side refers to the same orientation
                |     than the splitting element normal vector.

        :return: int
        :rtype: int
        """

        return self.replace_face.SplittingSide

    @splitting_side.setter
    def splitting_side(self, value: int):
        """
        :param int value:
        """

        self.replace_face.SplittingSide = value

    def add_remove_face(self, i_remove_face: Reference) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384))
                | o Sub AddRemoveFace(Reference iRemoveFace)
                | 
                |     Sets the face to be removed.

        :param Reference i_remove_face:
        :return: None
        :rtype: None
        """
        return self.replace_face.AddRemoveFace(i_remove_face.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add_remove_face'
        # # vba_code = """
        # # Public Function add_remove_face(replace_face)
        # #     Dim iRemoveFace (2)
        # #     replace_face.AddRemoveFace iRemoveFace
        # #     add_remove_face = iRemoveFace
        # # End Function
        # # """

        # # system_service = self.application.system_service
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def add_split_plane(self, i_split_plane: Reference) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384))
                | o Sub AddSplitPlane(Reference iSplitPlane)
                | 
                |     Sets the replacing element.

        :param Reference i_split_plane:
        :return: None
        :rtype: None
        """
        return self.replace_face.AddSplitPlane(i_split_plane.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add_split_plane'
        # # vba_code = """
        # # Public Function add_split_plane(replace_face)
        # #     Dim iSplitPlane (2)
        # #     replace_face.AddSplitPlane iSplitPlane
        # #     add_split_plane = iSplitPlane
        # # End Function
        # # """

        # # system_service = self.application.system_service
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def delete_remove_face(self, i_remove_face: Reference) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384))
                | o Sub DeleteRemoveFace(Reference iRemoveFace)
                | 
                |     Remove the face to be removed.

        :param Reference i_remove_face:
        :return: None
        :rtype: None
        """
        return self.replace_face.DeleteRemoveFace(i_remove_face.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'delete_remove_face'
        # # vba_code = """
        # # Public Function delete_remove_face(replace_face)
        # #     Dim iRemoveFace (2)
        # #     replace_face.DeleteRemoveFace iRemoveFace
        # #     delete_remove_face = iRemoveFace
        # # End Function
        # # """

        # # system_service = self.application.system_service
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'ReplaceFace(name="{self.name}")'
