# Overview
napari-threedee is a collection of tools for exploring, manipulating, and annotating your data in 3D. 

![type:video](https://user-images.githubusercontent.com/1120672/206995875-4e71a25c-1cc5-44dd-86e1-bf912dc2d209.mov)

## Installation

`napari-threedee` is a `napari` plugin and thus requires `napari` to work. You can see the `napari` documentation for 
[napari installation instructions](https://napari.org/stable/tutorials/fundamentals/installation.html). After you 
have installed `napari`, you can install `napari-threedee` using the package manager of your choice using the commands 
below.

=== "pip"

    ``` bash
    pip install napari-threedee
    ```

=== "conda"

    ``` bash
    conda install -c conda-forge napari-threedee
    ```

## Getting started

### Users
Do you have rich 3D (or more!) data that you want to explore and annotate? `napari-threedee` comes with a collection 
of plugins for just that. Please see our [Getting started for users guide](getting_started/users.md) to get going.

### Developers
Are you developing an image processing workflow that requires exploration or annotation of multidimensional data? 
`napari-threedee` has a collection of composable components for adding 3D interactivity to your workflow! To get 
started, see our [Getting started for developers guide](getting_started/developers.md).

