class DrawDrawingDispatch:
    """
    Draw Drawing Dispatch Commands

    See Also:
        - :py:meth:`.Lo.dispatch_cmd`
        - `Draw Dispatch commands <https://wiki.documentfoundation.org/Development/DispatchCommands#Draw_.2F_Impress>`_
    """

    CHANGE_BEZIER = "ChangeBezier"
    """To Curve"""
    CHANGE_POLYGON = "ChangePolygon"
    """To Polygon"""
    CLOSE_OBJECT = "CloseObject"
    """Close Object"""
    CONE = "Cone"
    CONNECTOR_TOOLBOX = "ConnectorToolbox"
    """Connectors"""
    CROOK_ROTATE = "CrookRotate"
    """Set in Circle (perspective)"""
    CROOK_SLANT = "CrookSlant"
    """Set to circle (slant)"""
    CROOK_STRETCH = "CrookStretch"
    """Set in Circle (distort)"""
    CUBE = "Cube"
    CYLINDER = "Cylinder"
    CYRAMID = "Cyramid"
    """Pyramid"""
    DRAW_FONTWORK = "DrawFontwork"
    DRAW_FONTWORK_VERTICAL = "DrawFontworkVertical"
    DRAWING_MODE = "DrawingMode"
    """Drawing View"""
    ELLIPSE_TOOLBOX = "EllipseToolbox"
    """Ellipse"""
    GET_BLUE = "GetBlue"
    GET_FILL_STYLE = "GetFillStyle"
    GET_GREEN = "GetGreen"
    GET_LINE_STYLE = "GetLineStyle"
    GET_LINE_WIDTH = "GetLineWidth"
    GET_RED = "GetRed"
    GLUE_EDIT_MODE = "GlueEditMode"
    """Show Glue point Functions"""
    GLUE_ESCAPE_DIRECTION = "GlueEscapeDirection"
    """Exit Direction"""
    GLUE_ESCAPE_DIRECTION_BOTTOM = "GlueEscapeDirectionBottom"
    """Exit Direction Bottom"""
    GLUE_ESCAPE_DIRECTION_LEFT = "GlueEscapeDirectionLeft"
    """Exit Direction Left"""
    GLUE_ESCAPE_DIRECTION_RIGHT = "GlueEscapeDirectionRight"
    """Exit Direction Right"""
    GLUE_ESCAPE_DIRECTION_TOP = "GlueEscapeDirectionTop"
    """Exit Direction Top"""
    GLUE_HORZ_ALIGN_CENTER = "GlueHorzAlignCenter"
    """Glue point Horizontal Center"""
    GLUE_HORZ_ALIGN_LEFT = "GlueHorzAlignLeft"
    """Glue point Horizontal Left"""
    GLUE_HORZ_ALIGN_RIGHT = "GlueHorzAlignRight"
    """Glue point Horizontal Right"""
    GLUE_INSERT_POINT = "GlueInsertPoint"
    """Insert Glue point"""
    GLUE_PERCENT = "GluePercent"
    """Glue point Relative"""
    GLUE_VERT_ALIGN_BOTTOM = "GlueVertAlignBottom"
    """Glue point Vertical Bottom"""
    GLUE_VERT_ALIGN_CENTER = "GlueVertAlignCenter"
    "Glue point Vertical Center"
    GLUE_VERT_ALIGN_TOP = "GlueVertAlignTop"
    GRADIENT = "Gradient"
    """
    Args
        - ``Name (str)``
        - ``Style (int)``
        - ``Angle (int)``
        - ``Border (int)``
        - ``XOffset (int)``
        - ``YOffset (int)``
        - ``StartIntens (int)``
        - ``EndIntens (int)``
    """
    HALF_SPHERE = "HalfSphere"
    """Half-Sphere"""
    HATCH = "Hatch"
    INSERT_TOOLBOX = "InsertToolbox"
    """Insert"""
    LINE_END_POLYGON = "LineEndPolygon"
    LINE_TO = "LineTo"
    NEW_ROUTING = "NewRouting"
    """Reset line skew"""
    OBJECTS3D_TOOLBOX = "Objects3DToolbox"
    """3D Objects"""
    RECTANGLE_TOOLBOX = "RectangleToolbox"
    """Rectangle"""
    REDACTED_EXPORT_TOOLBOX = "RedactedExportToolbox"
    """Redacted Export"""
    SPHERE = "Sphere"
    TEXT_TOOLBOX = "TextToolbox"
    """Text"""
    TORUS = "Torus"
    CONVERT_TO_CONTOUR = "convert_to_contour"
    """To Contour"""
