import { Connections, IConnectable, ISecurityGroup, IVpc, SubnetSelection } from "aws-cdk-lib/aws-ec2";
import { CfnService, ICluster, FargateTaskDefinition } from "aws-cdk-lib/aws-ecs";
import { Grant, IGrantable } from "aws-cdk-lib/aws-iam";
import { Construct, IConstruct } from "constructs";
/**
 * The `networkConfiguration.awsvpcConfiguration` values for `ecs.RunTask`.
 */
export interface FargateAwsVpcConfiguration extends CfnService.AwsVpcConfigurationProperty {
}
/**
 * Interface for FargateTask.
 */
export interface IFargateTask extends IConnectable, IConstruct {
    /**
     * The name of the cluster that hosts the service.
     */
    readonly cluster: ICluster;
    /**
     * The task definition that can be launched.
     */
    readonly taskDefinition: FargateTaskDefinition;
    /**
     * Get the networkConfiguration.awsvpcConfiguration property to run this task.
     */
    readonly awsVpcNetworkConfig: FargateAwsVpcConfiguration;
}
/**
 * Constructor parameters for FargateTask.
 */
export interface FargateTaskProps {
    /**
     * The name of the cluster that hosts the service.
     */
    readonly cluster: ICluster;
    /**
     * The task definition that can be launched.
     */
    readonly taskDefinition: FargateTaskDefinition;
    /**
     * Specifies whether the task's elastic network interface receives a public IP address.
     *
     * If true, the task will receive a public IP address.
     *
     * @default false
     */
    readonly assignPublicIp?: boolean;
    /**
     * The subnets to associate with the task.
     *
     * @default - Public subnets if `assignPublicIp` is set, otherwise the first available one of Private, Isolated, Public, in that order.
     */
    readonly vpcSubnets?: SubnetSelection;
    /**
     * Existing security groups to use for your task.
     *
     * @default - a new security group will be created.
     */
    readonly securityGroups?: ISecurityGroup[];
}
/**
 * An FargateTask.
 *
 * If `vpcSubnets` is blank but `assignPublicIp` is set, the task will launch
 * in Public subnets, otherwise the first available one of Private, Isolated,
 * Public, in that order.
 */
export declare class FargateTask extends Construct implements IFargateTask {
    readonly cluster: ICluster;
    readonly taskDefinition: FargateTaskDefinition;
    readonly connections: Connections;
    readonly awsVpcNetworkConfig: FargateAwsVpcConfiguration;
    /**
     * Creates a new FargateTask.
     */
    constructor(scope: Construct, id: string, props: FargateTaskProps);
    protected configureAwsVpcNetworking(vpc: IVpc, assignPublicIp?: boolean, vpcSubnets?: SubnetSelection, securityGroups?: ISecurityGroup[]): FargateAwsVpcConfiguration;
    grantRun(grantee: IGrantable): Grant;
}
