"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseDatabase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_ec2_1 = require("aws-cdk-lib/aws-ec2");
const constructs_1 = require("constructs");
/**
 * A database.
 */
class BaseDatabase extends constructs_1.Construct {
    /**
     * Creates a new BaseDatabase.
     *
     * @param scope - The Construct that contains this one.
     * @param id - The identifier of this construct.
     * @param props - The configuration properties for this construct.
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.endpoint = props.endpoint;
        this.databaseName = props.databaseName;
        this.securityGroup =
            props.securityGroup ||
                new aws_ec2_1.SecurityGroup(this, "SecurityGroup", {
                    vpc: props.vpc,
                    description: `Created for ${this.node.path}/Function`,
                });
        props.target.connections.allowDefaultPortFrom(this.securityGroup);
        this.subnetSelection = {
            subnets: props.vpc.selectSubnets(props.vpcSubnets).subnets,
        };
    }
}
exports.BaseDatabase = BaseDatabase;
_a = JSII_RTTI_SYMBOL_1;
BaseDatabase[_a] = { fqn: "shady-island.BaseDatabase", version: "0.0.46" };
//# sourceMappingURL=data:application/json;base64,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