"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// eslint-disable-next-line import/no-extraneous-dependencies
const client_secrets_manager_1 = require("@aws-sdk/client-secrets-manager");
const promise_1 = require("mysql2/promise");
const util_1 = require("./util");
const adminSecretArn = process.env.ADMIN_SECRET_ARN;
const databaseName = process.env.DB_NAME;
const characterSet = process.env.DB_CHARACTER_SET || "utf8mb4";
const collation = process.env.DB_COLLATION;
const secretsManagerClient = new client_secrets_manager_1.SecretsManagerClient({});
const ownerSecretArns = util_1.parseJsonArrayFromEnv("OWNER_SECRETS");
const readerSecretArns = util_1.parseJsonArrayFromEnv("READER_SECRETS");
async function createUser(connection, user, password) {
    const escapedPassword = connection.escape(password);
    let createUserSql = `CREATE USER IF NOT EXISTS ${user} IDENTIFIED BY ${escapedPassword}`;
    console.log(`About to create user: ${user}`);
    await connection.execute(createUserSql, [password]);
    console.log(`User created: ${user}`);
}
async function applyGrant(connection, user, privileges) {
    let grantPrivSql = `GRANT ${privileges} ON ${databaseName}.* TO ${user}`;
    console.log(`About to grant privileges to user: ${user}`);
    await connection.execute(grantPrivSql);
    console.log(`Privileges granted: ${privileges} ON ${databaseName}.*`);
}
const handler = async () => {
    const adminSecret = await util_1.fetchSecret(adminSecretArn, secretsManagerClient);
    const connection = await promise_1.createConnection({
        host: adminSecret.host,
        user: adminSecret.username,
        password: adminSecret.password,
        port: adminSecret.port,
        ssl: "Amazon RDS",
    });
    let createDbSql = `CREATE DATABASE IF NOT EXISTS ${databaseName} CHARACTER SET ${characterSet}`;
    if (collation) {
        createDbSql += ` COLLATE ${collation}`;
    }
    console.log(`About to create database: ${databaseName}`);
    await connection.execute(createDbSql);
    console.log(`Database created: ${databaseName}`);
    const ownerSecrets = await util_1.fetchAllSecrets(ownerSecretArns, secretsManagerClient);
    for (const userSecret of ownerSecrets) {
        const mysqlUser = `'${userSecret.username}'@'%'`;
        await createUser(connection, mysqlUser, userSecret.password);
        await applyGrant(connection, mysqlUser, "ALL PRIVILEGES");
    }
    const readerSecrets = await util_1.fetchAllSecrets(readerSecretArns, secretsManagerClient);
    for (const userSecret of readerSecrets) {
        const mysqlUser = `'${userSecret.username}'@'%'`;
        await createUser(connection, mysqlUser, userSecret.password);
        await applyGrant(connection, mysqlUser, "SELECT, SHOW VIEW");
    }
    let flushSql = "FLUSH PRIVILEGES";
    console.log("About to flush privileges");
    await connection.execute(flushSql);
    console.log("Privileges flushed");
    console.log("About to close the connection");
    await connection.end();
    console.log("Connection closed");
};
module.exports = { handler };
//# sourceMappingURL=data:application/json;base64,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