"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// eslint-disable-next-line import/no-extraneous-dependencies
const client_secrets_manager_1 = require("@aws-sdk/client-secrets-manager");
const pg_1 = require("pg");
const util_1 = require("./util");
const adminSecretArn = process.env.ADMIN_SECRET_ARN;
const databaseName = process.env.DATABASE_NAME;
const secretsManagerClient = new client_secrets_manager_1.SecretsManagerClient({});
const handler = async () => {
    const adminSecret = await util_1.fetchSecret(adminSecretArn, secretsManagerClient);
    const client = new pg_1.Client({
        host: adminSecret.host,
        port: adminSecret.port,
        user: adminSecret.username,
        password: adminSecret.password,
        database: databaseName,
        ssl: true,
    });
    await client.connect();
    console.log("About to close the connection");
    await client.end();
    console.log("Connection closed");
};
module.exports = { handler };
//# sourceMappingURL=data:application/json;base64,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