/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.salvation.directiveValues;

import com.shapesecurity.salvation.data.Base64Value;
import com.shapesecurity.salvation.directiveValues.SourceExpression;
import com.shapesecurity.salvation.interfaces.MatchesNonce;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class NonceSource
implements SourceExpression,
MatchesNonce {
    @Nonnull
    private final String value;

    public NonceSource(@Nonnull String value) {
        this.value = value;
    }

    public List<String> validationErrors() {
        Base64Value base64Value;
        ArrayList<String> errors = new ArrayList<String>();
        try {
            String safeValue = this.value.replace('-', '+').replace('_', '/');
            base64Value = new Base64Value(safeValue);
            if ((this.value.contains("-") || this.value.contains("_")) && (this.value.contains("+") || this.value.contains("/"))) {
                errors.add("Invalid base64-value. Must use either RFC4648 \"base64\" characters (including + and /) or RFC4648 \"base64url\" characters (including - and _), but not both.");
            }
        }
        catch (IllegalArgumentException e) {
            errors.add(e.getMessage());
            return errors;
        }
        if (base64Value.size() < 16) {
            errors.add("CSP specification recommends nonce-value to be at least 128 bits long (before encoding).");
        }
        return errors;
    }

    public boolean equals(@Nullable Object other) {
        if (other == null || !(other instanceof NonceSource)) {
            return false;
        }
        return this.value.equals(((NonceSource)other).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean matchesNonce(@Nonnull String nonce) {
        return this.value.equals(nonce);
    }

    @Override
    @Nonnull
    public String show() {
        return "'nonce-" + this.value + "'";
    }
}

