/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import net.arnx.jsonic.Converter;
import net.arnx.jsonic.JSON;

final class ClassConverter
implements Converter {
    public static final ClassConverter INSTANCE = new ClassConverter();

    ClassConverter() {
    }

    @Override
    public boolean accept(Class<?> cls) {
        return Class.class.equals(cls);
    }

    @Override
    public Object convert(JSON.Context context, Object value, Class<?> c, Type t) throws Exception {
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            value = ((Map)value).get(null);
        } else if (value instanceof List) {
            List src = (List)value;
            Object object = value = !src.isEmpty() ? (Object)src.get(0) : null;
        }
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            String s = value.toString().trim();
            if (s.equals("boolean")) {
                return Boolean.TYPE;
            }
            if (s.equals("byte")) {
                return Byte.TYPE;
            }
            if (s.equals("short")) {
                return Short.TYPE;
            }
            if (s.equals("int")) {
                return Integer.TYPE;
            }
            if (s.equals("long")) {
                return Long.TYPE;
            }
            if (s.equals("float")) {
                return Float.TYPE;
            }
            if (s.equals("double")) {
                return Double.TYPE;
            }
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                return cl.loadClass(value.toString());
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        throw new UnsupportedOperationException("Cannot convert " + value.getClass() + " to " + t);
    }
}

