/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.text.NumberFormat;
import net.arnx.jsonic.Formatter;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.StringFormatter;
import net.arnx.jsonic.io.OutputSource;

final class NumberFormatter
implements Formatter {
    public static final NumberFormatter INSTANCE = new NumberFormatter();

    NumberFormatter() {
    }

    @Override
    public boolean accept(Object o) {
        return o instanceof Number;
    }

    @Override
    public boolean isStruct() {
        return false;
    }

    @Override
    public void format(JSON.Context context, Object src, Object o, OutputSource out) throws Exception {
        NumberFormat f = context.getNumberFormat();
        if (f != null) {
            StringFormatter.serialize(context, f.format(o), out);
        } else {
            out.append(o.toString());
        }
    }

    public void format(JSON.Context context, int num, OutputSource out) throws Exception {
        NumberFormat f = context.getNumberFormat();
        if (f != null) {
            StringFormatter.serialize(context, f.format(num), out);
        } else {
            out.append(Integer.toString(num));
        }
    }

    public void format(JSON.Context context, long num, OutputSource out) throws Exception {
        NumberFormat f = context.getNumberFormat();
        if (f != null) {
            StringFormatter.serialize(context, f.format(num), out);
        } else {
            out.append(Long.toString(num));
        }
    }
}

