/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.lang.reflect.Type;
import java.time.Year;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import net.arnx.jsonic.Converter;
import net.arnx.jsonic.DateTimeFormatterProvider;
import net.arnx.jsonic.JSON;

final class YearConverter
implements Converter {
    @Override
    public boolean accept(Class<?> cls) {
        return Year.class == cls;
    }

    @Override
    public Object convert(JSON.Context context, Object value, Class<?> c, Type t) throws Exception {
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            value = ((Map)value).get(null);
        } else if (value instanceof List) {
            List src = (List)value;
            Object object = value = !src.isEmpty() ? (Object)src.get(0) : null;
        }
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return Year.of(((Number)value).intValue());
        }
        if (value instanceof String) {
            String format = context.getDateFormatText();
            if (format != null) {
                return Year.parse((String)value, context.getLocalCache().get(DateTimeFormatter.class, format, DateTimeFormatterProvider.INSTANCE));
            }
            return Year.parse((String)value);
        }
        throw new UnsupportedOperationException("Cannot convert " + value.getClass() + " to " + t);
    }
}

