/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import nu.validator.htmlparser.annotation.Auto;
import nu.validator.htmlparser.annotation.Const;
import nu.validator.htmlparser.annotation.Inline;
import nu.validator.htmlparser.annotation.Literal;
import nu.validator.htmlparser.annotation.Local;
import nu.validator.htmlparser.annotation.NoLength;
import nu.validator.htmlparser.annotation.NsUri;
import nu.validator.htmlparser.common.DoctypeExpectation;
import nu.validator.htmlparser.common.DocumentMode;
import nu.validator.htmlparser.common.DocumentModeHandler;
import nu.validator.htmlparser.common.Interner;
import nu.validator.htmlparser.common.TokenHandler;
import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.impl.AttributeName;
import nu.validator.htmlparser.impl.ElementName;
import nu.validator.htmlparser.impl.HtmlAttributes;
import nu.validator.htmlparser.impl.LocatorImpl;
import nu.validator.htmlparser.impl.NCName;
import nu.validator.htmlparser.impl.Portability;
import nu.validator.htmlparser.impl.StackNode;
import nu.validator.htmlparser.impl.StateSnapshot;
import nu.validator.htmlparser.impl.TaintableLocatorImpl;
import nu.validator.htmlparser.impl.Tokenizer;
import nu.validator.htmlparser.impl.TreeBuilderState;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class TreeBuilder<T>
implements TokenHandler,
TreeBuilderState<T> {
    @NoLength
    private static final char[] REPLACEMENT_CHARACTER = new char[]{'\ufffd'};
    static final int OTHER = 0;
    static final int A = 1;
    static final int BASE = 2;
    static final int BODY = 3;
    static final int BR = 4;
    static final int BUTTON = 5;
    static final int CAPTION = 6;
    static final int COL = 7;
    static final int COLGROUP = 8;
    static final int FORM = 9;
    static final int FRAME = 10;
    static final int FRAMESET = 11;
    static final int IMAGE = 12;
    static final int INPUT = 13;
    static final int ISINDEX = 14;
    static final int LI = 15;
    static final int LINK_OR_BASEFONT_OR_BGSOUND = 16;
    static final int MATH = 17;
    static final int META = 18;
    static final int SVG = 19;
    static final int HEAD = 20;
    static final int HR = 22;
    static final int HTML = 23;
    static final int NOBR = 24;
    static final int NOFRAMES = 25;
    static final int NOSCRIPT = 26;
    static final int OPTGROUP = 27;
    static final int OPTION = 28;
    static final int P = 29;
    static final int PLAINTEXT = 30;
    static final int SCRIPT = 31;
    static final int SELECT = 32;
    static final int STYLE = 33;
    static final int TABLE = 34;
    static final int TEXTAREA = 35;
    static final int TITLE = 36;
    static final int TR = 37;
    static final int XMP = 38;
    static final int TBODY_OR_THEAD_OR_TFOOT = 39;
    static final int TD_OR_TH = 40;
    static final int DD_OR_DT = 41;
    static final int H1_OR_H2_OR_H3_OR_H4_OR_H5_OR_H6 = 42;
    static final int MARQUEE_OR_APPLET = 43;
    static final int PRE_OR_LISTING = 44;
    static final int B_OR_BIG_OR_CODE_OR_EM_OR_I_OR_S_OR_SMALL_OR_STRIKE_OR_STRONG_OR_TT_OR_U = 45;
    static final int UL_OR_OL_OR_DL = 46;
    static final int IFRAME = 47;
    static final int EMBED = 48;
    static final int AREA_OR_WBR = 49;
    static final int DIV_OR_BLOCKQUOTE_OR_CENTER_OR_MENU = 50;
    static final int ADDRESS_OR_ARTICLE_OR_ASIDE_OR_DETAILS_OR_DIALOG_OR_DIR_OR_FIGCAPTION_OR_FIGURE_OR_FOOTER_OR_HEADER_OR_HGROUP_OR_MAIN_OR_NAV_OR_SECTION_OR_SUMMARY = 51;
    static final int RUBY_OR_SPAN_OR_SUB_OR_SUP_OR_VAR = 52;
    static final int RB_OR_RTC = 53;
    static final int PARAM_OR_SOURCE_OR_TRACK = 55;
    static final int MGLYPH_OR_MALIGNMARK = 56;
    static final int MI_MO_MN_MS_MTEXT = 57;
    static final int ANNOTATION_XML = 58;
    static final int FOREIGNOBJECT_OR_DESC = 59;
    static final int NOEMBED = 60;
    static final int FIELDSET = 61;
    static final int OUTPUT = 62;
    static final int OBJECT = 63;
    static final int FONT = 64;
    static final int KEYGEN = 65;
    static final int MENUITEM = 66;
    static final int TEMPLATE = 67;
    static final int IMG = 68;
    static final int RT_OR_RP = 69;
    private static final int IN_ROW = 0;
    private static final int IN_TABLE_BODY = 1;
    private static final int IN_TABLE = 2;
    private static final int IN_CAPTION = 3;
    private static final int IN_CELL = 4;
    private static final int FRAMESET_OK = 5;
    private static final int IN_BODY = 6;
    private static final int IN_HEAD = 7;
    private static final int IN_HEAD_NOSCRIPT = 8;
    private static final int IN_COLUMN_GROUP = 9;
    private static final int IN_SELECT_IN_TABLE = 10;
    private static final int IN_SELECT = 11;
    private static final int AFTER_BODY = 12;
    private static final int IN_FRAMESET = 13;
    private static final int AFTER_FRAMESET = 14;
    private static final int INITIAL = 15;
    private static final int BEFORE_HTML = 16;
    private static final int BEFORE_HEAD = 17;
    private static final int AFTER_HEAD = 18;
    private static final int AFTER_AFTER_BODY = 19;
    private static final int AFTER_AFTER_FRAMESET = 20;
    private static final int TEXT = 21;
    private static final int IN_TEMPLATE = 22;
    private static final int CHARSET_INITIAL = 0;
    private static final int CHARSET_C = 1;
    private static final int CHARSET_H = 2;
    private static final int CHARSET_A = 3;
    private static final int CHARSET_R = 4;
    private static final int CHARSET_S = 5;
    private static final int CHARSET_E = 6;
    private static final int CHARSET_T = 7;
    private static final int CHARSET_EQUALS = 8;
    private static final int CHARSET_SINGLE_QUOTED = 9;
    private static final int CHARSET_DOUBLE_QUOTED = 10;
    private static final int CHARSET_UNQUOTED = 11;
    private static final String[] HTML4_PUBLIC_IDS = new String[]{"-//W3C//DTD HTML 4.0 Frameset//EN", "-//W3C//DTD HTML 4.0 Transitional//EN", "-//W3C//DTD HTML 4.0//EN", "-//W3C//DTD HTML 4.01 Frameset//EN", "-//W3C//DTD HTML 4.01 Transitional//EN", "-//W3C//DTD HTML 4.01//EN"};
    @Literal
    private static final String[] QUIRKY_PUBLIC_IDS = new String[]{"+//silmaril//dtd html pro v0r11 19970101//", "-//advasoft ltd//dtd html 3.0 aswedit + extensions//", "-//as//dtd html 3.0 aswedit + extensions//", "-//ietf//dtd html 2.0 level 1//", "-//ietf//dtd html 2.0 level 2//", "-//ietf//dtd html 2.0 strict level 1//", "-//ietf//dtd html 2.0 strict level 2//", "-//ietf//dtd html 2.0 strict//", "-//ietf//dtd html 2.0//", "-//ietf//dtd html 2.1e//", "-//ietf//dtd html 3.0//", "-//ietf//dtd html 3.2 final//", "-//ietf//dtd html 3.2//", "-//ietf//dtd html 3//", "-//ietf//dtd html level 0//", "-//ietf//dtd html level 1//", "-//ietf//dtd html level 2//", "-//ietf//dtd html level 3//", "-//ietf//dtd html strict level 0//", "-//ietf//dtd html strict level 1//", "-//ietf//dtd html strict level 2//", "-//ietf//dtd html strict level 3//", "-//ietf//dtd html strict//", "-//ietf//dtd html//", "-//metrius//dtd metrius presentational//", "-//microsoft//dtd internet explorer 2.0 html strict//", "-//microsoft//dtd internet explorer 2.0 html//", "-//microsoft//dtd internet explorer 2.0 tables//", "-//microsoft//dtd internet explorer 3.0 html strict//", "-//microsoft//dtd internet explorer 3.0 html//", "-//microsoft//dtd internet explorer 3.0 tables//", "-//netscape comm. corp.//dtd html//", "-//netscape comm. corp.//dtd strict html//", "-//o'reilly and associates//dtd html 2.0//", "-//o'reilly and associates//dtd html extended 1.0//", "-//o'reilly and associates//dtd html extended relaxed 1.0//", "-//softquad software//dtd hotmetal pro 6.0::19990601::extensions to html 4.0//", "-//softquad//dtd hotmetal pro 4.0::19971010::extensions to html 4.0//", "-//spyglass//dtd html 2.0 extended//", "-//sq//dtd html 2.0 hotmetal + extensions//", "-//sun microsystems corp.//dtd hotjava html//", "-//sun microsystems corp.//dtd hotjava strict html//", "-//w3c//dtd html 3 1995-03-24//", "-//w3c//dtd html 3.2 draft//", "-//w3c//dtd html 3.2 final//", "-//w3c//dtd html 3.2//", "-//w3c//dtd html 3.2s draft//", "-//w3c//dtd html 4.0 frameset//", "-//w3c//dtd html 4.0 transitional//", "-//w3c//dtd html experimental 19960712//", "-//w3c//dtd html experimental 970421//", "-//w3c//dtd w3 html//", "-//w3o//dtd w3 html 3.0//", "-//webtechs//dtd mozilla html 2.0//", "-//webtechs//dtd mozilla html//"};
    private static final int NOT_FOUND_ON_STACK = Integer.MAX_VALUE;
    @Local
    private static final String HTML_LOCAL = "html";
    private int mode = 15;
    private int originalMode = 15;
    private boolean framesetOk = true;
    protected Tokenizer tokenizer;
    protected ErrorHandler errorHandler;
    private DocumentModeHandler documentModeHandler;
    private DoctypeExpectation doctypeExpectation = DoctypeExpectation.HTML;
    private boolean scriptingEnabled = false;
    private boolean needToDropLF;
    private boolean wantingComments;
    private boolean fragment = false;
    @Local
    private String contextName;
    @NsUri
    private String contextNamespace;
    private T contextNode;
    @Auto
    private int[] templateModeStack;
    private int templateModePtr = -1;
    @Auto
    private StackNode<T>[] stackNodes;
    private int stackNodesIdx = -1;
    private int numStackNodes = 0;
    @Auto
    private StackNode<T>[] stack;
    private int currentPtr = -1;
    @Auto
    private StackNode<T>[] listOfActiveFormattingElements;
    private int listPtr = -1;
    private T formPointer;
    private T headPointer;
    private T deepTreeSurrogateParent;
    @Auto
    protected char[] charBuffer;
    protected int charBufferLen = 0;
    private boolean quirks = false;
    private boolean isSrcdocDocument = false;
    private boolean reportingDoctype = true;
    private XmlViolationPolicy namePolicy = XmlViolationPolicy.ALTER_INFOSET;
    private final Map<String, LocatorImpl> idLocations = new HashMap<String, LocatorImpl>();
    private boolean html4;

    protected TreeBuilder() {
    }

    protected void fatal() throws SAXException {
    }

    protected final void fatal(Exception e) throws SAXException {
        SAXParseException spe = new SAXParseException(e.getMessage(), this.tokenizer, e);
        if (this.errorHandler != null) {
            this.errorHandler.fatalError(spe);
        }
        throw spe;
    }

    final void fatal(String s) throws SAXException {
        SAXParseException spe = new SAXParseException(s, this.tokenizer);
        if (this.errorHandler != null) {
            this.errorHandler.fatalError(spe);
        }
        throw spe;
    }

    final void err(String message) throws SAXException {
        if (this.errorHandler == null) {
            return;
        }
        this.errNoCheck(message);
    }

    final void errNoCheck(String message) throws SAXException {
        SAXParseException spe = new SAXParseException(message, this.tokenizer);
        this.errorHandler.error(spe);
    }

    private void errListUnclosedStartTags(int eltPos) throws SAXException {
        if (this.currentPtr != -1) {
            for (int i = this.currentPtr; i > eltPos; --i) {
                this.reportUnclosedElementNameAndLocation(i);
            }
        }
    }

    private final void reportUnclosedElementNameAndLocation(int pos) throws SAXException {
        StackNode<T> node = this.stack[pos];
        if (node.isOptionalEndTag()) {
            return;
        }
        TaintableLocatorImpl locator = node.getLocator();
        if (locator.isTainted()) {
            return;
        }
        locator.markTainted();
        SAXParseException spe = new SAXParseException("Unclosed element \u201c" + node.popName + "\u201d.", locator);
        this.errorHandler.error(spe);
    }

    final void warn(String message) throws SAXException {
        if (this.errorHandler == null) {
            return;
        }
        SAXParseException spe = new SAXParseException(message, this.tokenizer);
        this.errorHandler.warning(spe);
    }

    final void warn(String message, Locator locator) throws SAXException {
        if (this.errorHandler == null) {
            return;
        }
        SAXParseException spe = new SAXParseException(message, locator);
        this.errorHandler.warning(spe);
    }

    @Override
    public final void startTokenization(Tokenizer self) throws SAXException {
        this.tokenizer = self;
        this.stackNodes = new StackNode[64];
        this.stack = new StackNode[64];
        this.templateModeStack = new int[64];
        this.listOfActiveFormattingElements = new StackNode[64];
        this.needToDropLF = false;
        this.originalMode = 15;
        this.templateModePtr = -1;
        this.stackNodesIdx = 0;
        this.numStackNodes = 0;
        this.currentPtr = -1;
        this.listPtr = -1;
        this.formPointer = null;
        this.headPointer = null;
        this.deepTreeSurrogateParent = null;
        this.html4 = false;
        this.idLocations.clear();
        this.wantingComments = this.wantsComments();
        this.start(this.fragment);
        this.charBufferLen = 0;
        this.charBuffer = null;
        this.framesetOk = true;
        if (this.fragment) {
            T elt = this.contextNode != null ? this.contextNode : this.createHtmlElementSetAsRoot(this.tokenizer.emptyAttributes());
            if (this.contextNamespace == "http://www.w3.org/2000/svg") {
                ElementName elementName = ElementName.SVG;
                if ("title" == this.contextName || "desc" == this.contextName || "foreignObject" == this.contextName) {
                    elementName = ElementName.FOREIGNOBJECT;
                }
                StackNode<T> node = this.createStackNode(elementName, elementName.getCamelCaseName(), elt, this.errorHandler == null ? null : new TaintableLocatorImpl(this.tokenizer));
                ++this.currentPtr;
                this.stack[this.currentPtr] = node;
                this.tokenizer.setStateAndEndTagExpectation(0, this.contextName);
                this.mode = 5;
            } else if (this.contextNamespace == "http://www.w3.org/1998/Math/MathML") {
                ElementName elementName = ElementName.MATH;
                if ("mi" == this.contextName || "mo" == this.contextName || "mn" == this.contextName || "ms" == this.contextName || "mtext" == this.contextName) {
                    elementName = ElementName.MTEXT;
                } else if ("annotation-xml" == this.contextName) {
                    elementName = ElementName.ANNOTATION_XML;
                }
                StackNode<T> node = this.createStackNode(elementName, elt, elementName.getName(), false, this.errorHandler == null ? null : new TaintableLocatorImpl(this.tokenizer));
                ++this.currentPtr;
                this.stack[this.currentPtr] = node;
                this.tokenizer.setStateAndEndTagExpectation(0, this.contextName);
                this.mode = 5;
            } else {
                StackNode<T> node = this.createStackNode(ElementName.HTML, elt, this.errorHandler == null ? null : new TaintableLocatorImpl(this.tokenizer));
                ++this.currentPtr;
                this.stack[this.currentPtr] = node;
                if ("template" == this.contextName) {
                    this.pushTemplateMode(22);
                }
                this.resetTheInsertionMode();
                this.formPointer = this.getFormPointerForContext(this.contextNode);
                if ("title" == this.contextName || "textarea" == this.contextName) {
                    this.tokenizer.setStateAndEndTagExpectation(1, this.contextName);
                } else if ("style" == this.contextName || "xmp" == this.contextName || "iframe" == this.contextName || "noembed" == this.contextName || "noframes" == this.contextName || this.scriptingEnabled && "noscript" == this.contextName) {
                    this.tokenizer.setStateAndEndTagExpectation(3, this.contextName);
                } else if ("plaintext" == this.contextName) {
                    this.tokenizer.setStateAndEndTagExpectation(8, this.contextName);
                } else if ("script" == this.contextName) {
                    this.tokenizer.setStateAndEndTagExpectation(2, this.contextName);
                } else {
                    this.tokenizer.setStateAndEndTagExpectation(0, this.contextName);
                }
            }
            this.contextName = null;
            this.contextNode = null;
        } else {
            this.mode = 15;
        }
    }

    @Override
    public final void doctype(@Local String name, String publicIdentifier, String systemIdentifier, boolean forceQuirks) throws SAXException {
        this.needToDropLF = false;
        if (!this.isInForeign() && this.mode == 15) {
            if (this.reportingDoctype) {
                String emptyString = Portability.newEmptyString();
                this.appendDoctypeToDocument(name == null ? "" : name, publicIdentifier == null ? emptyString : publicIdentifier, systemIdentifier == null ? emptyString : systemIdentifier);
                Portability.releaseString(emptyString);
            }
            switch (this.doctypeExpectation) {
                case HTML: {
                    if (this.isQuirky(name, publicIdentifier, systemIdentifier, forceQuirks)) {
                        this.errQuirkyDoctype();
                        this.documentModeInternal(DocumentMode.QUIRKS_MODE, publicIdentifier, systemIdentifier, false);
                        break;
                    }
                    if (this.isAlmostStandards(publicIdentifier, systemIdentifier)) {
                        this.errAlmostStandardsDoctype();
                        this.documentModeInternal(DocumentMode.ALMOST_STANDARDS_MODE, publicIdentifier, systemIdentifier, false);
                        break;
                    }
                    if (Portability.literalEqualsString("-//W3C//DTD HTML 4.0//EN", publicIdentifier) && (systemIdentifier == null || Portability.literalEqualsString("http://www.w3.org/TR/REC-html40/strict.dtd", systemIdentifier)) || Portability.literalEqualsString("-//W3C//DTD HTML 4.01//EN", publicIdentifier) && (systemIdentifier == null || Portability.literalEqualsString("http://www.w3.org/TR/html4/strict.dtd", systemIdentifier)) || Portability.literalEqualsString("-//W3C//DTD XHTML 1.0 Strict//EN", publicIdentifier) && Portability.literalEqualsString("http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd", systemIdentifier) || Portability.literalEqualsString("-//W3C//DTD XHTML 1.1//EN", publicIdentifier) && Portability.literalEqualsString("http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd", systemIdentifier)) {
                        this.warn("Obsolete doctype. Expected \u201c<!DOCTYPE html>\u201d.");
                    } else if (systemIdentifier != null && !Portability.literalEqualsString("about:legacy-compat", systemIdentifier) || publicIdentifier != null) {
                        this.err("Legacy doctype. Expected \u201c<!DOCTYPE html>\u201d.");
                    }
                    this.documentModeInternal(DocumentMode.STANDARDS_MODE, publicIdentifier, systemIdentifier, false);
                    break;
                }
                case HTML401_STRICT: {
                    this.html4 = true;
                    this.tokenizer.turnOnAdditionalHtml4Errors();
                    if (this.isQuirky(name, publicIdentifier, systemIdentifier, forceQuirks)) {
                        this.err("Quirky doctype. Expected \u201c<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">\u201d.");
                        this.documentModeInternal(DocumentMode.QUIRKS_MODE, publicIdentifier, systemIdentifier, true);
                        break;
                    }
                    if (this.isAlmostStandards(publicIdentifier, systemIdentifier)) {
                        this.err("Almost standards mode doctype. Expected \u201c<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">\u201d.");
                        this.documentModeInternal(DocumentMode.ALMOST_STANDARDS_MODE, publicIdentifier, systemIdentifier, true);
                        break;
                    }
                    if ("-//W3C//DTD HTML 4.01//EN".equals(publicIdentifier)) {
                        if (!"http://www.w3.org/TR/html4/strict.dtd".equals(systemIdentifier)) {
                            this.warn("The doctype did not contain the system identifier prescribed by the HTML 4.01 specification. Expected \u201c<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">\u201d.");
                        }
                    } else {
                        this.err("The doctype was not the HTML 4.01 Strict doctype. Expected \u201c<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">\u201d.");
                    }
                    this.documentModeInternal(DocumentMode.STANDARDS_MODE, publicIdentifier, systemIdentifier, true);
                    break;
                }
                case HTML401_TRANSITIONAL: {
                    this.html4 = true;
                    this.tokenizer.turnOnAdditionalHtml4Errors();
                    if (this.isQuirky(name, publicIdentifier, systemIdentifier, forceQuirks)) {
                        this.err("Quirky doctype. Expected \u201c<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\u201d.");
                        this.documentModeInternal(DocumentMode.QUIRKS_MODE, publicIdentifier, systemIdentifier, true);
                        break;
                    }
                    if (this.isAlmostStandards(publicIdentifier, systemIdentifier)) {
                        if ("-//W3C//DTD HTML 4.01 Transitional//EN".equals(publicIdentifier) && systemIdentifier != null) {
                            if (!"http://www.w3.org/TR/html4/loose.dtd".equals(systemIdentifier)) {
                                this.warn("The doctype did not contain the system identifier prescribed by the HTML 4.01 specification. Expected \u201c<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\u201d.");
                            }
                        } else {
                            this.err("The doctype was not a non-quirky HTML 4.01 Transitional doctype. Expected \u201c<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\u201d.");
                        }
                        this.documentModeInternal(DocumentMode.ALMOST_STANDARDS_MODE, publicIdentifier, systemIdentifier, true);
                        break;
                    }
                    this.err("The doctype was not the HTML 4.01 Transitional doctype. Expected \u201c<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\u201d.");
                    this.documentModeInternal(DocumentMode.STANDARDS_MODE, publicIdentifier, systemIdentifier, true);
                    break;
                }
                case AUTO: {
                    this.html4 = this.isHtml4Doctype(publicIdentifier);
                    if (this.html4) {
                        this.tokenizer.turnOnAdditionalHtml4Errors();
                    }
                    if (this.isQuirky(name, publicIdentifier, systemIdentifier, forceQuirks)) {
                        this.err("Quirky doctype. Expected e.g. \u201c<!DOCTYPE html>\u201d.");
                        this.documentModeInternal(DocumentMode.QUIRKS_MODE, publicIdentifier, systemIdentifier, this.html4);
                        break;
                    }
                    if (this.isAlmostStandards(publicIdentifier, systemIdentifier)) {
                        this.errAlmostStandardsDoctype();
                        this.documentModeInternal(DocumentMode.ALMOST_STANDARDS_MODE, publicIdentifier, systemIdentifier, this.html4);
                        break;
                    }
                    if ("-//W3C//DTD HTML 4.01//EN".equals(publicIdentifier)) {
                        if (!"http://www.w3.org/TR/html4/strict.dtd".equals(systemIdentifier)) {
                            this.warn("The doctype did not contain the system identifier prescribed by the HTML 4.01 specification. Expected \u201c<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">\u201d.");
                        }
                    } else if ("-//W3C//DTD XHTML 1.0 Strict//EN".equals(publicIdentifier)) {
                        if (!"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd".equals(systemIdentifier)) {
                            this.warn("The doctype did not contain the system identifier prescribed by the XHTML 1.0 specification. Expected \u201c<!DOCTYPE HTML PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\u201d.");
                        }
                    } else if ("//W3C//DTD XHTML 1.1//EN".equals(publicIdentifier)) {
                        if (!"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd".equals(systemIdentifier)) {
                            this.warn("The doctype did not contain the system identifier prescribed by the XHTML 1.1 specification. Expected \u201c<!DOCTYPE HTML PUBLIC \"//W3C//DTD XHTML 1.1//EN\" \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">\u201d.");
                        }
                    } else if (systemIdentifier != null && !Portability.literalEqualsString("about:legacy-compat", systemIdentifier) || publicIdentifier != null) {
                        this.err("Unexpected doctype. Expected, e.g., \u201c<!DOCTYPE html>\u201d.");
                    }
                    this.documentModeInternal(DocumentMode.STANDARDS_MODE, publicIdentifier, systemIdentifier, this.html4);
                    break;
                }
                case NO_DOCTYPE_ERRORS: {
                    if (this.isQuirky(name, publicIdentifier, systemIdentifier, forceQuirks)) {
                        this.documentModeInternal(DocumentMode.QUIRKS_MODE, publicIdentifier, systemIdentifier, false);
                        break;
                    }
                    if (this.isAlmostStandards(publicIdentifier, systemIdentifier)) {
                        this.documentModeInternal(DocumentMode.ALMOST_STANDARDS_MODE, publicIdentifier, systemIdentifier, false);
                        break;
                    }
                    this.documentModeInternal(DocumentMode.STANDARDS_MODE, publicIdentifier, systemIdentifier, false);
                }
            }
            this.mode = 16;
            return;
        }
        this.errStrayDoctype();
    }

    private boolean isHtml4Doctype(String publicIdentifier) {
        return publicIdentifier != null && Arrays.binarySearch(HTML4_PUBLIC_IDS, publicIdentifier) > -1;
    }

    @Override
    public final void comment(@NoLength char[] buf, int start, int length) throws SAXException {
        this.needToDropLF = false;
        if (!this.wantingComments) {
            return;
        }
        if (!this.isInForeign()) {
            switch (this.mode) {
                case 15: 
                case 16: 
                case 19: 
                case 20: {
                    this.appendCommentToDocument(buf, start, length);
                    return;
                }
                case 12: {
                    this.flushCharacters();
                    this.appendComment(this.stack[0].node, buf, start, length);
                    return;
                }
            }
        }
        this.flushCharacters();
        this.appendComment(this.stack[this.currentPtr].node, buf, start, length);
    }

    /*
     * Exception decompiling
     */
    @Override
    public final void characters(@Const @NoLength char[] buf, int start, int length) throws SAXException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CASE]], but top level block is 8[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void zeroOriginatingReplacementCharacter() throws SAXException {
        if (this.mode == 21) {
            this.accumulateCharacters(REPLACEMENT_CHARACTER, 0, 1);
            return;
        }
        if (this.currentPtr >= 0) {
            if (this.isSpecialParentInForeign(this.stack[this.currentPtr])) {
                return;
            }
            this.accumulateCharacters(REPLACEMENT_CHARACTER, 0, 1);
        }
    }

    @Override
    public final void eof() throws SAXException {
        this.flushCharacters();
        block21: while (true) {
            switch (this.mode) {
                case 15: {
                    switch (this.doctypeExpectation) {
                        case AUTO: {
                            this.err("End of file seen without seeing a doctype first. Expected e.g. \u201c<!DOCTYPE html>\u201d.");
                            break;
                        }
                        case HTML: {
                            this.err("End of file seen without seeing a doctype first. Expected \u201c<!DOCTYPE html>\u201d.");
                            break;
                        }
                        case HTML401_STRICT: {
                            this.err("End of file seen without seeing a doctype first. Expected \u201c<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">\u201d.");
                            break;
                        }
                        case HTML401_TRANSITIONAL: {
                            this.err("End of file seen without seeing a doctype first. Expected \u201c<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\u201d.");
                            break;
                        }
                    }
                    this.documentModeInternal(DocumentMode.QUIRKS_MODE, null, null, false);
                    this.mode = 16;
                    continue block21;
                }
                case 16: {
                    this.appendHtmlElementToDocumentAndPush();
                    this.mode = 17;
                    continue block21;
                }
                case 17: {
                    this.appendToCurrentNodeAndPushHeadElement(HtmlAttributes.EMPTY_ATTRIBUTES);
                    this.mode = 7;
                    continue block21;
                }
                case 7: {
                    if (this.errorHandler != null && this.currentPtr > 1) {
                        this.errEofWithUnclosedElements();
                    }
                    while (this.currentPtr > 0) {
                        this.popOnEof();
                    }
                    this.mode = 18;
                    continue block21;
                }
                case 8: {
                    this.errEofWithUnclosedElements();
                    while (this.currentPtr > 1) {
                        this.popOnEof();
                    }
                    this.mode = 7;
                    continue block21;
                }
                case 18: {
                    this.appendToCurrentNodeAndPushBodyElement();
                    this.mode = 6;
                    continue block21;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 11: {
                    block24: for (int i = this.currentPtr; i > 0; --i) {
                        int group = this.stack[i].getGroup();
                        switch (group) {
                            case 3: 
                            case 15: 
                            case 23: 
                            case 29: 
                            case 39: 
                            case 40: 
                            case 41: {
                                continue block24;
                            }
                            default: {
                                this.errEofWithUnclosedElements();
                                break block24;
                            }
                        }
                    }
                    if (this.isTemplateModeStackEmpty()) break block21;
                }
                case 22: {
                    int eltPos = this.findLast("template");
                    if (eltPos == Integer.MAX_VALUE) {
                        assert (this.fragment);
                        break block21;
                    }
                    if (this.errorHandler != null) {
                        this.errListUnclosedStartTags(0);
                    }
                    while (this.currentPtr >= eltPos) {
                        this.pop();
                    }
                    this.clearTheListOfActiveFormattingElementsUpToTheLastMarker();
                    this.popTemplateMode();
                    this.resetTheInsertionMode();
                    continue block21;
                }
                case 21: {
                    if (this.errorHandler != null) {
                        this.errNoCheck("End of file seen when expecting text or an end tag.");
                        this.errListUnclosedStartTags(0);
                    }
                    if (this.originalMode == 18) {
                        this.popOnEof();
                    }
                    this.popOnEof();
                    this.mode = this.originalMode;
                    continue block21;
                }
                case 13: {
                    if (this.errorHandler == null || this.currentPtr <= 0) break block21;
                    this.errEofWithUnclosedElements();
                    break block21;
                }
                default: {
                    if (this.currentPtr != 0) break block21;
                    System.currentTimeMillis();
                    break block21;
                }
            }
            break;
        }
        while (this.currentPtr > 0) {
            this.popOnEof();
        }
        if (!this.fragment) {
            this.popOnEof();
        }
    }

    @Override
    public final void endTokenization() throws SAXException {
        this.formPointer = null;
        this.headPointer = null;
        this.deepTreeSurrogateParent = null;
        this.templateModeStack = null;
        if (this.stack != null) {
            while (this.currentPtr > -1) {
                this.stack[this.currentPtr].release(this);
                --this.currentPtr;
            }
            this.stack = null;
        }
        if (this.listOfActiveFormattingElements != null) {
            while (this.listPtr > -1) {
                if (this.listOfActiveFormattingElements[this.listPtr] != null) {
                    this.listOfActiveFormattingElements[this.listPtr].release(this);
                }
                --this.listPtr;
            }
            this.listOfActiveFormattingElements = null;
        }
        if (this.stackNodes != null) {
            for (int i = 0; i < this.numStackNodes; ++i) {
                assert (this.stackNodes[i].isUnused());
                Portability.delete(this.stackNodes[i]);
            }
            this.numStackNodes = 0;
            this.stackNodesIdx = 0;
            this.stackNodes = null;
        }
        this.idLocations.clear();
        this.charBuffer = null;
        this.end();
    }

    /*
     * Exception decompiling
     */
    @Override
    public final void startTag(ElementName elementName, HtmlAttributes attributes, boolean selfClosing) throws SAXException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CASE]], but top level block is 62[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void startTagTitleInHead(ElementName elementName, HtmlAttributes attributes) throws SAXException {
        this.appendToCurrentNodeAndPushElementMayFoster(elementName, attributes);
        this.originalMode = this.mode;
        this.mode = 21;
        this.tokenizer.setStateAndEndTagExpectation(1, elementName);
    }

    private void startTagGenericRawText(ElementName elementName, HtmlAttributes attributes) throws SAXException {
        this.appendToCurrentNodeAndPushElementMayFoster(elementName, attributes);
        this.originalMode = this.mode;
        this.mode = 21;
        this.tokenizer.setStateAndEndTagExpectation(3, elementName);
    }

    private void startTagScriptInHead(ElementName elementName, HtmlAttributes attributes) throws SAXException {
        this.appendToCurrentNodeAndPushElementMayFoster(elementName, attributes);
        this.originalMode = this.mode;
        this.mode = 21;
        this.tokenizer.setStateAndEndTagExpectation(2, elementName);
    }

    private void startTagTemplateInHead(ElementName elementName, HtmlAttributes attributes) throws SAXException {
        this.appendToCurrentNodeAndPushElement(elementName, attributes);
        this.insertMarker();
        this.framesetOk = false;
        this.originalMode = this.mode;
        this.mode = 22;
        this.pushTemplateMode(22);
    }

    private boolean isTemplateContents() {
        return Integer.MAX_VALUE != this.findLast("template");
    }

    private boolean isTemplateModeStackEmpty() {
        return this.templateModePtr == -1;
    }

    private boolean isSpecialParentInForeign(StackNode<T> stackNode) {
        String ns = stackNode.ns;
        return "http://www.w3.org/1999/xhtml" == ns || stackNode.isHtmlIntegrationPoint() || "http://www.w3.org/1998/Math/MathML" == ns && stackNode.getGroup() == 57;
    }

    /*
     * Unable to fully structure code
     */
    public static String extractCharsetFromContent(String attributeValue) {
        charsetState = 0;
        start = -1;
        end = -1;
        buffer = Portability.newCharArrayFromString(attributeValue);
        block53: for (i = 0; i < buffer.length; ++i) {
            c = buffer[i];
            switch (charsetState) {
                case 0: {
                    switch (c) {
                        case 'C': 
                        case 'c': {
                            charsetState = 1;
                            break;
                        }
                    }
                    ** GOTO lbl111
                }
                case 1: {
                    switch (c) {
                        case 'H': 
                        case 'h': {
                            charsetState = 2;
                            break;
                        }
                        default: {
                            charsetState = 0;
                            break;
                        }
                    }
                    ** GOTO lbl111
                }
                case 2: {
                    switch (c) {
                        case 'A': 
                        case 'a': {
                            charsetState = 3;
                            break;
                        }
                        default: {
                            charsetState = 0;
                            break;
                        }
                    }
                    ** GOTO lbl111
                }
                case 3: {
                    switch (c) {
                        case 'R': 
                        case 'r': {
                            charsetState = 4;
                            break;
                        }
                        default: {
                            charsetState = 0;
                            break;
                        }
                    }
                    ** GOTO lbl111
                }
                case 4: {
                    switch (c) {
                        case 'S': 
                        case 's': {
                            charsetState = 5;
                            break;
                        }
                        default: {
                            charsetState = 0;
                            break;
                        }
                    }
                    ** GOTO lbl111
                }
                case 5: {
                    switch (c) {
                        case 'E': 
                        case 'e': {
                            charsetState = 6;
                            break;
                        }
                        default: {
                            charsetState = 0;
                            break;
                        }
                    }
                    ** GOTO lbl111
                }
                case 6: {
                    switch (c) {
                        case 'T': 
                        case 't': {
                            charsetState = 7;
                            break;
                        }
                        default: {
                            charsetState = 0;
                            break;
                        }
                    }
                    ** GOTO lbl111
                }
                case 7: {
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            ** GOTO lbl111
                        }
                        case '=': {
                            charsetState = 8;
                            ** GOTO lbl111
                        }
                        default: {
                            return null;
                        }
                    }
                }
                case 8: {
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            break;
                        }
                        case '\'': {
                            start = i + 1;
                            charsetState = 9;
                            break;
                        }
                        case '\"': {
                            start = i + 1;
                            charsetState = 10;
                            break;
                        }
                        default: {
                            start = i;
                            charsetState = 11;
                            break;
                        }
                    }
                    ** GOTO lbl111
                }
                case 9: {
                    switch (c) {
                        case '\'': {
                            end = i;
                            break block53;
                        }
                    }
                    ** GOTO lbl111
                }
                case 10: {
                    switch (c) {
                        case '\"': {
                            end = i;
                            break block53;
                        }
                    }
                    ** GOTO lbl111
                }
                case 11: {
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': 
                        case ';': {
                            end = i;
                            break block53;
                        }
                    }
                }
lbl111:
                // 14 sources

                default: {
                    continue block53;
                }
            }
        }
        charset = null;
        if (start != -1) {
            if (end == -1) {
                end = buffer.length;
            }
            charset = Portability.newStringFromBuffer(buffer, start, end - start);
        }
        return charset;
    }

    private void checkMetaCharset(HtmlAttributes attributes) throws SAXException {
        String charset = attributes.getValue(AttributeName.CHARSET);
        if (charset != null) {
            if (this.tokenizer.internalEncodingDeclaration(charset)) {
                this.requestSuspension();
                return;
            }
            return;
        }
        if (!Portability.lowerCaseLiteralEqualsIgnoreAsciiCaseString("content-type", attributes.getValue(AttributeName.HTTP_EQUIV))) {
            return;
        }
        String content = attributes.getValue(AttributeName.CONTENT);
        if (content != null) {
            String extract = TreeBuilder.extractCharsetFromContent(content);
            if (extract != null && this.tokenizer.internalEncodingDeclaration(extract)) {
                this.requestSuspension();
            }
            Portability.releaseString(extract);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final void endTag(ElementName elementName) throws SAXException {
        this.flushCharacters();
        this.needToDropLF = false;
        int group = elementName.getGroup();
        String name = elementName.getName();
        block123: while (true) {
            int eltPos;
            if (this.isInForeign()) {
                if (this.stack[this.currentPtr].name != name) {
                    if (this.currentPtr == 0) {
                        this.errStrayEndTag(name);
                    } else {
                        this.errEndTagDidNotMatchCurrentOpenElement(name, this.stack[this.currentPtr].popName);
                    }
                }
                eltPos = this.currentPtr;
                do {
                    if (eltPos == 0) {
                        if ($assertionsDisabled) return;
                        if (this.fragment) return;
                        throw new AssertionError((Object)"We can get this close to the root of the stack in foreign content only in the fragment case.");
                    }
                    if (this.stack[eltPos].name != name) continue;
                    while (this.currentPtr >= eltPos) {
                        this.pop();
                    }
                    return;
                } while (this.stack[--eltPos].ns != "http://www.w3.org/1999/xhtml");
            }
            switch (this.mode) {
                case 22: {
                    switch (group) {
                        case 67: {
                            break;
                        }
                        default: {
                            this.errStrayEndTag(name);
                            return;
                        }
                    }
                }
                case 0: {
                    switch (group) {
                        case 37: {
                            eltPos = this.findLastOrRoot(37);
                            if (eltPos != 0) {
                                this.clearStackBackTo(eltPos);
                                this.pop();
                                this.mode = 1;
                                return;
                            }
                            assert (this.fragment || this.isTemplateContents());
                            this.errNoTableRowToClose();
                            return;
                        }
                        case 34: {
                            eltPos = this.findLastOrRoot(37);
                            if (eltPos == 0) {
                                assert (this.fragment || this.isTemplateContents());
                                this.errNoTableRowToClose();
                                return;
                            }
                            this.clearStackBackTo(eltPos);
                            this.pop();
                            this.mode = 1;
                            continue block123;
                        }
                        case 39: {
                            if (this.findLastInTableScope(name) == Integer.MAX_VALUE) {
                                this.errStrayEndTag(name);
                                return;
                            }
                            eltPos = this.findLastOrRoot(37);
                            if (eltPos == 0) {
                                assert (this.fragment || this.isTemplateContents());
                                this.errNoTableRowToClose();
                                return;
                            }
                            this.clearStackBackTo(eltPos);
                            this.pop();
                            this.mode = 1;
                            continue block123;
                        }
                        case 3: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 23: 
                        case 40: {
                            this.errStrayEndTag(name);
                            return;
                        }
                    }
                }
                case 1: {
                    switch (group) {
                        case 39: {
                            eltPos = this.findLastOrRoot(name);
                            if (eltPos == 0) {
                                this.errStrayEndTag(name);
                                return;
                            }
                            this.clearStackBackTo(eltPos);
                            this.pop();
                            this.mode = 2;
                            return;
                        }
                        case 34: {
                            eltPos = this.findLastInTableScopeOrRootTemplateTbodyTheadTfoot();
                            if (eltPos == 0 || this.stack[eltPos].getGroup() == 67) {
                                assert (this.fragment || this.isTemplateContents());
                                this.errStrayEndTag(name);
                                return;
                            }
                            this.clearStackBackTo(eltPos);
                            this.pop();
                            this.mode = 2;
                            continue block123;
                        }
                        case 3: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 23: 
                        case 37: 
                        case 40: {
                            this.errStrayEndTag(name);
                            return;
                        }
                    }
                }
                case 2: {
                    switch (group) {
                        case 34: {
                            eltPos = this.findLast("table");
                            if (eltPos == Integer.MAX_VALUE) {
                                assert (this.fragment || this.isTemplateContents());
                                this.errStrayEndTag(name);
                                return;
                            }
                            while (true) {
                                if (this.currentPtr < eltPos) {
                                    this.resetTheInsertionMode();
                                    return;
                                }
                                this.pop();
                            }
                        }
                        case 3: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 23: 
                        case 37: 
                        case 39: 
                        case 40: {
                            this.errStrayEndTag(name);
                            return;
                        }
                        case 67: {
                            break;
                        }
                        default: {
                            this.errStrayEndTag(name);
                        }
                    }
                }
                case 3: {
                    switch (group) {
                        case 6: {
                            eltPos = this.findLastInTableScope("caption");
                            if (eltPos == Integer.MAX_VALUE) {
                                return;
                            }
                            this.generateImpliedEndTags();
                            if (this.errorHandler != null && this.currentPtr != eltPos) {
                                this.errUnclosedElements(eltPos, name);
                            }
                            while (true) {
                                if (this.currentPtr < eltPos) {
                                    this.clearTheListOfActiveFormattingElementsUpToTheLastMarker();
                                    this.mode = 2;
                                    return;
                                }
                                this.pop();
                            }
                        }
                        case 34: {
                            this.errTableClosedWhileCaptionOpen();
                            eltPos = this.findLastInTableScope("caption");
                            if (eltPos == Integer.MAX_VALUE) {
                                return;
                            }
                            this.generateImpliedEndTags();
                            if (this.errorHandler != null && this.currentPtr != eltPos) {
                                this.errUnclosedElements(eltPos, name);
                            }
                            while (this.currentPtr >= eltPos) {
                                this.pop();
                            }
                            this.clearTheListOfActiveFormattingElementsUpToTheLastMarker();
                            this.mode = 2;
                            continue block123;
                        }
                        case 3: 
                        case 7: 
                        case 8: 
                        case 23: 
                        case 37: 
                        case 39: 
                        case 40: {
                            this.errStrayEndTag(name);
                            return;
                        }
                    }
                }
                case 4: {
                    switch (group) {
                        case 40: {
                            eltPos = this.findLastInTableScope(name);
                            if (eltPos == Integer.MAX_VALUE) {
                                this.errStrayEndTag(name);
                                return;
                            }
                            this.generateImpliedEndTags();
                            if (this.errorHandler != null && !this.isCurrent(name)) {
                                this.errUnclosedElements(eltPos, name);
                            }
                            while (true) {
                                if (this.currentPtr < eltPos) {
                                    this.clearTheListOfActiveFormattingElementsUpToTheLastMarker();
                                    this.mode = 0;
                                    return;
                                }
                                this.pop();
                            }
                        }
                        case 34: 
                        case 37: 
                        case 39: {
                            if (this.findLastInTableScope(name) == Integer.MAX_VALUE) {
                                assert (name == "tbody" || name == "tfoot" || name == "thead" || this.fragment || this.isTemplateContents());
                                this.errStrayEndTag(name);
                                return;
                            }
                            this.closeTheCell(this.findLastInTableScopeTdTh());
                            continue block123;
                        }
                        case 3: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 23: {
                            this.errStrayEndTag(name);
                            return;
                        }
                    }
                }
                case 5: 
                case 6: {
                    switch (group) {
                        case 3: {
                            int i;
                            if (!this.isSecondOnStackBody()) {
                                assert (this.fragment || this.isTemplateContents());
                                this.errStrayEndTag(name);
                                return;
                            }
                            assert (this.currentPtr >= 1);
                            if (this.errorHandler != null) {
                                block130: for (i = 2; i <= this.currentPtr; ++i) {
                                    switch (this.stack[i].getGroup()) {
                                        case 15: 
                                        case 27: 
                                        case 28: 
                                        case 29: 
                                        case 39: 
                                        case 40: 
                                        case 41: 
                                        case 53: 
                                        case 69: {
                                            continue block130;
                                        }
                                        default: {
                                            this.errEndWithUnclosedElements(name);
                                            break block130;
                                        }
                                    }
                                }
                            }
                            this.mode = 12;
                            return;
                        }
                        case 23: {
                            int i;
                            if (!this.isSecondOnStackBody()) {
                                assert (this.fragment || this.isTemplateContents());
                                this.errStrayEndTag(name);
                                return;
                            }
                            if (this.errorHandler != null) {
                                block131: for (i = 0; i <= this.currentPtr; ++i) {
                                    switch (this.stack[i].getGroup()) {
                                        case 3: 
                                        case 15: 
                                        case 23: 
                                        case 29: 
                                        case 39: 
                                        case 40: 
                                        case 41: 
                                        case 53: 
                                        case 69: {
                                            continue block131;
                                        }
                                        default: {
                                            this.errEndWithUnclosedElements(name);
                                            break block131;
                                        }
                                    }
                                }
                            }
                            this.mode = 12;
                            continue block123;
                        }
                        case 5: 
                        case 44: 
                        case 46: 
                        case 50: 
                        case 51: 
                        case 61: {
                            eltPos = this.findLastInScope(name);
                            if (eltPos == Integer.MAX_VALUE) {
                                this.errStrayEndTag(name);
                                return;
                            }
                            this.generateImpliedEndTags();
                            if (this.errorHandler != null && !this.isCurrent(name)) {
                                this.errUnclosedElements(eltPos, name);
                            }
                            while (this.currentPtr >= eltPos) {
                                this.pop();
                            }
                            return;
                        }
                        case 9: {
                            if (!this.isTemplateContents()) {
                                if (this.formPointer == null) {
                                    this.errStrayEndTag(name);
                                    return;
                                }
                                this.formPointer = null;
                                eltPos = this.findLastInScope(name);
                                if (eltPos == Integer.MAX_VALUE) {
                                    this.errStrayEndTag(name);
                                    return;
                                }
                                this.generateImpliedEndTags();
                                if (this.errorHandler != null && !this.isCurrent(name)) {
                                    this.errUnclosedElements(eltPos, name);
                                }
                                this.removeFromStack(eltPos);
                                return;
                            }
                            eltPos = this.findLastInScope(name);
                            if (eltPos == Integer.MAX_VALUE) {
                                this.errStrayEndTag(name);
                                return;
                            }
                            this.generateImpliedEndTags();
                            if (this.errorHandler != null && !this.isCurrent(name)) {
                                this.errUnclosedElements(eltPos, name);
                            }
                            while (this.currentPtr >= eltPos) {
                                this.pop();
                            }
                            return;
                        }
                        case 29: {
                            eltPos = this.findLastInButtonScope("p");
                            if (eltPos == Integer.MAX_VALUE) {
                                this.errNoElementToCloseButEndTagSeen("p");
                                if (this.isInForeign()) {
                                    this.errHtmlStartTagInForeignContext(name);
                                    while (this.currentPtr >= 0 && this.stack[this.currentPtr].ns != "http://www.w3.org/1999/xhtml") {
                                        this.pop();
                                    }
                                }
                                this.appendVoidElementToCurrentMayFoster(elementName, HtmlAttributes.EMPTY_ATTRIBUTES);
                                return;
                            }
                            this.generateImpliedEndTagsExceptFor("p");
                            assert (eltPos != Integer.MAX_VALUE);
                            if (this.errorHandler != null && eltPos != this.currentPtr) {
                                this.errUnclosedElements(eltPos, name);
                            }
                            while (this.currentPtr >= eltPos) {
                                this.pop();
                            }
                            return;
                        }
                        case 15: {
                            eltPos = this.findLastInListScope(name);
                            if (eltPos == Integer.MAX_VALUE) {
                                this.errNoElementToCloseButEndTagSeen(name);
                                return;
                            }
                            this.generateImpliedEndTagsExceptFor(name);
                            if (this.errorHandler != null && eltPos != this.currentPtr) {
                                this.errUnclosedElements(eltPos, name);
                            }
                            while (this.currentPtr >= eltPos) {
                                this.pop();
                            }
                            return;
                        }
                        case 41: {
                            eltPos = this.findLastInScope(name);
                            if (eltPos == Integer.MAX_VALUE) {
                                this.errNoElementToCloseButEndTagSeen(name);
                                return;
                            }
                            this.generateImpliedEndTagsExceptFor(name);
                            if (this.errorHandler != null && eltPos != this.currentPtr) {
                                this.errUnclosedElements(eltPos, name);
                            }
                            while (this.currentPtr >= eltPos) {
                                this.pop();
                            }
                            return;
                        }
                        case 42: {
                            eltPos = this.findLastInScopeHn();
                            if (eltPos == Integer.MAX_VALUE) {
                                this.errStrayEndTag(name);
                                return;
                            }
                            this.generateImpliedEndTags();
                            if (this.errorHandler != null && !this.isCurrent(name)) {
                                this.errUnclosedElements(eltPos, name);
                            }
                            while (this.currentPtr >= eltPos) {
                                this.pop();
                            }
                            return;
                        }
                        case 43: 
                        case 63: {
                            eltPos = this.findLastInScope(name);
                            if (eltPos == Integer.MAX_VALUE) {
                                this.errStrayEndTag(name);
                                return;
                            }
                            this.generateImpliedEndTags();
                            if (this.errorHandler != null && !this.isCurrent(name)) {
                                this.errUnclosedElements(eltPos, name);
                            }
                            while (true) {
                                if (this.currentPtr < eltPos) {
                                    this.clearTheListOfActiveFormattingElementsUpToTheLastMarker();
                                    return;
                                }
                                this.pop();
                            }
                        }
                        case 4: {
                            this.errEndTagBr();
                            if (this.isInForeign()) {
                                this.errHtmlStartTagInForeignContext(name);
                                while (this.currentPtr >= 0 && this.stack[this.currentPtr].ns != "http://www.w3.org/1999/xhtml") {
                                    this.pop();
                                }
                            }
                            this.reconstructTheActiveFormattingElements();
                            this.appendVoidElementToCurrentMayFoster(elementName, HtmlAttributes.EMPTY_ATTRIBUTES);
                            return;
                        }
                        case 67: {
                            break;
                        }
                        case 12: 
                        case 13: 
                        case 22: 
                        case 25: 
                        case 32: 
                        case 34: 
                        case 35: 
                        case 47: 
                        case 48: 
                        case 49: 
                        case 55: 
                        case 60: 
                        case 65: 
                        case 68: {
                            this.errStrayEndTag(name);
                            return;
                        }
                        case 26: {
                            if (this.scriptingEnabled) {
                                this.errStrayEndTag(name);
                                return;
                            }
                        }
                        case 1: 
                        case 24: 
                        case 45: 
                        case 64: {
                            if (this.adoptionAgencyEndTag(name)) {
                                return;
                            }
                        }
                        default: {
                            if (this.isCurrent(name)) {
                                this.pop();
                                return;
                            }
                            eltPos = this.currentPtr;
                            while (true) {
                                StackNode<T> node = this.stack[eltPos];
                                if (node.ns == "http://www.w3.org/1999/xhtml" && node.name == name) {
                                    this.generateImpliedEndTags();
                                    if (this.errorHandler != null && !this.isCurrent(name)) {
                                        this.errUnclosedElements(eltPos, name);
                                    }
                                    while (this.currentPtr >= eltPos) {
                                        this.pop();
                                    }
                                    return;
                                }
                                if (eltPos == 0 || node.isSpecial()) {
                                    this.errStrayEndTag(name);
                                    return;
                                }
                                --eltPos;
                            }
                        }
                    }
                }
                case 7: {
                    switch (group) {
                        case 20: {
                            this.pop();
                            this.mode = 18;
                            return;
                        }
                        case 3: 
                        case 4: 
                        case 23: {
                            this.pop();
                            this.mode = 18;
                            continue block123;
                        }
                        case 67: {
                            this.endTagTemplateInHead();
                            return;
                        }
                    }
                    this.errStrayEndTag(name);
                    return;
                }
                case 8: {
                    switch (group) {
                        case 26: {
                            this.pop();
                            this.mode = 7;
                            return;
                        }
                        case 4: {
                            this.errStrayEndTag(name);
                            this.pop();
                            this.mode = 7;
                            continue block123;
                        }
                    }
                    this.errStrayEndTag(name);
                    return;
                }
                case 9: {
                    switch (group) {
                        case 8: {
                            if (this.currentPtr != 0 && this.stack[this.currentPtr].getGroup() != 67) {
                                this.pop();
                                this.mode = 2;
                                return;
                            }
                            assert (this.fragment || this.isTemplateContents());
                            this.errGarbageInColgroup();
                            return;
                        }
                        case 7: {
                            this.errStrayEndTag(name);
                            return;
                        }
                        case 67: {
                            this.endTagTemplateInHead();
                            return;
                        }
                    }
                    if (this.currentPtr == 0 || this.stack[this.currentPtr].getGroup() == 67) {
                        assert (this.fragment || this.isTemplateContents());
                        this.errGarbageInColgroup();
                        return;
                    }
                    this.pop();
                    this.mode = 2;
                    continue block123;
                }
                case 10: {
                    switch (group) {
                        case 6: 
                        case 34: 
                        case 37: 
                        case 39: 
                        case 40: {
                            this.errEndTagSeenWithSelectOpen(name);
                            if (this.findLastInTableScope(name) == Integer.MAX_VALUE) return;
                            eltPos = this.findLastInTableScope("select");
                            if (eltPos == Integer.MAX_VALUE) {
                                if ($assertionsDisabled) return;
                                if (this.fragment) return;
                                throw new AssertionError();
                            }
                            while (this.currentPtr >= eltPos) {
                                this.pop();
                            }
                            this.resetTheInsertionMode();
                            continue block123;
                        }
                    }
                }
                case 11: {
                    switch (group) {
                        case 28: {
                            if (this.isCurrent("option")) {
                                this.pop();
                                return;
                            }
                            this.errStrayEndTag(name);
                            return;
                        }
                        case 27: {
                            if (this.isCurrent("option") && "optgroup" == this.stack[this.currentPtr - 1].name) {
                                this.pop();
                            }
                            if (this.isCurrent("optgroup")) {
                                this.pop();
                                return;
                            }
                            this.errStrayEndTag(name);
                            return;
                        }
                        case 32: {
                            eltPos = this.findLastInTableScope("select");
                            if (eltPos == Integer.MAX_VALUE) {
                                assert (this.fragment);
                                this.errStrayEndTag(name);
                                return;
                            }
                            while (true) {
                                if (this.currentPtr < eltPos) {
                                    this.resetTheInsertionMode();
                                    return;
                                }
                                this.pop();
                            }
                        }
                        case 67: {
                            this.endTagTemplateInHead();
                            return;
                        }
                    }
                    this.errStrayEndTag(name);
                    return;
                }
                case 12: {
                    switch (group) {
                        case 23: {
                            if (this.fragment) {
                                this.errStrayEndTag(name);
                                return;
                            }
                            this.mode = 19;
                            return;
                        }
                    }
                    this.errEndTagAfterBody();
                    this.mode = this.framesetOk ? 5 : 6;
                    continue block123;
                }
                case 13: {
                    switch (group) {
                        case 11: {
                            if (this.currentPtr != 0) {
                                this.pop();
                                if (this.fragment) return;
                                if (this.isCurrent("frameset")) return;
                                this.mode = 14;
                                return;
                            }
                            assert (this.fragment);
                            this.errStrayEndTag(name);
                            return;
                        }
                    }
                    this.errStrayEndTag(name);
                    return;
                }
                case 14: {
                    switch (group) {
                        case 23: {
                            this.mode = 20;
                            return;
                        }
                    }
                    this.errStrayEndTag(name);
                    return;
                }
                case 15: {
                    switch (this.doctypeExpectation) {
                        case AUTO: {
                            this.err("End tag seen without seeing a doctype first. Expected e.g. \u201c<!DOCTYPE html>\u201d.");
                            break;
                        }
                        case HTML: {
                            this.errEndTagSeenWithoutDoctype();
                            break;
                        }
                        case HTML401_STRICT: {
                            this.err("End tag seen without seeing a doctype first. Expected \u201c<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">\u201d.");
                            break;
                        }
                        case HTML401_TRANSITIONAL: {
                            this.err("End tag seen without seeing a doctype first. Expected \u201c<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\u201d.");
                            break;
                        }
                    }
                    this.documentModeInternal(DocumentMode.QUIRKS_MODE, null, null, false);
                    this.mode = 16;
                    continue block123;
                }
                case 16: {
                    switch (group) {
                        case 3: 
                        case 4: 
                        case 20: 
                        case 23: {
                            this.appendHtmlElementToDocumentAndPush();
                            this.mode = 17;
                            continue block123;
                        }
                    }
                    this.errStrayEndTag(name);
                    return;
                }
                case 17: {
                    switch (group) {
                        case 3: 
                        case 4: 
                        case 20: 
                        case 23: {
                            this.appendToCurrentNodeAndPushHeadElement(HtmlAttributes.EMPTY_ATTRIBUTES);
                            this.mode = 7;
                            continue block123;
                        }
                    }
                    this.errStrayEndTag(name);
                    return;
                }
                case 18: {
                    switch (group) {
                        case 67: {
                            this.endTagTemplateInHead();
                            return;
                        }
                        case 3: 
                        case 4: 
                        case 23: {
                            this.appendToCurrentNodeAndPushBodyElement();
                            this.mode = 5;
                            continue block123;
                        }
                    }
                    this.errStrayEndTag(name);
                    return;
                }
                case 19: {
                    this.errStrayEndTag(name);
                    this.mode = this.framesetOk ? 5 : 6;
                    continue block123;
                }
                case 20: {
                    this.errStrayEndTag(name);
                    return;
                }
                case 21: {
                    this.pop();
                    if (this.originalMode == 18) {
                        this.silentPop();
                    }
                    this.mode = this.originalMode;
                    return;
                }
            }
        }
    }

    private void endTagTemplateInHead() throws SAXException {
        int eltPos = this.findLast("template");
        if (eltPos == Integer.MAX_VALUE) {
            this.errStrayEndTag("template");
            return;
        }
        this.generateImpliedEndTagsThoroughly();
        if (this.errorHandler != null && !this.isCurrent("template")) {
            this.errUnclosedElements(eltPos, "template");
        }
        while (this.currentPtr >= eltPos) {
            this.pop();
        }
        this.clearTheListOfActiveFormattingElementsUpToTheLastMarker();
        this.popTemplateMode();
        this.resetTheInsertionMode();
    }

    private int findLastInTableScopeOrRootTemplateTbodyTheadTfoot() {
        for (int i = this.currentPtr; i > 0; --i) {
            if (this.stack[i].getGroup() != 39 && this.stack[i].getGroup() != 67) continue;
            return i;
        }
        return 0;
    }

    private int findLast(@Local String name) {
        for (int i = this.currentPtr; i > 0; --i) {
            if (this.stack[i].ns != "http://www.w3.org/1999/xhtml" || this.stack[i].name != name) continue;
            return i;
        }
        return Integer.MAX_VALUE;
    }

    private int findLastInTableScope(@Local String name) {
        for (int i = this.currentPtr; i > 0; --i) {
            if (this.stack[i].ns != "http://www.w3.org/1999/xhtml") continue;
            if (this.stack[i].name == name) {
                return i;
            }
            if (this.stack[i].name != "table" && this.stack[i].name != "template") continue;
            return Integer.MAX_VALUE;
        }
        return Integer.MAX_VALUE;
    }

    private int findLastInButtonScope(@Local String name) {
        for (int i = this.currentPtr; i > 0; --i) {
            if (this.stack[i].ns == "http://www.w3.org/1999/xhtml") {
                if (this.stack[i].name == name) {
                    return i;
                }
                if (this.stack[i].name == "button") {
                    return Integer.MAX_VALUE;
                }
            }
            if (!this.stack[i].isScoping()) continue;
            return Integer.MAX_VALUE;
        }
        return Integer.MAX_VALUE;
    }

    private int findLastInScope(@Local String name) {
        for (int i = this.currentPtr; i > 0; --i) {
            if (this.stack[i].ns == "http://www.w3.org/1999/xhtml" && this.stack[i].name == name) {
                return i;
            }
            if (!this.stack[i].isScoping()) continue;
            return Integer.MAX_VALUE;
        }
        return Integer.MAX_VALUE;
    }

    private int findLastInListScope(@Local String name) {
        for (int i = this.currentPtr; i > 0; --i) {
            if (this.stack[i].ns == "http://www.w3.org/1999/xhtml") {
                if (this.stack[i].name == name) {
                    return i;
                }
                if (this.stack[i].name == "ul" || this.stack[i].name == "ol") {
                    return Integer.MAX_VALUE;
                }
            }
            if (!this.stack[i].isScoping()) continue;
            return Integer.MAX_VALUE;
        }
        return Integer.MAX_VALUE;
    }

    private int findLastInScopeHn() {
        for (int i = this.currentPtr; i > 0; --i) {
            if (this.stack[i].getGroup() == 42) {
                return i;
            }
            if (!this.stack[i].isScoping()) continue;
            return Integer.MAX_VALUE;
        }
        return Integer.MAX_VALUE;
    }

    private void generateImpliedEndTagsExceptFor(@Local String name) throws SAXException {
        block3: while (true) {
            StackNode<T> node = this.stack[this.currentPtr];
            switch (node.getGroup()) {
                case 15: 
                case 27: 
                case 28: 
                case 29: 
                case 41: 
                case 53: 
                case 69: {
                    if (node.ns == "http://www.w3.org/1999/xhtml" && node.name == name) {
                        return;
                    }
                    this.pop();
                    continue block3;
                }
            }
            break;
        }
    }

    private void generateImpliedEndTags() throws SAXException {
        block3: while (true) {
            switch (this.stack[this.currentPtr].getGroup()) {
                case 15: 
                case 27: 
                case 28: 
                case 29: 
                case 41: 
                case 53: 
                case 69: {
                    this.pop();
                    continue block3;
                }
            }
            break;
        }
    }

    private void generateImpliedEndTagsThoroughly() throws SAXException {
        block3: while (true) {
            switch (this.stack[this.currentPtr].getGroup()) {
                case 6: 
                case 8: 
                case 15: 
                case 27: 
                case 28: 
                case 29: 
                case 37: 
                case 39: 
                case 40: 
                case 41: 
                case 53: 
                case 69: {
                    this.pop();
                    continue block3;
                }
            }
            break;
        }
    }

    private boolean isSecondOnStackBody() {
        return this.currentPtr >= 1 && this.stack[1].getGroup() == 3;
    }

    private void documentModeInternal(DocumentMode m, String publicIdentifier, String systemIdentifier, boolean html4SpecificAdditionalErrorChecks) throws SAXException {
        if (this.isSrcdocDocument) {
            this.quirks = false;
            if (this.documentModeHandler != null) {
                this.documentModeHandler.documentMode(DocumentMode.STANDARDS_MODE, null, null, false);
            }
            return;
        }
        boolean bl = this.quirks = m == DocumentMode.QUIRKS_MODE;
        if (this.documentModeHandler != null) {
            this.documentModeHandler.documentMode(m, publicIdentifier, systemIdentifier, html4SpecificAdditionalErrorChecks);
        }
        this.documentMode(m, publicIdentifier, systemIdentifier, html4SpecificAdditionalErrorChecks);
    }

    private boolean isAlmostStandards(String publicIdentifier, String systemIdentifier) {
        if (Portability.lowerCaseLiteralEqualsIgnoreAsciiCaseString("-//w3c//dtd xhtml 1.0 transitional//en", publicIdentifier)) {
            return true;
        }
        if (Portability.lowerCaseLiteralEqualsIgnoreAsciiCaseString("-//w3c//dtd xhtml 1.0 frameset//en", publicIdentifier)) {
            return true;
        }
        if (systemIdentifier != null) {
            if (Portability.lowerCaseLiteralEqualsIgnoreAsciiCaseString("-//w3c//dtd html 4.01 transitional//en", publicIdentifier)) {
                return true;
            }
            if (Portability.lowerCaseLiteralEqualsIgnoreAsciiCaseString("-//w3c//dtd html 4.01 frameset//en", publicIdentifier)) {
                return true;
            }
        }
        return false;
    }

    private boolean isQuirky(@Local String name, String publicIdentifier, String systemIdentifier, boolean forceQuirks) {
        if (forceQuirks) {
            return true;
        }
        if (name != HTML_LOCAL) {
            return true;
        }
        if (publicIdentifier != null) {
            for (int i = 0; i < QUIRKY_PUBLIC_IDS.length; ++i) {
                if (!Portability.lowerCaseLiteralIsPrefixOfIgnoreAsciiCaseString(QUIRKY_PUBLIC_IDS[i], publicIdentifier)) continue;
                return true;
            }
            if (Portability.lowerCaseLiteralEqualsIgnoreAsciiCaseString("-//w3o//dtd w3 html strict 3.0//en//", publicIdentifier) || Portability.lowerCaseLiteralEqualsIgnoreAsciiCaseString("-/w3c/dtd html 4.0 transitional/en", publicIdentifier) || Portability.lowerCaseLiteralEqualsIgnoreAsciiCaseString(HTML_LOCAL, publicIdentifier)) {
                return true;
            }
        }
        if (systemIdentifier == null) {
            if (Portability.lowerCaseLiteralEqualsIgnoreAsciiCaseString("-//w3c//dtd html 4.01 transitional//en", publicIdentifier)) {
                return true;
            }
            if (Portability.lowerCaseLiteralEqualsIgnoreAsciiCaseString("-//w3c//dtd html 4.01 frameset//en", publicIdentifier)) {
                return true;
            }
        } else if (Portability.lowerCaseLiteralEqualsIgnoreAsciiCaseString("http://www.ibm.com/data/dtd/v11/ibmxhtml1-transitional.dtd", systemIdentifier)) {
            return true;
        }
        return false;
    }

    private void closeTheCell(int eltPos) throws SAXException {
        this.generateImpliedEndTags();
        if (this.errorHandler != null && eltPos != this.currentPtr) {
            this.errUnclosedElementsCell(eltPos);
        }
        while (this.currentPtr >= eltPos) {
            this.pop();
        }
        this.clearTheListOfActiveFormattingElementsUpToTheLastMarker();
        this.mode = 0;
    }

    private int findLastInTableScopeTdTh() {
        for (int i = this.currentPtr; i > 0; --i) {
            String name = this.stack[i].name;
            if (this.stack[i].ns != "http://www.w3.org/1999/xhtml") continue;
            if ("td" == name || "th" == name) {
                return i;
            }
            if (name != "table" && name != "template") continue;
            return Integer.MAX_VALUE;
        }
        return Integer.MAX_VALUE;
    }

    private void clearStackBackTo(int eltPos) throws SAXException {
        int eltGroup = this.stack[eltPos].getGroup();
        while (this.currentPtr > eltPos) {
            if (this.stack[this.currentPtr].ns == "http://www.w3.org/1999/xhtml" && this.stack[this.currentPtr].getGroup() == 67 && (eltGroup == 34 || eltGroup == 39 || eltGroup == 37 || eltPos == 0)) {
                return;
            }
            this.pop();
        }
    }

    private void resetTheInsertionMode() {
        for (int i = this.currentPtr; i >= 0; --i) {
            StackNode<T> node = this.stack[i];
            String name = node.name;
            String ns = node.ns;
            if (i == 0) {
                if (this.contextNamespace != "http://www.w3.org/1999/xhtml" || this.contextName != "td" && this.contextName != "th") {
                    if (this.fragment) {
                        name = this.contextName;
                        ns = this.contextNamespace;
                    }
                } else {
                    this.mode = this.framesetOk ? 5 : 6;
                    return;
                }
            }
            if ("select" == name) {
                int ancestorIndex = i;
                while (ancestorIndex > 0) {
                    StackNode<T> ancestor = this.stack[ancestorIndex--];
                    if ("http://www.w3.org/1999/xhtml" != ancestor.ns) continue;
                    if ("template" == ancestor.name) break;
                    if ("table" != ancestor.name) continue;
                    this.mode = 10;
                    return;
                }
                this.mode = 11;
                return;
            }
            if ("td" == name || "th" == name) {
                this.mode = 4;
                return;
            }
            if ("tr" == name) {
                this.mode = 0;
                return;
            }
            if ("tbody" == name || "thead" == name || "tfoot" == name) {
                this.mode = 1;
                return;
            }
            if ("caption" == name) {
                this.mode = 3;
                return;
            }
            if ("colgroup" == name) {
                this.mode = 9;
                return;
            }
            if ("table" == name) {
                this.mode = 2;
                return;
            }
            if ("http://www.w3.org/1999/xhtml" != ns) {
                this.mode = this.framesetOk ? 5 : 6;
                return;
            }
            if ("template" == name) {
                assert (this.templateModePtr >= 0);
                this.mode = this.templateModeStack[this.templateModePtr];
                return;
            }
            if ("head" == name) {
                this.mode = name == this.contextName ? (this.framesetOk ? 5 : 6) : 7;
                return;
            }
            if ("body" == name) {
                this.mode = this.framesetOk ? 5 : 6;
                return;
            }
            if ("frameset" == name) {
                this.mode = 13;
                return;
            }
            if (HTML_LOCAL == name) {
                this.mode = this.headPointer == null ? 17 : 18;
                return;
            }
            if (i != 0) continue;
            this.mode = this.framesetOk ? 5 : 6;
            return;
        }
    }

    private void implicitlyCloseP() throws SAXException {
        int eltPos = this.findLastInButtonScope("p");
        if (eltPos == Integer.MAX_VALUE) {
            return;
        }
        this.generateImpliedEndTagsExceptFor("p");
        if (this.errorHandler != null && eltPos != this.currentPtr) {
            this.errUnclosedElementsImplied(eltPos, "p");
        }
        while (this.currentPtr >= eltPos) {
            this.pop();
        }
    }

    private boolean debugOnlyClearLastStackSlot() {
        this.stack[this.currentPtr] = null;
        return true;
    }

    private boolean debugOnlyClearLastListSlot() {
        this.listOfActiveFormattingElements[this.listPtr] = null;
        return true;
    }

    private void pushTemplateMode(int mode) {
        ++this.templateModePtr;
        if (this.templateModePtr == this.templateModeStack.length) {
            int[] newStack = new int[this.templateModeStack.length + 64];
            System.arraycopy(this.templateModeStack, 0, newStack, 0, this.templateModeStack.length);
            this.templateModeStack = newStack;
        }
        this.templateModeStack[this.templateModePtr] = mode;
    }

    private void push(StackNode<T> node) throws SAXException {
        ++this.currentPtr;
        if (this.currentPtr == this.stack.length) {
            StackNode[] newStack = new StackNode[this.stack.length + 64];
            System.arraycopy(this.stack, 0, newStack, 0, this.stack.length);
            this.stack = newStack;
        }
        this.stack[this.currentPtr] = node;
        this.elementPushed(node.ns, node.popName, node.node);
    }

    private void silentPush(StackNode<T> node) throws SAXException {
        ++this.currentPtr;
        if (this.currentPtr == this.stack.length) {
            StackNode[] newStack = new StackNode[this.stack.length + 64];
            System.arraycopy(this.stack, 0, newStack, 0, this.stack.length);
            this.stack = newStack;
        }
        this.stack[this.currentPtr] = node;
    }

    private void append(StackNode<T> node) {
        ++this.listPtr;
        if (this.listPtr == this.listOfActiveFormattingElements.length) {
            StackNode[] newList = new StackNode[this.listOfActiveFormattingElements.length + 64];
            System.arraycopy(this.listOfActiveFormattingElements, 0, newList, 0, this.listOfActiveFormattingElements.length);
            this.listOfActiveFormattingElements = newList;
        }
        this.listOfActiveFormattingElements[this.listPtr] = node;
    }

    @Inline
    private void insertMarker() {
        this.append(null);
    }

    private void clearTheListOfActiveFormattingElementsUpToTheLastMarker() {
        while (this.listPtr > -1) {
            if (this.listOfActiveFormattingElements[this.listPtr] == null) {
                --this.listPtr;
                return;
            }
            this.listOfActiveFormattingElements[this.listPtr].release(this);
            --this.listPtr;
        }
    }

    @Inline
    private boolean isCurrent(@Local String name) {
        return this.stack[this.currentPtr].ns == "http://www.w3.org/1999/xhtml" && name == this.stack[this.currentPtr].name;
    }

    private void removeFromStack(int pos) throws SAXException {
        if (this.currentPtr == pos) {
            this.pop();
        } else {
            this.fatal();
            this.stack[pos].release(this);
            System.arraycopy(this.stack, pos + 1, this.stack, pos, this.currentPtr - pos);
            assert (this.debugOnlyClearLastStackSlot());
            --this.currentPtr;
        }
    }

    private void removeFromStack(StackNode<T> node) throws SAXException {
        if (this.stack[this.currentPtr] == node) {
            this.pop();
        } else {
            int pos;
            for (pos = this.currentPtr - 1; pos >= 0 && this.stack[pos] != node; --pos) {
            }
            if (pos == -1) {
                return;
            }
            this.fatal();
            node.release(this);
            System.arraycopy(this.stack, pos + 1, this.stack, pos, this.currentPtr - pos);
            --this.currentPtr;
        }
    }

    private void removeFromListOfActiveFormattingElements(int pos) {
        assert (this.listOfActiveFormattingElements[pos] != null);
        this.listOfActiveFormattingElements[pos].release(this);
        if (pos == this.listPtr) {
            assert (this.debugOnlyClearLastListSlot());
            --this.listPtr;
            return;
        }
        assert (pos < this.listPtr);
        System.arraycopy(this.listOfActiveFormattingElements, pos + 1, this.listOfActiveFormattingElements, pos, this.listPtr - pos);
        assert (this.debugOnlyClearLastListSlot());
        --this.listPtr;
    }

    private boolean adoptionAgencyEndTag(@Local String name) throws SAXException {
        if (this.stack[this.currentPtr].ns == "http://www.w3.org/1999/xhtml" && this.stack[this.currentPtr].name == name && this.findInListOfActiveFormattingElements(this.stack[this.currentPtr]) == -1) {
            this.pop();
            return true;
        }
        for (int i = 0; i < 8; ++i) {
            int furthestBlockPos;
            StackNode<T> node;
            int formattingEltStackPos;
            int formattingEltListPos;
            for (formattingEltListPos = this.listPtr; formattingEltListPos > -1; --formattingEltListPos) {
                StackNode<T> listNode = this.listOfActiveFormattingElements[formattingEltListPos];
                if (listNode == null) {
                    formattingEltListPos = -1;
                    break;
                }
                if (listNode.name == name) break;
            }
            if (formattingEltListPos == -1) {
                return false;
            }
            StackNode<T> formattingElt = this.listOfActiveFormattingElements[formattingEltListPos];
            boolean inScope = true;
            for (formattingEltStackPos = this.currentPtr; formattingEltStackPos > -1 && (node = this.stack[formattingEltStackPos]) != formattingElt; --formattingEltStackPos) {
                if (!node.isScoping()) continue;
                inScope = false;
            }
            if (formattingEltStackPos == -1) {
                this.errNoElementToCloseButEndTagSeen(name);
                this.removeFromListOfActiveFormattingElements(formattingEltListPos);
                return true;
            }
            if (!inScope) {
                this.errNoElementToCloseButEndTagSeen(name);
                return true;
            }
            if (formattingEltStackPos != this.currentPtr) {
                this.errEndTagViolatesNestingRules(name);
            }
            for (furthestBlockPos = formattingEltStackPos + 1; furthestBlockPos <= this.currentPtr; ++furthestBlockPos) {
                StackNode<T> node2 = this.stack[furthestBlockPos];
                assert (furthestBlockPos > 0) : "How is formattingEltStackPos + 1 not > 0?";
                if (node2.isSpecial()) break;
            }
            if (furthestBlockPos > this.currentPtr) {
                while (this.currentPtr >= formattingEltStackPos) {
                    this.pop();
                }
                this.removeFromListOfActiveFormattingElements(formattingEltListPos);
                return true;
            }
            StackNode<T> commonAncestor = this.stack[formattingEltStackPos - 1];
            StackNode<T> furthestBlock = this.stack[furthestBlockPos];
            int bookmark = formattingEltListPos;
            int nodePos = furthestBlockPos;
            StackNode<T> lastNode = furthestBlock;
            int j = 0;
            while (true) {
                ++j;
                if (--nodePos == formattingEltStackPos) break;
                StackNode<T> node3 = this.stack[nodePos];
                int nodeListPos = this.findInListOfActiveFormattingElements(node3);
                if (j > 3 && nodeListPos != -1) {
                    this.removeFromListOfActiveFormattingElements(nodeListPos);
                    if (nodeListPos <= formattingEltListPos) {
                        --formattingEltListPos;
                    }
                    if (nodeListPos <= bookmark) {
                        --bookmark;
                    }
                    nodeListPos = -1;
                }
                if (nodeListPos == -1) {
                    assert (formattingEltStackPos < nodePos);
                    assert (bookmark < nodePos);
                    assert (furthestBlockPos > nodePos);
                    this.removeFromStack(nodePos);
                    --furthestBlockPos;
                    continue;
                }
                if (nodePos == furthestBlockPos) {
                    bookmark = nodeListPos + 1;
                }
                assert (node3 == this.listOfActiveFormattingElements[nodeListPos]);
                assert (node3 == this.stack[nodePos]);
                Object clone = this.createElement("http://www.w3.org/1999/xhtml", node3.name, node3.attributes.cloneAttributes(null), commonAncestor.node);
                StackNode newNode = this.createStackNode(node3.getFlags(), node3.ns, node3.name, clone, node3.popName, node3.attributes, node3.getLocator());
                node3.dropAttributes();
                this.stack[nodePos] = newNode;
                newNode.retain();
                this.listOfActiveFormattingElements[nodeListPos] = newNode;
                node3.release(this);
                node3.release(this);
                node3 = newNode;
                this.detachFromParent(lastNode.node);
                this.appendElement(lastNode.node, node3.node);
                lastNode = node3;
            }
            if (commonAncestor.isFosterParenting()) {
                this.fatal();
                this.detachFromParent(lastNode.node);
                this.insertIntoFosterParent(lastNode.node);
            } else {
                this.detachFromParent(lastNode.node);
                this.appendElement(lastNode.node, commonAncestor.node);
            }
            Object clone = this.createElement("http://www.w3.org/1999/xhtml", formattingElt.name, formattingElt.attributes.cloneAttributes(null), furthestBlock.node);
            StackNode formattingClone = this.createStackNode(formattingElt.getFlags(), formattingElt.ns, formattingElt.name, clone, formattingElt.popName, formattingElt.attributes, this.errorHandler == null ? null : new TaintableLocatorImpl(this.tokenizer));
            formattingElt.dropAttributes();
            this.appendChildrenToNewParent(furthestBlock.node, clone);
            this.appendElement(clone, furthestBlock.node);
            this.removeFromListOfActiveFormattingElements(formattingEltListPos);
            this.insertIntoListOfActiveFormattingElements(formattingClone, bookmark);
            assert (formattingEltStackPos < furthestBlockPos);
            this.removeFromStack(formattingEltStackPos);
            this.insertIntoStack(formattingClone, furthestBlockPos);
        }
        return true;
    }

    private void insertIntoStack(StackNode<T> node, int position) throws SAXException {
        assert (this.currentPtr + 1 < this.stack.length);
        assert (position <= this.currentPtr + 1);
        if (position == this.currentPtr + 1) {
            this.push(node);
        } else {
            System.arraycopy(this.stack, position, this.stack, position + 1, this.currentPtr - position + 1);
            ++this.currentPtr;
            this.stack[position] = node;
        }
    }

    private void insertIntoListOfActiveFormattingElements(StackNode<T> formattingClone, int bookmark) {
        formattingClone.retain();
        assert (this.listPtr + 1 < this.listOfActiveFormattingElements.length);
        if (bookmark <= this.listPtr) {
            System.arraycopy(this.listOfActiveFormattingElements, bookmark, this.listOfActiveFormattingElements, bookmark + 1, this.listPtr - bookmark + 1);
        }
        ++this.listPtr;
        this.listOfActiveFormattingElements[bookmark] = formattingClone;
    }

    private int findInListOfActiveFormattingElements(StackNode<T> node) {
        for (int i = this.listPtr; i >= 0; --i) {
            if (node != this.listOfActiveFormattingElements[i]) continue;
            return i;
        }
        return -1;
    }

    private int findInListOfActiveFormattingElementsContainsBetweenEndAndLastMarker(@Local String name) {
        for (int i = this.listPtr; i >= 0; --i) {
            StackNode<T> node = this.listOfActiveFormattingElements[i];
            if (node == null) {
                return -1;
            }
            if (node.name != name) continue;
            return i;
        }
        return -1;
    }

    private void maybeForgetEarlierDuplicateFormattingElement(@Local String name, HtmlAttributes attributes) throws SAXException {
        StackNode<T> node;
        int candidate = -1;
        int count = 0;
        for (int i = this.listPtr; i >= 0 && (node = this.listOfActiveFormattingElements[i]) != null; --i) {
            if (node.name != name || !node.attributes.equalsAnother(attributes)) continue;
            candidate = i;
            ++count;
        }
        if (count >= 3) {
            this.removeFromListOfActiveFormattingElements(candidate);
        }
    }

    private int findLastOrRoot(@Local String name) {
        for (int i = this.currentPtr; i > 0; --i) {
            if (this.stack[i].ns != "http://www.w3.org/1999/xhtml" || this.stack[i].name != name) continue;
            return i;
        }
        return 0;
    }

    private int findLastOrRoot(int group) {
        for (int i = this.currentPtr; i > 0; --i) {
            if (this.stack[i].getGroup() != group) continue;
            return i;
        }
        return 0;
    }

    private boolean addAttributesToBody(HtmlAttributes attributes) throws SAXException {
        StackNode<T> body;
        this.checkAttributes(attributes, "http://www.w3.org/1999/xhtml");
        if (this.currentPtr >= 1 && (body = this.stack[1]).getGroup() == 3) {
            this.addAttributesToElement(body.node, attributes);
            return true;
        }
        return false;
    }

    private void addAttributesToHtml(HtmlAttributes attributes) throws SAXException {
        this.checkAttributes(attributes, "http://www.w3.org/1999/xhtml");
        this.addAttributesToElement(this.stack[0].node, attributes);
    }

    private void pushHeadPointerOntoStack() throws SAXException {
        assert (this.headPointer != null);
        assert (this.mode == 18);
        this.fatal();
        this.silentPush(this.createStackNode(ElementName.HEAD, this.headPointer, this.errorHandler == null ? null : new TaintableLocatorImpl(this.tokenizer)));
    }

    private void reconstructTheActiveFormattingElements() throws SAXException {
        if (this.listPtr == -1) {
            return;
        }
        StackNode<T> mostRecent = this.listOfActiveFormattingElements[this.listPtr];
        if (mostRecent == null || this.isInStack(mostRecent)) {
            return;
        }
        int entryPos = this.listPtr;
        while (--entryPos != -1 && this.listOfActiveFormattingElements[entryPos] != null && !this.isInStack(this.listOfActiveFormattingElements[entryPos])) {
        }
        while (entryPos < this.listPtr) {
            T clone;
            StackNode<T> entry = this.listOfActiveFormattingElements[++entryPos];
            StackNode<T> currentNode = this.stack[this.currentPtr];
            if (currentNode.isFosterParenting()) {
                clone = this.createAndInsertFosterParentedElement("http://www.w3.org/1999/xhtml", entry.name, entry.attributes.cloneAttributes(null));
            } else {
                clone = this.createElement("http://www.w3.org/1999/xhtml", entry.name, entry.attributes.cloneAttributes(null), currentNode.node);
                this.appendElement(clone, currentNode.node);
            }
            StackNode<T> entryClone = this.createStackNode(entry.getFlags(), entry.ns, entry.name, clone, entry.popName, entry.attributes, entry.getLocator());
            entry.dropAttributes();
            this.push(entryClone);
            this.listOfActiveFormattingElements[entryPos] = entryClone;
            entry.release(this);
            entryClone.retain();
        }
    }

    void notifyUnusedStackNode(int idxInStackNodes) {
        if (idxInStackNodes < this.stackNodesIdx) {
            this.stackNodesIdx = idxInStackNodes;
        }
    }

    private StackNode<T> getUnusedStackNode() {
        while (this.stackNodesIdx < this.numStackNodes) {
            if (this.stackNodes[this.stackNodesIdx].isUnused()) {
                return this.stackNodes[this.stackNodesIdx++];
            }
            ++this.stackNodesIdx;
        }
        if (this.stackNodesIdx < this.stackNodes.length) {
            this.stackNodes[this.stackNodesIdx] = new StackNode(this.stackNodesIdx);
            ++this.numStackNodes;
            return this.stackNodes[this.stackNodesIdx++];
        }
        StackNode[] newStack = new StackNode[this.stackNodes.length + 64];
        System.arraycopy(this.stackNodes, 0, newStack, 0, this.stackNodes.length);
        this.stackNodes = newStack;
        this.stackNodes[this.stackNodesIdx] = new StackNode(this.stackNodesIdx);
        ++this.numStackNodes;
        return this.stackNodes[this.stackNodesIdx++];
    }

    private StackNode<T> createStackNode(int flags, @NsUri String ns, @Local String name, T node, @Local String popName, HtmlAttributes attributes, TaintableLocatorImpl locator) {
        StackNode<T> instance = this.getUnusedStackNode();
        instance.setValues(flags, ns, name, node, popName, attributes, locator);
        return instance;
    }

    private StackNode<T> createStackNode(ElementName elementName, T node, TaintableLocatorImpl locator) {
        StackNode<T> instance = this.getUnusedStackNode();
        instance.setValues(elementName, node, locator);
        return instance;
    }

    private StackNode<T> createStackNode(ElementName elementName, T node, HtmlAttributes attributes, TaintableLocatorImpl locator) {
        StackNode<T> instance = this.getUnusedStackNode();
        instance.setValues(elementName, node, attributes, locator);
        return instance;
    }

    private StackNode<T> createStackNode(ElementName elementName, T node, @Local String popName, TaintableLocatorImpl locator) {
        StackNode<T> instance = this.getUnusedStackNode();
        instance.setValues(elementName, node, popName, locator);
        return instance;
    }

    private StackNode<T> createStackNode(ElementName elementName, @Local String popName, T node, TaintableLocatorImpl locator) {
        StackNode<T> instance = this.getUnusedStackNode();
        instance.setValues(elementName, popName, node, locator);
        return instance;
    }

    private StackNode<T> createStackNode(ElementName elementName, T node, @Local String popName, boolean markAsIntegrationPoint, TaintableLocatorImpl locator) {
        StackNode<T> instance = this.getUnusedStackNode();
        instance.setValues(elementName, node, popName, markAsIntegrationPoint, locator);
        return instance;
    }

    private void insertIntoFosterParent(T child) throws SAXException {
        int tablePos = this.findLastOrRoot(34);
        int templatePos = this.findLastOrRoot(67);
        if (templatePos >= tablePos) {
            this.appendElement(child, this.stack[templatePos].node);
            return;
        }
        StackNode<T> node = this.stack[tablePos];
        this.insertFosterParentedChild(child, node.node, this.stack[tablePos - 1].node);
    }

    private T createAndInsertFosterParentedElement(@NsUri String ns, @Local String name, HtmlAttributes attributes) throws SAXException {
        return this.createAndInsertFosterParentedElement(ns, name, attributes, null);
    }

    private T createAndInsertFosterParentedElement(@NsUri String ns, @Local String name, HtmlAttributes attributes, T form) throws SAXException {
        int tablePos = this.findLastOrRoot(34);
        int templatePos = this.findLastOrRoot(67);
        if (templatePos >= tablePos) {
            T child = this.createElement(ns, name, attributes, form, this.stack[templatePos].node);
            this.appendElement(child, this.stack[templatePos].node);
            return child;
        }
        StackNode<T> node = this.stack[tablePos];
        return this.createAndInsertFosterParentedElement(ns, name, attributes, form, node.node, this.stack[tablePos - 1].node);
    }

    private boolean isInStack(StackNode<T> node) {
        for (int i = this.currentPtr; i >= 0; --i) {
            if (this.stack[i] != node) continue;
            return true;
        }
        return false;
    }

    private void popTemplateMode() {
        --this.templateModePtr;
    }

    private void pop() throws SAXException {
        StackNode<T> node = this.stack[this.currentPtr];
        assert (this.debugOnlyClearLastStackSlot());
        --this.currentPtr;
        this.elementPopped(node.ns, node.popName, node.node);
        node.release(this);
    }

    private void silentPop() throws SAXException {
        StackNode<T> node = this.stack[this.currentPtr];
        assert (this.debugOnlyClearLastStackSlot());
        --this.currentPtr;
        node.release(this);
    }

    private void popOnEof() throws SAXException {
        StackNode<T> node = this.stack[this.currentPtr];
        assert (this.debugOnlyClearLastStackSlot());
        --this.currentPtr;
        this.markMalformedIfScript(node.node);
        this.elementPopped(node.ns, node.popName, node.node);
        node.release(this);
    }

    private void checkAttributes(HtmlAttributes attributes, @NsUri String ns) throws SAXException {
        if (this.errorHandler != null) {
            int len = attributes.getXmlnsLength();
            block12: for (int i = 0; i < len; ++i) {
                String xmlns;
                AttributeName name = attributes.getXmlnsAttributeName(i);
                if (name == AttributeName.XMLNS) {
                    if (this.html4) {
                        this.err("Attribute \u201cxmlns\u201d not allowed here. (HTML4-only error.)");
                        continue;
                    }
                    xmlns = attributes.getXmlnsValue(i);
                    if (ns.equals(xmlns)) continue;
                    this.err("Bad value \u201c" + xmlns + "\u201d for the attribute \u201cxmlns\u201d (only \u201c" + ns + "\u201d permitted here).");
                    switch (this.namePolicy) {
                        case ALTER_INFOSET: 
                        case ALLOW: {
                            this.warn("Attribute \u201cxmlns\u201d is not serializable as XML 1.0.");
                            break;
                        }
                        case FATAL: {
                            this.fatal("Attribute \u201cxmlns\u201d is not serializable as XML 1.0.");
                        }
                    }
                    continue;
                }
                if (ns != "http://www.w3.org/1999/xhtml" && name == AttributeName.XMLNS_XLINK) {
                    xmlns = attributes.getXmlnsValue(i);
                    if ("http://www.w3.org/1999/xlink".equals(xmlns)) continue;
                    this.err("Bad value \u201c" + xmlns + "\u201d for the attribute \u201cxmlns:link\u201d (only \u201chttp://www.w3.org/1999/xlink\u201d permitted here).");
                    switch (this.namePolicy) {
                        case ALTER_INFOSET: 
                        case ALLOW: {
                            this.warn("Attribute \u201cxmlns:xlink\u201d with a value other than \u201chttp://www.w3.org/1999/xlink\u201d is not serializable as XML 1.0 without changing document semantics.");
                            break;
                        }
                        case FATAL: {
                            this.fatal("Attribute \u201cxmlns:xlink\u201d with a value other than \u201chttp://www.w3.org/1999/xlink\u201d is not serializable as XML 1.0 without changing document semantics.");
                        }
                    }
                    continue;
                }
                this.err("Attribute \u201c" + attributes.getXmlnsLocalName(i) + "\u201d not allowed here.");
                switch (this.namePolicy) {
                    case ALTER_INFOSET: 
                    case ALLOW: {
                        this.warn("Attribute with the local name \u201c" + attributes.getXmlnsLocalName(i) + "\u201d is not serializable as XML 1.0.");
                        continue block12;
                    }
                    case FATAL: {
                        this.fatal("Attribute with the local name \u201c" + attributes.getXmlnsLocalName(i) + "\u201d is not serializable as XML 1.0.");
                    }
                }
            }
        }
        attributes.processNonNcNames(this, this.namePolicy);
    }

    private String checkPopName(@Local String name) throws SAXException {
        if (NCName.isNCName(name)) {
            return name;
        }
        switch (this.namePolicy) {
            case ALLOW: {
                this.warn("Element name \u201c" + name + "\u201d cannot be represented as XML 1.0.");
                return name;
            }
            case ALTER_INFOSET: {
                this.warn("Element name \u201c" + name + "\u201d cannot be represented as XML 1.0.");
                return NCName.escapeName(name);
            }
            case FATAL: {
                this.fatal("Element name \u201c" + name + "\u201d cannot be represented as XML 1.0.");
            }
        }
        return null;
    }

    private void appendHtmlElementToDocumentAndPush(HtmlAttributes attributes) throws SAXException {
        this.checkAttributes(attributes, "http://www.w3.org/1999/xhtml");
        T elt = this.createHtmlElementSetAsRoot(attributes);
        StackNode<T> node = this.createStackNode(ElementName.HTML, elt, this.errorHandler == null ? null : new TaintableLocatorImpl(this.tokenizer));
        this.push(node);
    }

    private void appendHtmlElementToDocumentAndPush() throws SAXException {
        this.appendHtmlElementToDocumentAndPush(this.tokenizer.emptyAttributes());
    }

    private void appendToCurrentNodeAndPushHeadElement(HtmlAttributes attributes) throws SAXException {
        this.checkAttributes(attributes, "http://www.w3.org/1999/xhtml");
        Object currentNode = this.stack[this.currentPtr].node;
        Object elt = this.createElement("http://www.w3.org/1999/xhtml", "head", attributes, currentNode);
        this.appendElement(elt, currentNode);
        this.headPointer = elt;
        StackNode node = this.createStackNode(ElementName.HEAD, elt, this.errorHandler == null ? null : new TaintableLocatorImpl(this.tokenizer));
        this.push(node);
    }

    private void appendToCurrentNodeAndPushBodyElement(HtmlAttributes attributes) throws SAXException {
        this.appendToCurrentNodeAndPushElement(ElementName.BODY, attributes);
    }

    private void appendToCurrentNodeAndPushBodyElement() throws SAXException {
        this.appendToCurrentNodeAndPushBodyElement(this.tokenizer.emptyAttributes());
    }

    private void appendToCurrentNodeAndPushFormElementMayFoster(HtmlAttributes attributes) throws SAXException {
        T elt;
        this.checkAttributes(attributes, "http://www.w3.org/1999/xhtml");
        StackNode<T> current = this.stack[this.currentPtr];
        if (current.isFosterParenting()) {
            this.fatal();
            elt = this.createAndInsertFosterParentedElement("http://www.w3.org/1999/xhtml", "form", attributes);
        } else {
            elt = this.createElement("http://www.w3.org/1999/xhtml", "form", attributes, current.node);
            this.appendElement(elt, current.node);
        }
        if (!this.isTemplateContents()) {
            this.formPointer = elt;
        }
        StackNode<T> node = this.createStackNode(ElementName.FORM, elt, this.errorHandler == null ? null : new TaintableLocatorImpl(this.tokenizer));
        this.push(node);
    }

    private void appendToCurrentNodeAndPushFormattingElementMayFoster(ElementName elementName, HtmlAttributes attributes) throws SAXException {
        T elt;
        this.checkAttributes(attributes, "http://www.w3.org/1999/xhtml");
        HtmlAttributes clone = attributes.cloneAttributes(null);
        StackNode<T> current = this.stack[this.currentPtr];
        if (current.isFosterParenting()) {
            this.fatal();
            elt = this.createAndInsertFosterParentedElement("http://www.w3.org/1999/xhtml", elementName.getName(), attributes);
        } else {
            elt = this.createElement("http://www.w3.org/1999/xhtml", elementName.getName(), attributes, current.node);
            this.appendElement(elt, current.node);
        }
        StackNode<T> node = this.createStackNode(elementName, elt, clone, this.errorHandler == null ? null : new TaintableLocatorImpl(this.tokenizer));
        this.push(node);
        this.append(node);
        node.retain();
    }

    private void appendToCurrentNodeAndPushElement(ElementName elementName, HtmlAttributes attributes) throws SAXException {
        this.checkAttributes(attributes, "http://www.w3.org/1999/xhtml");
        Object currentNode = this.stack[this.currentPtr].node;
        Object elt = this.createElement("http://www.w3.org/1999/xhtml", elementName.getName(), attributes, currentNode);
        this.appendElement(elt, currentNode);
        if (ElementName.TEMPLATE == elementName) {
            elt = this.getDocumentFragmentForTemplate(elt);
        }
        StackNode node = this.createStackNode(elementName, elt, this.errorHandler == null ? null : new TaintableLocatorImpl(this.tokenizer));
        this.push(node);
    }

    private void appendToCurrentNodeAndPushElementMayFoster(ElementName elementName, HtmlAttributes attributes) throws SAXException {
        T elt;
        StackNode<T> current;
        String popName = elementName.getName();
        this.checkAttributes(attributes, "http://www.w3.org/1999/xhtml");
        if (!elementName.isInterned()) {
            popName = this.checkPopName(popName);
        }
        if ((current = this.stack[this.currentPtr]).isFosterParenting()) {
            this.fatal();
            elt = this.createAndInsertFosterParentedElement("http://www.w3.org/1999/xhtml", popName, attributes);
        } else {
            elt = this.createElement("http://www.w3.org/1999/xhtml", popName, attributes, current.node);
            this.appendElement(elt, current.node);
        }
        StackNode<T> node = this.createStackNode(elementName, elt, popName, this.errorHandler == null ? null : new TaintableLocatorImpl(this.tokenizer));
        this.push(node);
    }

    private void appendToCurrentNodeAndPushElementMayFosterMathML(ElementName elementName, HtmlAttributes attributes) throws SAXException {
        T elt;
        StackNode<T> current;
        String popName = elementName.getName();
        this.checkAttributes(attributes, "http://www.w3.org/1998/Math/MathML");
        if (!elementName.isInterned()) {
            popName = this.checkPopName(popName);
        }
        boolean markAsHtmlIntegrationPoint = false;
        if (ElementName.ANNOTATION_XML == elementName && this.annotationXmlEncodingPermitsHtml(attributes)) {
            markAsHtmlIntegrationPoint = true;
        }
        if ((current = this.stack[this.currentPtr]).isFosterParenting()) {
            this.fatal();
            elt = this.createAndInsertFosterParentedElement("http://www.w3.org/1998/Math/MathML", popName, attributes);
        } else {
            elt = this.createElement("http://www.w3.org/1998/Math/MathML", popName, attributes, current.node);
            this.appendElement(elt, current.node);
        }
        StackNode<T> node = this.createStackNode(elementName, elt, popName, markAsHtmlIntegrationPoint, this.errorHandler == null ? null : new TaintableLocatorImpl(this.tokenizer));
        this.push(node);
    }

    T getDocumentFragmentForTemplate(T template) {
        return template;
    }

    T getFormPointerForContext(T context) {
        return null;
    }

    private boolean annotationXmlEncodingPermitsHtml(HtmlAttributes attributes) {
        String encoding = attributes.getValue(AttributeName.ENCODING);
        if (encoding == null) {
            return false;
        }
        return Portability.lowerCaseLiteralEqualsIgnoreAsciiCaseString("application/xhtml+xml", encoding) || Portability.lowerCaseLiteralEqualsIgnoreAsciiCaseString("text/html", encoding);
    }

    private void appendToCurrentNodeAndPushElementMayFosterSVG(ElementName elementName, HtmlAttributes attributes) throws SAXException {
        T elt;
        StackNode<T> current;
        String popName = elementName.getCamelCaseName();
        this.checkAttributes(attributes, "http://www.w3.org/2000/svg");
        if (!elementName.isInterned()) {
            popName = this.checkPopName(popName);
        }
        if ((current = this.stack[this.currentPtr]).isFosterParenting()) {
            this.fatal();
            elt = this.createAndInsertFosterParentedElement("http://www.w3.org/2000/svg", popName, attributes);
        } else {
            elt = this.createElement("http://www.w3.org/2000/svg", popName, attributes, current.node);
            this.appendElement(elt, current.node);
        }
        StackNode<T> node = this.createStackNode(elementName, popName, elt, this.errorHandler == null ? null : new TaintableLocatorImpl(this.tokenizer));
        this.push(node);
    }

    private void appendToCurrentNodeAndPushElementMayFoster(ElementName elementName, HtmlAttributes attributes, T form) throws SAXException {
        T elt;
        this.checkAttributes(attributes, "http://www.w3.org/1999/xhtml");
        T formOwner = form == null || this.fragment || this.isTemplateContents() ? null : (T)form;
        StackNode<T> current = this.stack[this.currentPtr];
        if (current.isFosterParenting()) {
            this.fatal();
            elt = this.createAndInsertFosterParentedElement("http://www.w3.org/1999/xhtml", elementName.getName(), attributes, formOwner);
        } else {
            elt = this.createElement("http://www.w3.org/1999/xhtml", elementName.getName(), attributes, formOwner, current.node);
            this.appendElement(elt, current.node);
        }
        StackNode<Object> node = this.createStackNode(elementName, elt, this.errorHandler == null ? null : new TaintableLocatorImpl(this.tokenizer));
        this.push(node);
    }

    private void appendVoidElementToCurrentMayFoster(@Local String name, HtmlAttributes attributes, T form) throws SAXException {
        T elt;
        this.checkAttributes(attributes, "http://www.w3.org/1999/xhtml");
        T formOwner = form == null || this.fragment || this.isTemplateContents() ? null : (T)form;
        StackNode<T> current = this.stack[this.currentPtr];
        if (current.isFosterParenting()) {
            this.fatal();
            elt = this.createAndInsertFosterParentedElement("http://www.w3.org/1999/xhtml", name, attributes, formOwner);
        } else {
            elt = this.createElement("http://www.w3.org/1999/xhtml", name, attributes, formOwner, current.node);
            this.appendElement(elt, current.node);
        }
        this.elementPushed("http://www.w3.org/1999/xhtml", name, elt);
        this.elementPopped("http://www.w3.org/1999/xhtml", name, elt);
    }

    private void appendVoidElementToCurrentMayFoster(ElementName elementName, HtmlAttributes attributes) throws SAXException {
        T elt;
        StackNode<T> current;
        String popName = elementName.getName();
        this.checkAttributes(attributes, "http://www.w3.org/1999/xhtml");
        if (!elementName.isInterned()) {
            popName = this.checkPopName(popName);
        }
        if ((current = this.stack[this.currentPtr]).isFosterParenting()) {
            this.fatal();
            elt = this.createAndInsertFosterParentedElement("http://www.w3.org/1999/xhtml", popName, attributes);
        } else {
            elt = this.createElement("http://www.w3.org/1999/xhtml", popName, attributes, current.node);
            this.appendElement(elt, current.node);
        }
        this.elementPushed("http://www.w3.org/1999/xhtml", popName, elt);
        this.elementPopped("http://www.w3.org/1999/xhtml", popName, elt);
    }

    private void appendVoidElementToCurrentMayFosterSVG(ElementName elementName, HtmlAttributes attributes) throws SAXException {
        T elt;
        StackNode<T> current;
        String popName = elementName.getCamelCaseName();
        this.checkAttributes(attributes, "http://www.w3.org/2000/svg");
        if (!elementName.isInterned()) {
            popName = this.checkPopName(popName);
        }
        if ((current = this.stack[this.currentPtr]).isFosterParenting()) {
            this.fatal();
            elt = this.createAndInsertFosterParentedElement("http://www.w3.org/2000/svg", popName, attributes);
        } else {
            elt = this.createElement("http://www.w3.org/2000/svg", popName, attributes, current.node);
            this.appendElement(elt, current.node);
        }
        this.elementPushed("http://www.w3.org/2000/svg", popName, elt);
        this.elementPopped("http://www.w3.org/2000/svg", popName, elt);
    }

    private void appendVoidElementToCurrentMayFosterMathML(ElementName elementName, HtmlAttributes attributes) throws SAXException {
        T elt;
        StackNode<T> current;
        String popName = elementName.getName();
        this.checkAttributes(attributes, "http://www.w3.org/1998/Math/MathML");
        if (!elementName.isInterned()) {
            popName = this.checkPopName(popName);
        }
        if ((current = this.stack[this.currentPtr]).isFosterParenting()) {
            this.fatal();
            elt = this.createAndInsertFosterParentedElement("http://www.w3.org/1998/Math/MathML", popName, attributes);
        } else {
            elt = this.createElement("http://www.w3.org/1998/Math/MathML", popName, attributes, current.node);
            this.appendElement(elt, current.node);
        }
        this.elementPushed("http://www.w3.org/1998/Math/MathML", popName, elt);
        this.elementPopped("http://www.w3.org/1998/Math/MathML", popName, elt);
    }

    private void appendVoidElementToCurrent(@Local String name, HtmlAttributes attributes, T form) throws SAXException {
        this.checkAttributes(attributes, "http://www.w3.org/1999/xhtml");
        Object currentNode = this.stack[this.currentPtr].node;
        T elt = this.createElement("http://www.w3.org/1999/xhtml", name, attributes, form == null || this.fragment || this.isTemplateContents() ? null : (T)form, currentNode);
        this.appendElement(elt, currentNode);
        this.elementPushed("http://www.w3.org/1999/xhtml", name, elt);
        this.elementPopped("http://www.w3.org/1999/xhtml", name, elt);
    }

    private void appendVoidFormToCurrent(HtmlAttributes attributes) throws SAXException {
        this.checkAttributes(attributes, "http://www.w3.org/1999/xhtml");
        Object currentNode = this.stack[this.currentPtr].node;
        Object elt = this.createElement("http://www.w3.org/1999/xhtml", "form", attributes, currentNode);
        this.formPointer = elt;
        this.appendElement(elt, currentNode);
        this.elementPushed("http://www.w3.org/1999/xhtml", "form", elt);
        this.elementPopped("http://www.w3.org/1999/xhtml", "form", elt);
    }

    private final void accumulateCharactersForced(@Const @NoLength char[] buf, int start, int length) throws SAXException {
        System.arraycopy(buf, start, this.charBuffer, this.charBufferLen, length);
        this.charBufferLen += length;
    }

    @Override
    public void ensureBufferSpace(int inputLength) throws SAXException {
        int worstCase = this.charBufferLen + inputLength;
        if (this.charBuffer == null) {
            this.charBuffer = new char[worstCase + 128];
        } else if (worstCase > this.charBuffer.length) {
            char[] newBuf = new char[worstCase];
            System.arraycopy(this.charBuffer, 0, newBuf, 0, this.charBufferLen);
            this.charBuffer = newBuf;
        }
    }

    protected void accumulateCharacters(@Const @NoLength char[] buf, int start, int length) throws SAXException {
        this.appendCharacters(this.stack[this.currentPtr].node, buf, start, length);
    }

    protected final void requestSuspension() {
        this.tokenizer.requestSuspension();
    }

    protected abstract T createElement(@NsUri String var1, @Local String var2, HtmlAttributes var3, T var4) throws SAXException;

    protected T createElement(@NsUri String ns, @Local String name, HtmlAttributes attributes, T form, T intendedParent) throws SAXException {
        return this.createElement("http://www.w3.org/1999/xhtml", name, attributes, intendedParent);
    }

    protected abstract T createHtmlElementSetAsRoot(HtmlAttributes var1) throws SAXException;

    protected abstract void detachFromParent(T var1) throws SAXException;

    protected abstract boolean hasChildren(T var1) throws SAXException;

    protected abstract void appendElement(T var1, T var2) throws SAXException;

    protected abstract void appendChildrenToNewParent(T var1, T var2) throws SAXException;

    protected abstract void insertFosterParentedChild(T var1, T var2, T var3) throws SAXException;

    protected abstract T createAndInsertFosterParentedElement(@NsUri String var1, @Local String var2, HtmlAttributes var3, T var4, T var5) throws SAXException;

    protected T createAndInsertFosterParentedElement(@NsUri String ns, @Local String name, HtmlAttributes attributes, T form, T table, T stackParent) throws SAXException {
        return this.createAndInsertFosterParentedElement(ns, name, attributes, table, stackParent);
    }

    protected abstract void insertFosterParentedCharacters(@NoLength char[] var1, int var2, int var3, T var4, T var5) throws SAXException;

    protected abstract void appendCharacters(T var1, @NoLength char[] var2, int var3, int var4) throws SAXException;

    protected abstract void appendComment(T var1, @NoLength char[] var2, int var3, int var4) throws SAXException;

    protected abstract void appendCommentToDocument(@NoLength char[] var1, int var2, int var3) throws SAXException;

    protected abstract void addAttributesToElement(T var1, HtmlAttributes var2) throws SAXException;

    protected void markMalformedIfScript(T elt) throws SAXException {
    }

    protected void start(boolean fragmentMode) throws SAXException {
    }

    protected void end() throws SAXException {
    }

    protected void appendDoctypeToDocument(@Local String name, String publicIdentifier, String systemIdentifier) throws SAXException {
    }

    protected void elementPushed(@NsUri String ns, @Local String name, T node) throws SAXException {
    }

    protected void elementPopped(@NsUri String ns, @Local String name, T node) throws SAXException {
    }

    protected void documentMode(DocumentMode m, String publicIdentifier, String systemIdentifier, boolean html4SpecificAdditionalErrorChecks) throws SAXException {
    }

    @Override
    public boolean wantsComments() {
        return this.wantingComments;
    }

    public void setIgnoringComments(boolean ignoreComments) {
        this.wantingComments = !ignoreComments;
    }

    public final void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public final void setFragmentContext(@Local String context) {
        this.contextName = context;
        this.contextNamespace = "http://www.w3.org/1999/xhtml";
        this.contextNode = null;
        this.fragment = this.contextName != null;
        this.quirks = false;
    }

    @Override
    @Inline
    public boolean cdataSectionAllowed() throws SAXException {
        return this.isInForeign();
    }

    private boolean isInForeign() {
        return this.currentPtr >= 0 && this.stack[this.currentPtr].ns != "http://www.w3.org/1999/xhtml";
    }

    private boolean isInForeignButNotHtmlOrMathTextIntegrationPoint() {
        if (this.currentPtr < 0) {
            return false;
        }
        return !this.isSpecialParentInForeign(this.stack[this.currentPtr]);
    }

    public final void setFragmentContext(@Local String context, @NsUri String ns, T node, boolean quirks) {
        if ((context != null || ns != null) && "http://www.w3.org/1999/xhtml" != ns && "http://www.w3.org/2000/svg" != ns && "http://www.w3.org/1998/Math/MathML" != ns) {
            throw new IllegalArgumentException("The namespace must be the HTML, SVG or MathML namespace (or null when the local name is null). Got: " + ns);
        }
        this.contextName = context;
        this.contextNamespace = ns;
        this.contextNode = node;
        this.fragment = this.contextName != null;
        this.quirks = quirks;
    }

    protected final T currentNode() {
        return this.stack[this.currentPtr].node;
    }

    public boolean isScriptingEnabled() {
        return this.scriptingEnabled;
    }

    public void setScriptingEnabled(boolean scriptingEnabled) {
        this.scriptingEnabled = scriptingEnabled;
    }

    public void setIsSrcdocDocument(boolean isSrcdocDocument) {
        this.isSrcdocDocument = isSrcdocDocument;
    }

    public void setDoctypeExpectation(DoctypeExpectation doctypeExpectation) {
        this.doctypeExpectation = doctypeExpectation;
    }

    public void setNamePolicy(XmlViolationPolicy namePolicy) {
        this.namePolicy = namePolicy;
    }

    public void setDocumentModeHandler(DocumentModeHandler documentModeHandler) {
        this.documentModeHandler = documentModeHandler;
    }

    public void setReportingDoctype(boolean reportingDoctype) {
        this.reportingDoctype = reportingDoctype;
    }

    public final void flushCharacters() throws SAXException {
        if (this.charBufferLen > 0) {
            if ((this.mode == 2 || this.mode == 1 || this.mode == 0) && this.charBufferContainsNonWhitespace()) {
                this.errNonSpaceInTable();
                this.reconstructTheActiveFormattingElements();
                if (!this.stack[this.currentPtr].isFosterParenting()) {
                    this.appendCharacters(this.currentNode(), this.charBuffer, 0, this.charBufferLen);
                    this.charBufferLen = 0;
                    return;
                }
                int tablePos = this.findLastOrRoot(34);
                int templatePos = this.findLastOrRoot(67);
                if (templatePos >= tablePos) {
                    this.appendCharacters(this.stack[templatePos].node, this.charBuffer, 0, this.charBufferLen);
                    this.charBufferLen = 0;
                    return;
                }
                StackNode<T> tableElt = this.stack[tablePos];
                this.insertFosterParentedCharacters(this.charBuffer, 0, this.charBufferLen, tableElt.node, this.stack[tablePos - 1].node);
                this.charBufferLen = 0;
                return;
            }
            this.appendCharacters(this.currentNode(), this.charBuffer, 0, this.charBufferLen);
            this.charBufferLen = 0;
        }
    }

    private boolean charBufferContainsNonWhitespace() {
        block3: for (int i = 0; i < this.charBufferLen; ++i) {
            switch (this.charBuffer[i]) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return true;
                }
            }
        }
        return false;
    }

    public TreeBuilderState<T> newSnapshot() throws SAXException {
        StackNode[] listCopy = new StackNode[this.listPtr + 1];
        for (int i = 0; i < listCopy.length; ++i) {
            StackNode<T> node = this.listOfActiveFormattingElements[i];
            if (node != null) {
                StackNode newNode = new StackNode(-1);
                newNode.setValues(node.getFlags(), node.ns, node.name, node.node, node.popName, node.attributes.cloneAttributes(null), node.getLocator());
                listCopy[i] = newNode;
                continue;
            }
            listCopy[i] = null;
        }
        StackNode[] stackCopy = new StackNode[this.currentPtr + 1];
        for (int i = 0; i < stackCopy.length; ++i) {
            StackNode<T> node = this.stack[i];
            int listIndex = this.findInListOfActiveFormattingElements(node);
            if (listIndex == -1) {
                StackNode newNode = new StackNode(-1);
                newNode.setValues(node.getFlags(), node.ns, node.name, node.node, node.popName, null, node.getLocator());
                stackCopy[i] = newNode;
                continue;
            }
            stackCopy[i] = listCopy[listIndex];
            stackCopy[i].retain();
        }
        int[] templateModeStackCopy = new int[this.templateModePtr + 1];
        System.arraycopy(this.templateModeStack, 0, templateModeStackCopy, 0, templateModeStackCopy.length);
        return new StateSnapshot<T>(stackCopy, listCopy, templateModeStackCopy, this.formPointer, this.headPointer, this.deepTreeSurrogateParent, this.mode, this.originalMode, this.framesetOk, this.needToDropLF, this.quirks);
    }

    public boolean snapshotMatches(TreeBuilderState<T> snapshot) {
        int i;
        StackNode<T>[] stackCopy = snapshot.getStack();
        int stackLen = snapshot.getStackLength();
        StackNode<T>[] listCopy = snapshot.getListOfActiveFormattingElements();
        int listLen = snapshot.getListOfActiveFormattingElementsLength();
        int[] templateModeStackCopy = snapshot.getTemplateModeStack();
        int templateModeStackLen = snapshot.getTemplateModeStackLength();
        if (stackLen != this.currentPtr + 1 || listLen != this.listPtr + 1 || templateModeStackLen != this.templateModePtr + 1 || this.formPointer != snapshot.getFormPointer() || this.headPointer != snapshot.getHeadPointer() || this.deepTreeSurrogateParent != snapshot.getDeepTreeSurrogateParent() || this.mode != snapshot.getMode() || this.originalMode != snapshot.getOriginalMode() || this.framesetOk != snapshot.isFramesetOk() || this.needToDropLF != snapshot.isNeedToDropLF() || this.quirks != snapshot.isQuirks()) {
            return false;
        }
        for (i = listLen - 1; i >= 0; --i) {
            if (listCopy[i] == null && this.listOfActiveFormattingElements[i] == null) continue;
            if (listCopy[i] == null || this.listOfActiveFormattingElements[i] == null) {
                return false;
            }
            if (listCopy[i].node == this.listOfActiveFormattingElements[i].node) continue;
            return false;
        }
        for (i = stackLen - 1; i >= 0; --i) {
            if (stackCopy[i].node == this.stack[i].node) continue;
            return false;
        }
        for (i = templateModeStackLen - 1; i >= 0; --i) {
            if (templateModeStackCopy[i] == this.templateModeStack[i]) continue;
            return false;
        }
        return true;
    }

    public void loadState(TreeBuilderState<T> snapshot, Interner interner) throws SAXException {
        StackNode<T> node;
        int i;
        StackNode<T>[] stackCopy = snapshot.getStack();
        int stackLen = snapshot.getStackLength();
        StackNode<T>[] listCopy = snapshot.getListOfActiveFormattingElements();
        int listLen = snapshot.getListOfActiveFormattingElementsLength();
        int[] templateModeStackCopy = snapshot.getTemplateModeStack();
        int templateModeStackLen = snapshot.getTemplateModeStackLength();
        for (i = 0; i <= this.listPtr; ++i) {
            if (this.listOfActiveFormattingElements[i] == null) continue;
            this.listOfActiveFormattingElements[i].release(this);
        }
        if (this.listOfActiveFormattingElements.length < listLen) {
            this.listOfActiveFormattingElements = new StackNode[listLen];
        }
        this.listPtr = listLen - 1;
        for (i = 0; i <= this.currentPtr; ++i) {
            this.stack[i].release(this);
        }
        if (this.stack.length < stackLen) {
            this.stack = new StackNode[stackLen];
        }
        this.currentPtr = stackLen - 1;
        if (this.templateModeStack.length < templateModeStackLen) {
            this.templateModeStack = new int[templateModeStackLen];
        }
        this.templateModePtr = templateModeStackLen - 1;
        for (i = 0; i < listLen; ++i) {
            node = listCopy[i];
            if (node != null) {
                StackNode newNode = this.createStackNode(node.getFlags(), node.ns, Portability.newLocalFromLocal(node.name, interner), node.node, Portability.newLocalFromLocal(node.popName, interner), node.attributes.cloneAttributes(null), node.getLocator());
                this.listOfActiveFormattingElements[i] = newNode;
                continue;
            }
            this.listOfActiveFormattingElements[i] = null;
        }
        for (i = 0; i < stackLen; ++i) {
            node = stackCopy[i];
            int listIndex = this.findInArray(node, listCopy);
            if (listIndex == -1) {
                StackNode newNode = this.createStackNode(node.getFlags(), node.ns, Portability.newLocalFromLocal(node.name, interner), node.node, Portability.newLocalFromLocal(node.popName, interner), null, node.getLocator());
                this.stack[i] = newNode;
                continue;
            }
            this.stack[i] = this.listOfActiveFormattingElements[listIndex];
            this.stack[i].retain();
        }
        System.arraycopy(templateModeStackCopy, 0, this.templateModeStack, 0, templateModeStackLen);
        this.formPointer = snapshot.getFormPointer();
        this.headPointer = snapshot.getHeadPointer();
        this.deepTreeSurrogateParent = snapshot.getDeepTreeSurrogateParent();
        this.mode = snapshot.getMode();
        this.originalMode = snapshot.getOriginalMode();
        this.framesetOk = snapshot.isFramesetOk();
        this.needToDropLF = snapshot.isNeedToDropLF();
        this.quirks = snapshot.isQuirks();
    }

    private int findInArray(StackNode<T> node, StackNode<T>[] arr) {
        for (int i = this.listPtr; i >= 0; --i) {
            if (node != arr[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public T getFormPointer() {
        return this.formPointer;
    }

    @Override
    public T getHeadPointer() {
        return this.headPointer;
    }

    @Override
    public T getDeepTreeSurrogateParent() {
        return this.deepTreeSurrogateParent;
    }

    @Override
    public StackNode<T>[] getListOfActiveFormattingElements() {
        return this.listOfActiveFormattingElements;
    }

    @Override
    public StackNode<T>[] getStack() {
        return this.stack;
    }

    @Override
    public int[] getTemplateModeStack() {
        return this.templateModeStack;
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    @Override
    public int getOriginalMode() {
        return this.originalMode;
    }

    @Override
    public boolean isFramesetOk() {
        return this.framesetOk;
    }

    @Override
    public boolean isNeedToDropLF() {
        return this.needToDropLF;
    }

    @Override
    public boolean isQuirks() {
        return this.quirks;
    }

    @Override
    public int getListOfActiveFormattingElementsLength() {
        return this.listPtr + 1;
    }

    @Override
    public int getStackLength() {
        return this.currentPtr + 1;
    }

    @Override
    public int getTemplateModeStackLength() {
        return this.templateModePtr + 1;
    }

    private void errStrayStartTag(@Local String name) throws SAXException {
        this.err("Stray start tag \u201c" + name + "\u201d.");
    }

    private void errStrayEndTag(@Local String name) throws SAXException {
        this.err("Stray end tag \u201c" + name + "\u201d.");
    }

    private void errUnclosedElements(int eltPos, @Local String name) throws SAXException {
        this.errNoCheck("End tag \u201c" + name + "\u201d seen, but there were open elements.");
        this.errListUnclosedStartTags(eltPos);
    }

    private void errUnclosedElementsImplied(int eltPos, String name) throws SAXException {
        this.errNoCheck("End tag \u201c" + name + "\u201d implied, but there were open elements.");
        this.errListUnclosedStartTags(eltPos);
    }

    private void errUnclosedElementsCell(int eltPos) throws SAXException {
        this.errNoCheck("A table cell was implicitly closed, but there were open elements.");
        this.errListUnclosedStartTags(eltPos);
    }

    private void errStrayDoctype() throws SAXException {
        this.err("Stray doctype.");
    }

    private void errAlmostStandardsDoctype() throws SAXException {
        if (!this.isSrcdocDocument) {
            this.err("Almost standards mode doctype. Expected \u201c<!DOCTYPE html>\u201d.");
        }
    }

    private void errQuirkyDoctype() throws SAXException {
        if (!this.isSrcdocDocument) {
            this.err("Quirky doctype. Expected \u201c<!DOCTYPE html>\u201d.");
        }
    }

    private void errNonSpaceInTrailer() throws SAXException {
        this.err("Non-space character in page trailer.");
    }

    private void errNonSpaceAfterFrameset() throws SAXException {
        this.err("Non-space after \u201cframeset\u201d.");
    }

    private void errNonSpaceInFrameset() throws SAXException {
        this.err("Non-space in \u201cframeset\u201d.");
    }

    private void errNonSpaceAfterBody() throws SAXException {
        this.err("Non-space character after body.");
    }

    private void errNonSpaceInColgroupInFragment() throws SAXException {
        this.err("Non-space in \u201ccolgroup\u201d when parsing fragment.");
    }

    private void errNonSpaceInNoscriptInHead() throws SAXException {
        this.err("Non-space character inside \u201cnoscript\u201d inside \u201chead\u201d.");
    }

    private void errFooBetweenHeadAndBody(@Local String name) throws SAXException {
        if (this.errorHandler == null) {
            return;
        }
        this.errNoCheck("\u201c" + name + "\u201d element between \u201chead\u201d and \u201cbody\u201d.");
    }

    private void errStartTagWithoutDoctype() throws SAXException {
        if (!this.isSrcdocDocument) {
            this.err("Start tag seen without seeing a doctype first. Expected \u201c<!DOCTYPE html>\u201d.");
        }
    }

    private void errNoSelectInTableScope() throws SAXException {
        this.err("No \u201cselect\u201d in table scope.");
    }

    private void errStartSelectWhereEndSelectExpected() throws SAXException {
        this.err("\u201cselect\u201d start tag where end tag expected.");
    }

    private void errStartTagWithSelectOpen(@Local String name) throws SAXException {
        if (this.errorHandler == null) {
            return;
        }
        this.errNoCheck("\u201c" + name + "\u201d start tag with \u201cselect\u201d open.");
    }

    private void errBadStartTagInHead(@Local String name) throws SAXException {
        if (this.errorHandler == null) {
            return;
        }
        this.errNoCheck("Bad start tag in \u201c" + name + "\u201d in \u201chead\u201d.");
    }

    private void errImage() throws SAXException {
        this.err("Saw a start tag \u201cimage\u201d.");
    }

    private void errFooSeenWhenFooOpen(@Local String name) throws SAXException {
        if (this.errorHandler == null) {
            return;
        }
        this.errNoCheck("Start tag \u201c" + name + "\u201d seen but an element of the same type was already open.");
    }

    private void errHeadingWhenHeadingOpen() throws SAXException {
        this.err("Heading cannot be a child of another heading.");
    }

    private void errFramesetStart() throws SAXException {
        this.err("\u201cframeset\u201d start tag seen.");
    }

    private void errNoCellToClose() throws SAXException {
        this.err("No cell to close.");
    }

    private void errStartTagInTable(@Local String name) throws SAXException {
        if (this.errorHandler == null) {
            return;
        }
        this.errNoCheck("Start tag \u201c" + name + "\u201d seen in \u201ctable\u201d.");
    }

    private void errFormWhenFormOpen() throws SAXException {
        this.err("Saw a \u201cform\u201d start tag, but there was already an active \u201cform\u201d element. Nested forms are not allowed. Ignoring the tag.");
    }

    private void errTableSeenWhileTableOpen() throws SAXException {
        this.err("Start tag for \u201ctable\u201d seen but the previous \u201ctable\u201d is still open.");
    }

    private void errStartTagInTableBody(@Local String name) throws SAXException {
        if (this.errorHandler == null) {
            return;
        }
        this.errNoCheck("\u201c" + name + "\u201d start tag in table body.");
    }

    private void errEndTagSeenWithoutDoctype() throws SAXException {
        if (!this.isSrcdocDocument) {
            this.err("End tag seen without seeing a doctype first. Expected \u201c<!DOCTYPE html>\u201d.");
        }
    }

    private void errEndTagAfterBody() throws SAXException {
        this.err("Saw an end tag after \u201cbody\u201d had been closed.");
    }

    private void errEndTagSeenWithSelectOpen(@Local String name) throws SAXException {
        if (this.errorHandler == null) {
            return;
        }
        this.errNoCheck("\u201c" + name + "\u201d end tag with \u201cselect\u201d open.");
    }

    private void errGarbageInColgroup() throws SAXException {
        this.err("Garbage in \u201ccolgroup\u201d fragment.");
    }

    private void errEndTagBr() throws SAXException {
        this.err("End tag \u201cbr\u201d.");
    }

    private void errNoElementToCloseButEndTagSeen(@Local String name) throws SAXException {
        if (this.errorHandler == null) {
            return;
        }
        this.errNoCheck("No \u201c" + name + "\u201d element in scope but a \u201c" + name + "\u201d end tag seen.");
    }

    private void errHtmlStartTagInForeignContext(@Local String name) throws SAXException {
        if (this.errorHandler == null) {
            return;
        }
        this.errNoCheck("HTML start tag \u201c" + name + "\u201d in a foreign namespace context.");
    }

    private void errTableClosedWhileCaptionOpen() throws SAXException {
        this.err("\u201ctable\u201d closed but \u201ccaption\u201d was still open.");
    }

    private void errNoTableRowToClose() throws SAXException {
        this.err("No table row to close.");
    }

    private void errNonSpaceInTable() throws SAXException {
        this.err("Misplaced non-space characters inside a table.");
    }

    private void errUnclosedChildrenInRuby() throws SAXException {
        if (this.errorHandler == null) {
            return;
        }
        this.errNoCheck("Unclosed children in \u201cruby\u201d.");
    }

    private void errStartTagSeenWithoutRuby(@Local String name) throws SAXException {
        if (this.errorHandler == null) {
            return;
        }
        this.errNoCheck("Start tag \u201c" + name + "\u201d seen without a \u201cruby\u201d element being open.");
    }

    private void errSelfClosing() throws SAXException {
        if (this.errorHandler == null) {
            return;
        }
        this.errNoCheck("Self-closing syntax (\u201c/>\u201d) used on a non-void HTML element. Ignoring the slash and treating as a start tag.");
    }

    private void errNoCheckUnclosedElementsOnStack() throws SAXException {
        this.errNoCheck("Unclosed elements on stack.");
    }

    private void errEndTagDidNotMatchCurrentOpenElement(@Local String name, @Local String currOpenName) throws SAXException {
        if (this.errorHandler == null) {
            return;
        }
        this.errNoCheck("End tag \u201c" + name + "\u201d did not match the name of the current open element (\u201c" + currOpenName + "\u201d).");
    }

    private void errEndTagViolatesNestingRules(@Local String name) throws SAXException {
        if (this.errorHandler == null) {
            return;
        }
        this.errNoCheck("End tag \u201c" + name + "\u201d violates nesting rules.");
    }

    private void errEofWithUnclosedElements() throws SAXException {
        if (this.errorHandler == null) {
            return;
        }
        this.errNoCheck("End of file seen and there were open elements.");
        this.errListUnclosedStartTags(0);
    }

    private void errEndWithUnclosedElements(@Local String name) throws SAXException {
        if (this.errorHandler == null) {
            return;
        }
        this.errNoCheck("End tag for  \u201c" + name + "\u201d seen, but there were unclosed elements.");
        this.errListUnclosedStartTags(0);
    }
}

