# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .consumer_name import ConsumerName
from .country_code import CountryCode
from .tag import Tag

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class LegalDocument(pydantic.BaseModel):
    """
    LegalDocument model generalizes User's identity document type (ex: Passport)
    """

    document_type: str = pydantic.Field(
        alias="documentType", description="User's identity document type such as passport, national ID etc."
    )
    document_number: str = pydantic.Field(
        alias="documentNumber", description="User's unique identity document number such as passport number"
    )
    document_issued_date: typing.Optional[float] = pydantic.Field(
        alias="documentIssuedDate",
        description="User's identity document issuance date (UNIX timestamp in milliseconds)",
    )
    document_expiration_date: typing.Optional[float] = pydantic.Field(
        alias="documentExpirationDate",
        description="User's identity document expiration date (UNIX timestamp in milliseconds)",
    )
    document_issued_country: CountryCode = pydantic.Field(alias="documentIssuedCountry")
    tags: typing.Optional[typing.List[Tag]] = pydantic.Field(
        description="Additional information that can be added via tags"
    )
    name_on_document: typing.Optional[ConsumerName] = pydantic.Field(alias="nameOnDocument")

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
