# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class RuleAction(str, enum.Enum):
    """
    Model for rule action if a rule is hit. This is returned in the API response and can be configured on Console by operational accounts like a Compliance Analyst
    """

    ALLOW = "ALLOW"
    FLAG = "FLAG"
    BLOCK = "BLOCK"
    SUSPEND = "SUSPEND"

    def visit(
        self,
        allow: typing.Callable[[], T_Result],
        flag: typing.Callable[[], T_Result],
        block: typing.Callable[[], T_Result],
        suspend: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is RuleAction.ALLOW:
            return allow()
        if self is RuleAction.FLAG:
            return flag()
        if self is RuleAction.BLOCK:
            return block()
        if self is RuleAction.SUSPEND:
            return suspend()
