"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const child_process_1 = require("child_process");
const fs = require("fs");
const path = require("path");
const util_1 = require("./util");
/**
 * Build with Parcel
 */
function build(options) {
    const pkgPath = util_1.findPkgPath();
    let originalPkg;
    try {
        if (options.nodeVersion && pkgPath) {
            // Update engines.node (Babel target)
            originalPkg = util_1.updatePkg(pkgPath, {
                engines: { node: `>= ${options.nodeVersion}` }
            });
        }
        const args = [
            'build', options.entry,
            '--out-dir', options.outDir,
            '--out-file', 'index.js',
            '--global', options.global,
            '--target', 'node',
            '--bundle-node-modules',
            '--log-level', '2',
            !options.minify && '--no-minify',
            !options.sourceMaps && '--no-source-maps',
            ...options.cacheDir
                ? ['--cache-dir', options.cacheDir]
                : [],
        ].filter(Boolean);
        const parcelPkgPath = require.resolve('parcel-bundler/package.json'); // eslint-disable-line @typescript-eslint/no-require-imports
        const parcelDir = path.dirname(parcelPkgPath);
        const parcelPkg = require(parcelPkgPath); // eslint-disable-line @typescript-eslint/no-require-imports
        const binPath = path.join(parcelDir, parcelPkg.bin.parcel);
        const parcel = child_process_1.spawnSync(binPath, args);
        if (parcel.error) {
            throw parcel.error;
        }
        if (parcel.status !== 0) {
            throw new Error(parcel.stdout.toString().trim());
        }
    }
    catch (err) {
        throw new Error(`Failed to build file at ${options.entry}: ${err}`);
    }
    finally { // Always restore package.json to original
        if (pkgPath && originalPkg) {
            fs.writeFileSync(pkgPath, originalPkg);
        }
    }
}
exports.build = build;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYnVpbGQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJidWlsZC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLGlEQUEwQztBQUMxQyx5QkFBeUI7QUFDekIsNkJBQTZCO0FBQzdCLGlDQUFnRDtBQTBDaEQ7O0dBRUc7QUFDSCxTQUFnQixLQUFLLENBQUMsT0FBcUI7SUFDekMsTUFBTSxPQUFPLEdBQUcsa0JBQVcsRUFBRSxDQUFDO0lBQzlCLElBQUksV0FBVyxDQUFDO0lBRWhCLElBQUk7UUFDRixJQUFJLE9BQU8sQ0FBQyxXQUFXLElBQUksT0FBTyxFQUFFO1lBQ2xDLHFDQUFxQztZQUNyQyxXQUFXLEdBQUcsZ0JBQVMsQ0FBQyxPQUFPLEVBQUU7Z0JBQy9CLE9BQU8sRUFBRSxFQUFFLElBQUksRUFBRSxNQUFNLE9BQU8sQ0FBQyxXQUFXLEVBQUUsRUFBRTthQUMvQyxDQUFDLENBQUM7U0FDSjtRQUVELE1BQU0sSUFBSSxHQUFHO1lBQ1gsT0FBTyxFQUFFLE9BQU8sQ0FBQyxLQUFLO1lBQ3RCLFdBQVcsRUFBRSxPQUFPLENBQUMsTUFBTTtZQUMzQixZQUFZLEVBQUUsVUFBVTtZQUN4QixVQUFVLEVBQUUsT0FBTyxDQUFDLE1BQU07WUFDMUIsVUFBVSxFQUFFLE1BQU07WUFDbEIsdUJBQXVCO1lBQ3ZCLGFBQWEsRUFBRSxHQUFHO1lBQ2xCLENBQUMsT0FBTyxDQUFDLE1BQU0sSUFBSSxhQUFhO1lBQ2hDLENBQUMsT0FBTyxDQUFDLFVBQVUsSUFBSSxrQkFBa0I7WUFDekMsR0FBRyxPQUFPLENBQUMsUUFBUTtnQkFDakIsQ0FBQyxDQUFDLENBQUMsYUFBYSxFQUFFLE9BQU8sQ0FBQyxRQUFRLENBQUM7Z0JBQ25DLENBQUMsQ0FBQyxFQUFFO1NBQ1AsQ0FBQyxNQUFNLENBQUMsT0FBTyxDQUFhLENBQUM7UUFFOUIsTUFBTSxhQUFhLEdBQUcsT0FBTyxDQUFDLE9BQU8sQ0FBQyw2QkFBNkIsQ0FBQyxDQUFDLENBQUMsNERBQTREO1FBQ2xJLE1BQU0sU0FBUyxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUMsYUFBYSxDQUFDLENBQUM7UUFDOUMsTUFBTSxTQUFTLEdBQUcsT0FBTyxDQUFDLGFBQWEsQ0FBQyxDQUFDLENBQUMsNERBQTREO1FBQ3RHLE1BQU0sT0FBTyxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsU0FBUyxFQUFFLFNBQVMsQ0FBQyxHQUFHLENBQUMsTUFBTSxDQUFDLENBQUM7UUFFM0QsTUFBTSxNQUFNLEdBQUcseUJBQVMsQ0FBQyxPQUFPLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFFeEMsSUFBSSxNQUFNLENBQUMsS0FBSyxFQUFFO1lBQ2hCLE1BQU0sTUFBTSxDQUFDLEtBQUssQ0FBQztTQUNwQjtRQUVELElBQUksTUFBTSxDQUFDLE1BQU0sS0FBSyxDQUFDLEVBQUU7WUFDdkIsTUFBTSxJQUFJLEtBQUssQ0FBQyxNQUFNLENBQUMsTUFBTSxDQUFDLFFBQVEsRUFBRSxDQUFDLElBQUksRUFBRSxDQUFDLENBQUM7U0FDbEQ7S0FDRjtJQUFDLE9BQU8sR0FBRyxFQUFFO1FBQ1osTUFBTSxJQUFJLEtBQUssQ0FBQywyQkFBMkIsT0FBTyxDQUFDLEtBQUssS0FBSyxHQUFHLEVBQUUsQ0FBQyxDQUFDO0tBQ3JFO1lBQVMsRUFBRSwwQ0FBMEM7UUFDcEQsSUFBSSxPQUFPLElBQUksV0FBVyxFQUFFO1lBQzFCLEVBQUUsQ0FBQyxhQUFhLENBQUMsT0FBTyxFQUFFLFdBQVcsQ0FBQyxDQUFDO1NBQ3hDO0tBQ0Y7QUFDSCxDQUFDO0FBaERELHNCQWdEQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IHNwYXduU3luYyB9IGZyb20gJ2NoaWxkX3Byb2Nlc3MnO1xuaW1wb3J0ICogYXMgZnMgZnJvbSAnZnMnO1xuaW1wb3J0ICogYXMgcGF0aCBmcm9tICdwYXRoJztcbmltcG9ydCB7IGZpbmRQa2dQYXRoLCB1cGRhdGVQa2cgfSBmcm9tICcuL3V0aWwnO1xuXG4vKipcbiAqIEJ1aWxkIG9wdGlvbnNcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBCdWlsZE9wdGlvbnMge1xuICAvKipcbiAgICogRW50cnkgZmlsZVxuICAgKi9cbiAgcmVhZG9ubHkgZW50cnk6IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIG91dHB1dCBkaXJlY3RvcnlcbiAgICovXG4gIHJlYWRvbmx5IG91dERpcjogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBFeHBvc2UgbW9kdWxlcyBhcyBVTUQgdW5kZXIgdGhpcyBuYW1lXG4gICAqL1xuICByZWFkb25seSBnbG9iYWw6IHN0cmluZztcblxuICAvKipcbiAgICogTWluaWZ5XG4gICAqL1xuICByZWFkb25seSBtaW5pZnk/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBJbmNsdWRlIHNvdXJjZSBtYXBzXG4gICAqL1xuICByZWFkb25seSBzb3VyY2VNYXBzPzogYm9vbGVhbjtcblxuICAvKipcbiAgICogVGhlIGNhY2hlIGRpcmVjdG9yeVxuICAgKi9cbiAgcmVhZG9ubHkgY2FjaGVEaXI/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBub2RlIHZlcnNpb24gdG8gdXNlIGFzIHRhcmdldCBmb3IgQmFiZWxcbiAgICovXG4gIHJlYWRvbmx5IG5vZGVWZXJzaW9uPzogc3RyaW5nO1xufVxuXG4vKipcbiAqIEJ1aWxkIHdpdGggUGFyY2VsXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiBidWlsZChvcHRpb25zOiBCdWlsZE9wdGlvbnMpOiB2b2lkIHtcbiAgY29uc3QgcGtnUGF0aCA9IGZpbmRQa2dQYXRoKCk7XG4gIGxldCBvcmlnaW5hbFBrZztcblxuICB0cnkge1xuICAgIGlmIChvcHRpb25zLm5vZGVWZXJzaW9uICYmIHBrZ1BhdGgpIHtcbiAgICAgIC8vIFVwZGF0ZSBlbmdpbmVzLm5vZGUgKEJhYmVsIHRhcmdldClcbiAgICAgIG9yaWdpbmFsUGtnID0gdXBkYXRlUGtnKHBrZ1BhdGgsIHtcbiAgICAgICAgZW5naW5lczogeyBub2RlOiBgPj0gJHtvcHRpb25zLm5vZGVWZXJzaW9ufWAgfVxuICAgICAgfSk7XG4gICAgfVxuXG4gICAgY29uc3QgYXJncyA9IFtcbiAgICAgICdidWlsZCcsIG9wdGlvbnMuZW50cnksXG4gICAgICAnLS1vdXQtZGlyJywgb3B0aW9ucy5vdXREaXIsXG4gICAgICAnLS1vdXQtZmlsZScsICdpbmRleC5qcycsXG4gICAgICAnLS1nbG9iYWwnLCBvcHRpb25zLmdsb2JhbCxcbiAgICAgICctLXRhcmdldCcsICdub2RlJyxcbiAgICAgICctLWJ1bmRsZS1ub2RlLW1vZHVsZXMnLFxuICAgICAgJy0tbG9nLWxldmVsJywgJzInLFxuICAgICAgIW9wdGlvbnMubWluaWZ5ICYmICctLW5vLW1pbmlmeScsXG4gICAgICAhb3B0aW9ucy5zb3VyY2VNYXBzICYmICctLW5vLXNvdXJjZS1tYXBzJyxcbiAgICAgIC4uLm9wdGlvbnMuY2FjaGVEaXJcbiAgICAgICAgPyBbJy0tY2FjaGUtZGlyJywgb3B0aW9ucy5jYWNoZURpcl1cbiAgICAgICAgOiBbXSxcbiAgICBdLmZpbHRlcihCb29sZWFuKSBhcyBzdHJpbmdbXTtcblxuICAgIGNvbnN0IHBhcmNlbFBrZ1BhdGggPSByZXF1aXJlLnJlc29sdmUoJ3BhcmNlbC1idW5kbGVyL3BhY2thZ2UuanNvbicpOyAvLyBlc2xpbnQtZGlzYWJsZS1saW5lIEB0eXBlc2NyaXB0LWVzbGludC9uby1yZXF1aXJlLWltcG9ydHNcbiAgICBjb25zdCBwYXJjZWxEaXIgPSBwYXRoLmRpcm5hbWUocGFyY2VsUGtnUGF0aCk7XG4gICAgY29uc3QgcGFyY2VsUGtnID0gcmVxdWlyZShwYXJjZWxQa2dQYXRoKTsgLy8gZXNsaW50LWRpc2FibGUtbGluZSBAdHlwZXNjcmlwdC1lc2xpbnQvbm8tcmVxdWlyZS1pbXBvcnRzXG4gICAgY29uc3QgYmluUGF0aCA9IHBhdGguam9pbihwYXJjZWxEaXIsIHBhcmNlbFBrZy5iaW4ucGFyY2VsKTtcblxuICAgIGNvbnN0IHBhcmNlbCA9IHNwYXduU3luYyhiaW5QYXRoLCBhcmdzKTtcblxuICAgIGlmIChwYXJjZWwuZXJyb3IpIHtcbiAgICAgIHRocm93IHBhcmNlbC5lcnJvcjtcbiAgICB9XG5cbiAgICBpZiAocGFyY2VsLnN0YXR1cyAhPT0gMCkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKHBhcmNlbC5zdGRvdXQudG9TdHJpbmcoKS50cmltKCkpO1xuICAgIH1cbiAgfSBjYXRjaCAoZXJyKSB7XG4gICAgdGhyb3cgbmV3IEVycm9yKGBGYWlsZWQgdG8gYnVpbGQgZmlsZSBhdCAke29wdGlvbnMuZW50cnl9OiAke2Vycn1gKTtcbiAgfSBmaW5hbGx5IHsgLy8gQWx3YXlzIHJlc3RvcmUgcGFja2FnZS5qc29uIHRvIG9yaWdpbmFsXG4gICAgaWYgKHBrZ1BhdGggJiYgb3JpZ2luYWxQa2cpIHtcbiAgICAgIGZzLndyaXRlRmlsZVN5bmMocGtnUGF0aCwgb3JpZ2luYWxQa2cpO1xuICAgIH1cbiAgfVxufVxuIl19