import typing
import bpy.types

GenericType = typing.TypeVar("GenericType")

def change_frame(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
    frame: typing.Optional[typing.Any] = 0.0,
    snap: typing.Optional[typing.Union[bool, typing.Any]] = False,
):
    """Interactively change the current frame number

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param frame: Frame
    :type frame: typing.Optional[typing.Any]
    :param snap: Snap
    :type snap: typing.Optional[typing.Union[bool, typing.Any]]
    """

    ...

def channel_select_keys(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
    extend: typing.Optional[typing.Union[bool, typing.Any]] = False,
):
    """Select all keyframes of channel under mouse

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param extend: Extend, Extend selection
    :type extend: typing.Optional[typing.Union[bool, typing.Any]]
    """

    ...

def channel_view_pick(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
    include_handles: typing.Optional[typing.Union[bool, typing.Any]] = True,
    use_preview_range: typing.Optional[typing.Union[bool, typing.Any]] = True,
):
    """Reset viewable area to show the channel under the cursor

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param include_handles: Include Handles, Include handles of keyframes when calculating extents
    :type include_handles: typing.Optional[typing.Union[bool, typing.Any]]
    :param use_preview_range: Use Preview Range, Ignore frames outside of the preview range
    :type use_preview_range: typing.Optional[typing.Union[bool, typing.Any]]
    """

    ...

def channels_bake(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
    range: typing.Optional[typing.Any] = (0, 0),
    step: typing.Optional[typing.Any] = 1.0,
    remove_outside_range: typing.Optional[typing.Union[bool, typing.Any]] = False,
    interpolation_type: typing.Optional[typing.Any] = "BEZIER",
    bake_modifiers: typing.Optional[typing.Union[bool, typing.Any]] = True,
):
    """Create keyframes following the current shape of F-Curves of selected channels

        :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
        :type execution_context: typing.Optional[typing.Union[str, int]]
        :type undo: typing.Optional[bool]
        :param range: Frame Range, The range in which to create new keys
        :type range: typing.Optional[typing.Any]
        :param step: Frame Step, At which interval to add keys
        :type step: typing.Optional[typing.Any]
        :param remove_outside_range: Remove Outside Range, Removes keys outside the given range, leaving only the newly baked
        :type remove_outside_range: typing.Optional[typing.Union[bool, typing.Any]]
        :param interpolation_type: Interpolation Type, Choose the interpolation type with which new keys will be added

    BEZIER
    Bézier -- New keys will be Bézier.

    LIN
    Linear -- New keys will be linear.

    CONST
    Constant -- New keys will be constant.
        :type interpolation_type: typing.Optional[typing.Any]
        :param bake_modifiers: Bake Modifiers, Bake Modifiers into keyframes and delete them after
        :type bake_modifiers: typing.Optional[typing.Union[bool, typing.Any]]
    """

    ...

def channels_clean_empty(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
):
    """Delete all empty animation data containers from visible data-blocks

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    """

    ...

def channels_click(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
    extend: typing.Optional[typing.Union[bool, typing.Any]] = False,
    extend_range: typing.Optional[typing.Union[bool, typing.Any]] = False,
    children_only: typing.Optional[typing.Union[bool, typing.Any]] = False,
):
    """Handle mouse clicks over animation channels

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param extend: Extend Select
    :type extend: typing.Optional[typing.Union[bool, typing.Any]]
    :param extend_range: Extend Range, Selection of active channel to clicked channel
    :type extend_range: typing.Optional[typing.Union[bool, typing.Any]]
    :param children_only: Select Children Only
    :type children_only: typing.Optional[typing.Union[bool, typing.Any]]
    """

    ...

def channels_collapse(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
    all: typing.Optional[typing.Union[bool, typing.Any]] = True,
):
    """Collapse (close) all selected expandable animation channels

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param all: All, Collapse all channels (not just selected ones)
    :type all: typing.Optional[typing.Union[bool, typing.Any]]
    """

    ...

def channels_delete(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
):
    """Delete all selected animation channels

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    """

    ...

def channels_editable_toggle(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
    mode: typing.Optional[typing.Any] = "TOGGLE",
    type: typing.Optional[typing.Any] = "PROTECT",
):
    """Toggle editability of selected channels

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param mode: Mode
    :type mode: typing.Optional[typing.Any]
    :param type: Type
    :type type: typing.Optional[typing.Any]
    """

    ...

def channels_expand(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
    all: typing.Optional[typing.Union[bool, typing.Any]] = True,
):
    """Expand (open) all selected expandable animation channels

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param all: All, Expand all channels (not just selected ones)
    :type all: typing.Optional[typing.Union[bool, typing.Any]]
    """

    ...

def channels_fcurves_enable(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
):
    """Clear 'disabled' tag from all F-Curves to get broken F-Curves working again

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    """

    ...

def channels_group(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
    name: typing.Union[str, typing.Any] = "New Group",
):
    """Add selected F-Curves to a new group

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param name: Name, Name of newly created group
    :type name: typing.Union[str, typing.Any]
    """

    ...

def channels_move(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
    direction: typing.Optional[typing.Any] = "DOWN",
):
    """Rearrange selected animation channels

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param direction: Direction
    :type direction: typing.Optional[typing.Any]
    """

    ...

def channels_rename(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
):
    """Rename animation channel under mouse

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    """

    ...

def channels_select_all(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
    action: typing.Optional[typing.Any] = "TOGGLE",
):
    """Toggle selection of all animation channels

        :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
        :type execution_context: typing.Optional[typing.Union[str, int]]
        :type undo: typing.Optional[bool]
        :param action: Action, Selection action to execute

    TOGGLE
    Toggle -- Toggle selection for all elements.

    SELECT
    Select -- Select all elements.

    DESELECT
    Deselect -- Deselect all elements.

    INVERT
    Invert -- Invert selection of all elements.
        :type action: typing.Optional[typing.Any]
    """

    ...

def channels_select_box(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
    xmin: typing.Optional[typing.Any] = 0,
    xmax: typing.Optional[typing.Any] = 0,
    ymin: typing.Optional[typing.Any] = 0,
    ymax: typing.Optional[typing.Any] = 0,
    wait_for_input: typing.Optional[typing.Union[bool, typing.Any]] = True,
    deselect: typing.Optional[typing.Union[bool, typing.Any]] = False,
    extend: typing.Optional[typing.Union[bool, typing.Any]] = True,
):
    """Select all animation channels within the specified region

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param xmin: X Min
    :type xmin: typing.Optional[typing.Any]
    :param xmax: X Max
    :type xmax: typing.Optional[typing.Any]
    :param ymin: Y Min
    :type ymin: typing.Optional[typing.Any]
    :param ymax: Y Max
    :type ymax: typing.Optional[typing.Any]
    :param wait_for_input: Wait for Input
    :type wait_for_input: typing.Optional[typing.Union[bool, typing.Any]]
    :param deselect: Deselect, Deselect rather than select items
    :type deselect: typing.Optional[typing.Union[bool, typing.Any]]
    :param extend: Extend, Extend selection instead of deselecting everything first
    :type extend: typing.Optional[typing.Union[bool, typing.Any]]
    """

    ...

def channels_select_filter(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
):
    """Start entering text which filters the set of channels shown to only include those with matching names

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    """

    ...

def channels_setting_disable(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
    mode: typing.Optional[typing.Any] = "DISABLE",
    type: typing.Optional[typing.Any] = "PROTECT",
):
    """Disable specified setting on all selected animation channels

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param mode: Mode
    :type mode: typing.Optional[typing.Any]
    :param type: Type
    :type type: typing.Optional[typing.Any]
    """

    ...

def channels_setting_enable(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
    mode: typing.Optional[typing.Any] = "ENABLE",
    type: typing.Optional[typing.Any] = "PROTECT",
):
    """Enable specified setting on all selected animation channels

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param mode: Mode
    :type mode: typing.Optional[typing.Any]
    :param type: Type
    :type type: typing.Optional[typing.Any]
    """

    ...

def channels_setting_toggle(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
    mode: typing.Optional[typing.Any] = "TOGGLE",
    type: typing.Optional[typing.Any] = "PROTECT",
):
    """Toggle specified setting on all selected animation channels

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param mode: Mode
    :type mode: typing.Optional[typing.Any]
    :param type: Type
    :type type: typing.Optional[typing.Any]
    """

    ...

def channels_ungroup(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
):
    """Remove selected F-Curves from their current groups

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    """

    ...

def channels_view_selected(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
    include_handles: typing.Optional[typing.Union[bool, typing.Any]] = True,
    use_preview_range: typing.Optional[typing.Union[bool, typing.Any]] = True,
):
    """Reset viewable area to show the selected channels

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param include_handles: Include Handles, Include handles of keyframes when calculating extents
    :type include_handles: typing.Optional[typing.Union[bool, typing.Any]]
    :param use_preview_range: Use Preview Range, Ignore frames outside of the preview range
    :type use_preview_range: typing.Optional[typing.Union[bool, typing.Any]]
    """

    ...

def clear_useless_actions(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
    only_unused: typing.Optional[typing.Union[bool, typing.Any]] = True,
):
    """Mark actions with no F-Curves for deletion after save and reload of file preserving "action libraries"

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param only_unused: Only Unused, Only unused (Fake User only) actions get considered
    :type only_unused: typing.Optional[typing.Union[bool, typing.Any]]
    """

    ...

def copy_driver_button(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
):
    """Copy the driver for the highlighted button

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    """

    ...

def driver_button_add(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
):
    """Add driver for the property under the cursor

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    """

    ...

def driver_button_edit(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
):
    """Edit the drivers for the connected property represented by the highlighted button

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    """

    ...

def driver_button_remove(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
    all: typing.Optional[typing.Union[bool, typing.Any]] = True,
):
    """Remove the driver(s) for the connected property(s) represented by the highlighted button

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param all: All, Delete drivers for all elements of the array
    :type all: typing.Optional[typing.Union[bool, typing.Any]]
    """

    ...

def end_frame_set(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
):
    """Set the current frame as the preview or scene end frame

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    """

    ...

def keyframe_clear_button(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
    all: typing.Optional[typing.Union[bool, typing.Any]] = True,
):
    """Clear all keyframes on the currently active property

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param all: All, Clear keyframes from all elements of the array
    :type all: typing.Optional[typing.Union[bool, typing.Any]]
    """

    ...

def keyframe_clear_v3d(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
    confirm: typing.Optional[typing.Union[bool, typing.Any]] = True,
):
    """Remove all keyframe animation for selected objects

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param confirm: Confirm, Prompt for confirmation
    :type confirm: typing.Optional[typing.Union[bool, typing.Any]]
    """

    ...

def keyframe_delete(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
    type: typing.Optional[typing.Union[str, int, typing.Any]] = "DEFAULT",
):
    """Delete keyframes on the current frame for all properties in the specified Keying Set

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param type: Keying Set, The Keying Set to use
    :type type: typing.Optional[typing.Union[str, int, typing.Any]]
    """

    ...

def keyframe_delete_button(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
    all: typing.Optional[typing.Union[bool, typing.Any]] = True,
):
    """Delete current keyframe of current UI-active property

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param all: All, Delete keyframes from all elements of the array
    :type all: typing.Optional[typing.Union[bool, typing.Any]]
    """

    ...

def keyframe_delete_by_name(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
    type: typing.Union[str, typing.Any] = "",
):
    """Alternate access to 'Delete Keyframe' for keymaps to use

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param type: Keying Set, The Keying Set to use
    :type type: typing.Union[str, typing.Any]
    """

    ...

def keyframe_delete_v3d(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
    confirm: typing.Optional[typing.Union[bool, typing.Any]] = True,
):
    """Remove keyframes on current frame for selected objects and bones

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param confirm: Confirm, Prompt for confirmation
    :type confirm: typing.Optional[typing.Union[bool, typing.Any]]
    """

    ...

def keyframe_insert(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
    type: typing.Optional[typing.Union[str, int, typing.Any]] = "DEFAULT",
):
    """Insert keyframes on the current frame using either the active keying set, or the user preferences if no keying set is active

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param type: Keying Set, The Keying Set to use
    :type type: typing.Optional[typing.Union[str, int, typing.Any]]
    """

    ...

def keyframe_insert_button(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
    all: typing.Optional[typing.Union[bool, typing.Any]] = True,
):
    """Insert a keyframe for current UI-active property

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param all: All, Insert a keyframe for all element of the array
    :type all: typing.Optional[typing.Union[bool, typing.Any]]
    """

    ...

def keyframe_insert_by_name(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
    type: typing.Union[str, typing.Any] = "",
):
    """Alternate access to 'Insert Keyframe' for keymaps to use

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param type: Keying Set, The Keying Set to use
    :type type: typing.Union[str, typing.Any]
    """

    ...

def keyframe_insert_menu(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
    type: typing.Optional[typing.Union[str, int, typing.Any]] = "DEFAULT",
    always_prompt: typing.Optional[typing.Union[bool, typing.Any]] = False,
):
    """Insert Keyframes for specified Keying Set, with menu of available Keying Sets if undefined

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param type: Keying Set, The Keying Set to use
    :type type: typing.Optional[typing.Union[str, int, typing.Any]]
    :param always_prompt: Always Show Menu
    :type always_prompt: typing.Optional[typing.Union[bool, typing.Any]]
    """

    ...

def keying_set_active_set(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
    type: typing.Optional[typing.Union[str, int, typing.Any]] = "DEFAULT",
):
    """Set a new active keying set

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param type: Keying Set, The Keying Set to use
    :type type: typing.Optional[typing.Union[str, int, typing.Any]]
    """

    ...

def keying_set_add(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
):
    """Add a new (empty) keying set to the active Scene

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    """

    ...

def keying_set_export(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
    filepath: typing.Union[str, typing.Any] = "",
    filter_folder: typing.Optional[typing.Union[bool, typing.Any]] = True,
    filter_text: typing.Optional[typing.Union[bool, typing.Any]] = True,
    filter_python: typing.Optional[typing.Union[bool, typing.Any]] = True,
):
    """Export Keying Set to a Python script

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param filepath: filepath
    :type filepath: typing.Union[str, typing.Any]
    :param filter_folder: Filter folders
    :type filter_folder: typing.Optional[typing.Union[bool, typing.Any]]
    :param filter_text: Filter text
    :type filter_text: typing.Optional[typing.Union[bool, typing.Any]]
    :param filter_python: Filter Python
    :type filter_python: typing.Optional[typing.Union[bool, typing.Any]]
    """

    ...

def keying_set_path_add(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
):
    """Add empty path to active keying set

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    """

    ...

def keying_set_path_remove(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
):
    """Remove active Path from active keying set

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    """

    ...

def keying_set_remove(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
):
    """Remove the active keying set

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    """

    ...

def keyingset_button_add(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
    all: typing.Optional[typing.Union[bool, typing.Any]] = True,
):
    """Add current UI-active property to current keying set

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param all: All, Add all elements of the array to a Keying Set
    :type all: typing.Optional[typing.Union[bool, typing.Any]]
    """

    ...

def keyingset_button_remove(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
):
    """Remove current UI-active property from current keying set

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    """

    ...

def paste_driver_button(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
):
    """Paste the driver in the internal clipboard to the highlighted button

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    """

    ...

def previewrange_clear(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
):
    """Clear preview range

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    """

    ...

def previewrange_set(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
    xmin: typing.Optional[typing.Any] = 0,
    xmax: typing.Optional[typing.Any] = 0,
    ymin: typing.Optional[typing.Any] = 0,
    ymax: typing.Optional[typing.Any] = 0,
    wait_for_input: typing.Optional[typing.Union[bool, typing.Any]] = True,
):
    """Interactively define frame range used for playback

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param xmin: X Min
    :type xmin: typing.Optional[typing.Any]
    :param xmax: X Max
    :type xmax: typing.Optional[typing.Any]
    :param ymin: Y Min
    :type ymin: typing.Optional[typing.Any]
    :param ymax: Y Max
    :type ymax: typing.Optional[typing.Any]
    :param wait_for_input: Wait for Input
    :type wait_for_input: typing.Optional[typing.Union[bool, typing.Any]]
    """

    ...

def start_frame_set(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
):
    """Set the current frame as the preview or scene start frame

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    """

    ...

def update_animated_transform_constraints(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
    use_convert_to_radians: typing.Optional[typing.Union[bool, typing.Any]] = True,
):
    """Update f-curves/drivers affecting Transform constraints (use it with files from 2.70 and earlier)

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param use_convert_to_radians: Convert to Radians, Convert f-curves/drivers affecting rotations to radians.Warning: Use this only once
    :type use_convert_to_radians: typing.Optional[typing.Union[bool, typing.Any]]
    """

    ...

def view_curve_in_graph_editor(
    override_context: typing.Optional[typing.Union[dict, bpy.types.Context]] = None,
    execution_context: typing.Optional[typing.Union[str, int]] = None,
    undo: typing.Optional[bool] = None,
    all: typing.Optional[typing.Union[bool, typing.Any]] = False,
    isolate: typing.Optional[typing.Union[bool, typing.Any]] = False,
):
    """Frame the property under the cursor in the Graph Editor

    :type override_context: typing.Optional[typing.Union[dict, bpy.types.Context]]
    :type execution_context: typing.Optional[typing.Union[str, int]]
    :type undo: typing.Optional[bool]
    :param all: Show All, Frame the whole array property instead of only the index under the cursor
    :type all: typing.Optional[typing.Union[bool, typing.Any]]
    :param isolate: Isolate, Hides all F-Curves other than the ones being framed
    :type isolate: typing.Optional[typing.Union[bool, typing.Any]]
    """

    ...
