import re

from .en import English


class Deutsch(English):
    language = "de"

    MONTHS = {
        "Januar",
        "Februar",
        "März",
        "April",
        "Mai",
        "Juni",
        "Juli",
        "August",
        "September",
        "Oktober",
        "November",
        "Dezember",
    }

    abbreviations = English.abbreviations.union(
        {
            "ä",
            "Ä",
            "adj",
            "adm",
            "adv",
            "ao.univ.prof",
            "art",
            "ass.prof",
            "ass",
            "asst",
            "b.a",
            "b.s",
            "bart",
            "bldg",
            "brig",
            "bros",
            "bse",
            "buchst",
            "bzgl",
            "bzw",
            "c.-à-d",
            "ca",
            "capt",
            "chr",
            "cmdr",
            "co",
            "col",
            "comdr",
            "con",
            "corp",
            "cpl",
            "d.h",
            "d.j",
            "dergl",
            "dgl",
            "di",
            "dipl.-ing",
            "dkr",
            "dr ",
            "ens",
            "etc",
            "ev ",
            "evtl",
            "ff",
            "g.g.a",
            "g.u",
            "gen",
            "ggf",
            "gov",
            "hon.prof",
            "hon",
            "hosp",
            "i.f",
            "i.h.v",
            "ii",
            "iii",
            "insp",
            "iv",
            "ix",
            "jun",
            "k.o",
            "kath",
            "lfd",
            "lt",
            "ltd",
            "m.e",
            "mag",
            "maj",
            "med",
            "messrs",
            "mio",
            "mlle",
            "mm",
            "mme",
            "mr",
            "mrd",
            "mrs",
            "ms",
            "msgr",
            "mwst",
            "no",
            "nos",
            "nr",
            "o.ä",
            "o.univ.-prof",
            "op",
            "ord",
            "pfc",
            "ph",
            "pp",
            "prof",
            "projektass",
            "pvt",
            "rep",
            "reps",
            "res",
            "rev",
            "rt",
            "s",
            "s.p.a",
            "sa",
            "sen",
            "sens",
            "sfc",
            "sgt",
            "sog",
            "sogen",
            "spp",
            "sr",
            "st",
            "std",
            "str  ",
            "stud.ass",
            "supt",
            "surg",
            "T",
            "u.a  ",
            "u.ä",
            "u.e",
            "u.s.w",
            "u.u",
            "univ.-doz",
            "univ.-prof",
            "univ.ass",
            "usf",
            "usw",
            "v",
            "vgl",
            "vi",
            "vii",
            "viii",
            "vs",
            "x",
            "xi",
            "xii",
            "xiii",
            "xiv",
            "xix",
            "xv",
            "xvi",
            "xvii",
            "xviii",
            "xx",
            "z.b",
            "z.t",
            "z.z",
            "z.zt",
            "zt",
            "zzt",
        }
    )

    def continue_in_next_word(self, text_after_boundary) -> bool:
        if re.match(r"^\W*[0-9a-z]", text_after_boundary):
            return True
        next_word = text_after_boundary.strip().split(" ")[0]
        next_word = next_word.strip("?!.")
        if len(next_word) == 0:
            return False
        if next_word in self.MONTHS or (next_word[0].upper() + next_word[1:] in self.MONTHS):
            return True
        return False

    def is_punctuation_between_quotes(self) -> bool:
        return True
