import re

from sentencex.base import Language


class Kazakh(Language):
    language = "kk"

    abbreviations = {
        "afp",
        "anp",
        "atp",
        "aбб",
        "bae",
        "bg",
        "bp",
        "cam",
        "cctv",
        "cd",
        "cez",
        "cgi",
        "cnpc",
        "dvd",
        "eiti",
        "epo",
        "er",
        "farc",
        "fbi",
        "gp",
        "gps",
        "has",
        "hiv",
        "hrh",
        "http",
        "icu",
        "idf",
        "imd",
        "ime",
        "ip",
        "iso",
        "kaz",
        "kpa",
        "kpo",
        "kz",
        "mgm",
        "mri",
        "nasa",
        "nba",
        "nbc",
        "nds",
        "ohl",
        "omlt",
        "pda",
        "pkk",
        "ppm",
        "psm",
        "psp",
        "raf",
        "rss",
        "rtl",
        "sas",
        "sme",
        "sms",
        "tnt",
        "udf",
        "uefa",
        "usb",
        "utc",
        "x",
        "zdf",
        "а.",
        "аақ",
        "авг.",
        "аек",
        "ак",
        "акад.",
        "акср",
        "акцион.",
        "ақ",
        "ақш",
        "амт",
        "англ",
        "аөсшк",
        "апр.",
        "апр",
        "аум.",
        "аф",
        "ацат",
        "әқбк",
        "әөк",
        "әч",
        "б. з. б.",
        "б. з. д.",
        "б. т.",
        "б. э. д.",
        "б.б.",
        "ббс",
        "биікт.",
        "биол.",
        "биохим",
        "бмтрк",
        "боак",
        "бө",
        "бсн",
        "бта",
        "бұұ",
        "бхооо",
        "вич",
        "всоонл",
        "г",
        "геогр.",
        "геол.",
        "гленкор",
        "гсбп",
        "гсдп",
        "гулаг",
        "гэс",
        "ғ. с.",
        "ғ.",
        "дек.",
        "дк",
        "днқ",
        "дсұ",
        "еақк",
        "еаэы",
        "еқыұ",
        "ембімұнайгаз",
        "ео",
        "еуразэқ",
        "еуроодақ",
        "еұу",
        "еэы",
        "ж.",
        "жж.",
        "жіө",
        "жко",
        "жкт",
        "жққ",
        "жоо",
        "жсдп",
        "жск",
        "жтсх",
        "жхл",
        "жшс",
        "жэк",
        "зоо",
        "и.",
        "инта",
        "исаф",
        "іім",
        "камаз",
        "кг",
        "кгб",
        "кеу",
        "кимеп",
        "км",
        "км²",
        "км³",
        "кмс",
        "кокп",
        "кота",
        "кср",
        "ксро",
        "кту",
        "кхдр",
        "қ.",
        "қазатомпром",
        "қазкср",
        "қазмұнайгаз",
        "қазпошта",
        "қазтаг",
        "қазұу",
        "қк",
        "қкп",
        "ққс",
        "қмдб",
        "қр",
        "қхр",
        "лат.",
        "м.",
        "м",
        "м²",
        "м³",
        "магатэ",
        "маж",
        "май.",
        "максам",
        "мб",
        "мбф",
        "мвт",
        "мемдум",
        "мемл",
        "мин",
        "мқо",
        "млн",
        "млрд",
        "мм.",
        "мм",
        "мр",
        "мсоп",
        "мт",
        "мтк",
        "мыс.",
        "наса",
        "нато",
        "нквд",
        "нояб.",
        "нұсжп",
        "оар",
        "обб",
        "обл.",
        "огпу",
        "оеб",
        "окт.",
        "оңт.",
        "опек",
        "өгк",
        "өзенмұнайгаз",
        "өұқ",
        "өф",
        "пәк",
        "пед.",
        "пиқ",
        "р.",
        "ржмб",
        "ркфср",
        "рлдп",
        "рнқ",
        "рсфср",
        "ртж",
        "руб",
        "рф",
        "рфкп",
        "с.",
        "с.ш.",
        "сбд",
        "сбл",
        "свс",
        "сву",
        "сду",
        "сент.",
        "сес",
        "см",
        "снпс",
        "солт.",
        "сооно",
        "спбму",
        "сср",
        "ссро",
        "ссс",
        "ссср",
        "сэс",
        "т. б.",
        "т. с. с.",
        "т.",
        "т.с.с",
        "т",
        "тв",
        "тереңд.",
        "тех.",
        "тж",
        "тжқ",
        "тим",
        "тмд",
        "төм.",
        "тр",
        "трлн",
        "тэц",
        "уаз",
        "уефа",
        "ук",
        "ұқк",
        "ұқшұ",
        "февр.",
        "фкққ",
        "фққ",
        "фсб",
        "хвқ",
        "хдо",
        "хдп",
        "хим.",
        "хқко",
        "хтқо",
        "цас",
        "цтп",
        "ш.",
        "ш.б.",
        "шұар",
        "шыұ",
        "экон.",
        "экспо",
        "эқк",
        "эөкк",
        "эыдұ",
        "юнеско",
        "янв.",
        "А",
        "М",
        "Т",
    }

    def continue_in_next_word(self, text_after_boundary) -> bool:
        return re.match(r"^\W*[0-9a-zа-я]", text_after_boundary)
