from sentencex.base import Language


class Portuguese(Language):
    language = "pt"

    roman_numerals = (
        "i ii iii iv v vi vii viii ix x xi xii xiii xiv x xi xii xiii xv xvi xvii xviii xix xx"
    )
    roman_numerals_set = set(roman_numerals.split(" ") + roman_numerals.upper().split(" "))
    abbreviations = roman_numerals_set.union(
        {
            "Adj",
            "Adm",
            "Adv",
            "Art",
            "Ca",
            "Capt",
            "Cmdr",
            "Col",
            "Comdr",
            "Con",
            "Corp",
            "Cpl",
            "DR",
            "DRA",
            "Dr",
            "Dra",
            "Dras",
            "Drs",
            "Eng",
            "Enga",
            "Engas",
            "Engos",
            "Ex",
            "Exo",
            "Exmo",
            "Fig",
            "Gen",
            "Hosp",
            "Insp",
            "Lda",
            "MM",
            "MR",
            "MRS",
            "MS",
            "Maj",
            "Mrs",
            "Ms",
            "Msgr",
            "Op",
            "Ord",
            "Pfc",
            "Ph",
            "Prof",
            "Pvt",
            "Rep",
            "Reps",
            "Res",
            "Rev",
            "Rt",
            "Sen",
            "Sens",
            "Sfc",
            "Sgt",
            "Sr",
            "Sra",
            "Sras",
            "Srs",
            "Sto",
            "Supt",
            "Surg",
            "adj",
            "adm",
            "adv",
            "art",
            "cit",
            "col",
            "con",
            "corp",
            "cpl",
            "dr",
            "dra",
            "dras",
            "drs",
            "eng",
            "enga",
            "engas",
            "engos",
            "ex",
            "exo",
            "exmo",
            "fig",
            "op",
            "prof",
            "sr",
            "sra",
            "sras",
            "srs",
            "sto",
            "v",
            "vs",
            "i.e",
            "rev",
            "e.g",
        }
    )
