import re

from sentencex.base import Language


class Russian(Language):
    language = "ru"

    abbreviations = {
        "y.e",
        "y",
        "а",
        "авт",
        "адм.-терр",
        "акад",
        "в",
        "вв",
        "вкз",
        "вост.-европ",
        "г",
        "гг",
        "гос",
        "гр",
        "д",
        "деп",
        "дисс",
        "дол",
        "долл",
        "ежедн",
        "ж",
        "жен",
        "з",
        "зап.-европ",
        "зап",
        "заруб",
        "и",
        "ин",
        "иностр",
        "инст",
        "к",
        "канд",
        "кв",
        "кг",
        "куб",
        "л.h",
        "л.н",
        "л",
        "м",
        "мин",
        "моск",
        "муж",
        "н",
        "нед",
        "о",
        "п",
        "пгт",
        "пер",
        "пп",
        "пр",
        "просп",
        "проф",
        "р",
        "руб",
        "с",
        "сек",
        "см",
        "спб",
        "стр",
        "т",
        "тел",
        "тов",
        "тт",
        "тыс",
        "у.е",
        "у",
        "ул",
        "ф",
        "ч",
    }

    def continue_in_next_word(self, text_after_boundary) -> bool:
        return re.match(r"^[0-9a-zа-я]", text_after_boundary)
