import re

from sentencex.base import Language


class Slovak(Language):
    language = "sk"
    MONTHS = {
        "Január",
        "Február",
        "Marec",
        "Apríl",
        "Máj",
        "Jún",
        "Júl",
        "August",
        "September",
        "Október",
        "November",
        "December",
        "Januára",
        "Februára",
        "Marca",
        "Apríla",
        "Mája",
        "Júna",
        "Júla",
        "Augusta",
        "Septembra",
        "Októbra",
        "Novembra",
        "Decembra",
    }
    roman_numerals = (
        "i ii iii iv v vi vii viii ix x xi xii xiii xiv x xi xii xiii xv xvi xvii xviii xix xx"
    )
    roman_numerals_set = set(roman_numerals.split(" ") + roman_numerals.upper().split(" "))
    abbreviations = roman_numerals_set.union(
        {
            "a. d",
            "a. g. p",
            "a. i. i",
            "a. k. a",
            "a. m",
            "a. r. k",
            "a. s. a. p",
            "a. s",
            "a. v",
            "a.d",
            "a.g.p",
            "a.i.i",
            "a.k.a",
            "a.m",
            "a.s.a.p",
            "a.s",
            "a.v",
            "akad",
            "al",
            "apod",
            "arm",
            "atď.",
            "atd",
            "atď",
            "bc",
            "bros",
            "c. k",
            "c.k",
            "č",
            "cca",
            "co",
            "corp",
            "čs",
            "csc",
            "čsl",
            "d. c",
            "d.c",
            "doc",
            "dr",
            "drsc",
            "e. t",
            "e.t",
            "el",
            "etc",
            "ev",
            "gen",
            "hl",
            "hod",
            "i. b",
            "i.b",
            "ii",
            "iii",
            "inc",
            "ind",
            "ing",
            "iv",
            "jr",
            "judr",
            "k. o",
            "k.o",
            "kol",
            "konkr",
            "kt",
            "ll. m",
            "ll.m",
            "ltd",
            "m. n. m",
            "m.n.m",
            "m.o",
            "max",
            "mgr",
            "mil",
            "min",
            "ml",
            "mld",
            "mr",
            "mudr",
            "mvdr",
            "n. a",
            "n. o",
            "n. w. a",
            "n.a",
            "n.o",
            "n.w.a",
            "nám",
            "napr",
            "např",
            "naprk",
            "nár",
            "nešp",
            "no",
            "nr",
            "o. c. p",
            "o. f. i",
            "o. k",
            "o. z",
            "o.c.p",
            "o.f.i",
            "o.i",
            "o.k",
            "o.z",
            "obr",
            "obv",
            "odd",
            "ods",
            "os",
            "p. a",
            "p. n. l",
            "p. s",
            "p.a",
            "p.n.l",
            "p.s",
            "p",
            "paeddr",
            "pedg",
            "ph. d",
            "ph.d",
            "phd",
            "phdr",
            "písm",
            "plgr",
            "pod",
            "pok",
            "pol. pr",
            "pol.pr",
            "por",
            "pozn",
            "pp",
            "pr",
            "prek",
            "príp",
            "prof",
            "r. o",
            "r.o",
            "red",
            "resp",
            "rndr",
            "roz",
            "rozh",
            "rsdr",
            "rtg",
            "s. a",
            "s. e. g",
            "š. p",
            "s. r. o",
            "s.a",
            "s.e.g",
            "š.p",
            "s.r.o",
            "skr",
            "sl",
            "slov",
            "soc",
            "sp",
            "spol",
            "sr",
            "st",
            "št",
            "stor",
            "str",
            "stred",
            "súkr",
            "sv",
            "sz",
            "t. č",
            "t. j",
            "t. z",
            "t.č",
            "t.j",
            "t.z",
            "tel",
            "tis",
            "tj",
            "tr",
            "tu",
            "tvz",
            "tz",
            "tzn",
            "tzv",
            "ú. p. v. o",
            "u. s",
            "ú.p.v.o",
            "u.s",
            "ul",
            "v. sp",
            "v.sp",
            "var",
            "vi",
            "viď",
            "vs",
            "vyd",
            "vz",
            "xx",
            "z. z",
            "z.z",
            "zák",
            "zb",
            "zdravot",
            "zs",
            "zz",
        }
    )

    def continue_in_next_word(self, text_after_boundary) -> bool:
        if re.match(r"^\W*[0-9a-z]", text_after_boundary):
            return True
        next_word = text_after_boundary.strip().split(" ")[0]

        if len(next_word) == 0:
            return False
        if next_word in self.MONTHS or (next_word[0].upper() + next_word[1:] in self.MONTHS):
            return True
        return False
