# Generated by Django 2.0.7 on 2018-08-19 16:40

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


def set_notification_creators(apps, schema_editor):
    EmailRecipient = apps.get_model('notifications', 'EmailRecipient')
    for recipient in EmailRecipient.objects.all():
        recipient.created_by = recipient.site.created_by
        recipient.save()
    SlackRecipient = apps.get_model('notifications', 'SlackRecipient')
    for recipient in SlackRecipient.objects.all():
        recipient.created_by = recipient.site.created_by
        recipient.save()


def no_operation(apps, schema_editor):
    pass


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('notifications', '0005_slack_recipient'),
    ]

    operations = [
        migrations.AddField(
            model_name='emailrecipient',
            name='created_by',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='slackrecipient',
            name='created_by',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL),
        ),
        migrations.RunPython(
            set_notification_creators, reverse_code=no_operation,
        ),
    ]
