"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .accountstatus import AccountStatus
from .accounttype import AccountType
from .supplementaldata import SupplementalData, SupplementalDataTypedDict
from .validdatatypelinks import ValidDataTypeLinks, ValidDataTypeLinksTypedDict
from codat_accounting.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from codat_accounting.utils import serialize_decimal, validate_decimal
from decimal import Decimal
import pydantic
from pydantic import model_serializer
from pydantic.functional_serializers import PlainSerializer
from pydantic.functional_validators import BeforeValidator
from typing import List, Optional, TypedDict
from typing_extensions import Annotated, NotRequired


class AccountPrototypeTypedDict(TypedDict):
    currency: NotRequired[str]
    r"""The currency data type in Codat is the [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code, e.g. _GBP_.

    ## Unknown currencies

    In line with the ISO 4217 specification, the code _XXX_ is used when the data source does not return a currency for a transaction.

    There are only a very small number of edge cases where this currency code is returned by the Codat system.
    """
    current_balance: NotRequired[Nullable[Decimal]]
    r"""Current balance in the account."""
    description: NotRequired[Nullable[str]]
    r"""Description for the account."""
    fully_qualified_category: NotRequired[Nullable[str]]
    r"""Full category of the account.

    For example, `Liability.Current` or `Income.Revenue`. To determine a list of possible categories for each integration, see our examples, follow our [Create, update, delete data](https://docs.codat.io/using-the-api/push) guide, or refer to the integration's own documentation.
    """
    fully_qualified_name: NotRequired[Nullable[str]]
    r"""Full name of the account, for example:
    - `Cash On Hand`
    - `Rents Held In Trust`
    - `Fixed Asset`
    """
    is_bank_account: NotRequired[bool]
    r"""Confirms whether the account is a bank account or not."""
    name: NotRequired[Nullable[str]]
    r"""Name of the account."""
    nominal_code: NotRequired[Nullable[str]]
    r"""Reference given to each nominal account for a business. It ensures money is allocated to the correct account. This code isn't a unique identifier in the Codat system."""
    status: NotRequired[AccountStatus]
    r"""Status of the account"""
    supplemental_data: NotRequired[SupplementalDataTypedDict]
    r"""Supplemental data is additional data you can include in our standard data types.

    It is referenced as a configured dynamic key value pair that is unique to the accounting software. [Learn more](https://docs.codat.io/using-the-api/supplemental-data/overview) about supplemental data.
    """
    type: NotRequired[AccountType]
    r"""Type of account"""
    valid_datatype_links: NotRequired[Nullable[List[ValidDataTypeLinksTypedDict]]]
    r"""The validDatatypeLinks can be used to determine whether an account can be correctly mapped to another object; for example, accounts with a `type` of `income` might only support being used on an Invoice and Direct Income. For more information, see [Valid Data Type Links](/accounting-api#/schemas/ValidDataTypeLinks)."""


class AccountPrototype(BaseModel):
    currency: Optional[str] = None
    r"""The currency data type in Codat is the [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code, e.g. _GBP_.

    ## Unknown currencies

    In line with the ISO 4217 specification, the code _XXX_ is used when the data source does not return a currency for a transaction.

    There are only a very small number of edge cases where this currency code is returned by the Codat system.
    """

    current_balance: Annotated[
        Annotated[
            OptionalNullable[Decimal],
            BeforeValidator(validate_decimal),
            PlainSerializer(serialize_decimal(False)),
        ],
        pydantic.Field(alias="currentBalance"),
    ] = UNSET
    r"""Current balance in the account."""

    description: OptionalNullable[str] = UNSET
    r"""Description for the account."""

    fully_qualified_category: Annotated[
        OptionalNullable[str], pydantic.Field(alias="fullyQualifiedCategory")
    ] = UNSET
    r"""Full category of the account.

    For example, `Liability.Current` or `Income.Revenue`. To determine a list of possible categories for each integration, see our examples, follow our [Create, update, delete data](https://docs.codat.io/using-the-api/push) guide, or refer to the integration's own documentation.
    """

    fully_qualified_name: Annotated[
        OptionalNullable[str], pydantic.Field(alias="fullyQualifiedName")
    ] = UNSET
    r"""Full name of the account, for example:
    - `Cash On Hand`
    - `Rents Held In Trust`
    - `Fixed Asset`
    """

    is_bank_account: Annotated[
        Optional[bool], pydantic.Field(alias="isBankAccount")
    ] = None
    r"""Confirms whether the account is a bank account or not."""

    name: OptionalNullable[str] = UNSET
    r"""Name of the account."""

    nominal_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="nominalCode")
    ] = UNSET
    r"""Reference given to each nominal account for a business. It ensures money is allocated to the correct account. This code isn't a unique identifier in the Codat system."""

    status: Optional[AccountStatus] = None
    r"""Status of the account"""

    supplemental_data: Annotated[
        Optional[SupplementalData], pydantic.Field(alias="supplementalData")
    ] = None
    r"""Supplemental data is additional data you can include in our standard data types.

    It is referenced as a configured dynamic key value pair that is unique to the accounting software. [Learn more](https://docs.codat.io/using-the-api/supplemental-data/overview) about supplemental data.
    """

    type: Optional[AccountType] = None
    r"""Type of account"""

    valid_datatype_links: Annotated[
        OptionalNullable[List[ValidDataTypeLinks]],
        pydantic.Field(alias="validDatatypeLinks"),
    ] = UNSET
    r"""The validDatatypeLinks can be used to determine whether an account can be correctly mapped to another object; for example, accounts with a `type` of `income` might only support being used on an Invoice and Direct Income. For more information, see [Valid Data Type Links](/accounting-api#/schemas/ValidDataTypeLinks)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "currency",
            "currentBalance",
            "description",
            "fullyQualifiedCategory",
            "fullyQualifiedName",
            "isBankAccount",
            "name",
            "nominalCode",
            "status",
            "supplementalData",
            "type",
            "validDatatypeLinks",
        ]
        nullable_fields = [
            "currentBalance",
            "description",
            "fullyQualifiedCategory",
            "fullyQualifiedName",
            "name",
            "nominalCode",
            "validDatatypeLinks",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
