"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .accounttransactionlinerecordref import (
    AccountTransactionLineRecordRef,
    AccountTransactionLineRecordRefTypedDict,
)
from codat_accounting.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from codat_accounting.utils import serialize_decimal, validate_decimal
from decimal import Decimal
import pydantic
from pydantic import model_serializer
from pydantic.functional_serializers import PlainSerializer
from pydantic.functional_validators import BeforeValidator
from typing import Optional, TypedDict
from typing_extensions import Annotated, NotRequired


class AccountTransactionLineTypedDict(TypedDict):
    amount: NotRequired[Decimal]
    r"""Amount in the bill payment currency."""
    description: NotRequired[Nullable[str]]
    r"""Description of the account transaction."""
    record_ref: NotRequired[AccountTransactionLineRecordRefTypedDict]
    r"""Links an account transaction line to the underlying record that created it."""


class AccountTransactionLine(BaseModel):
    amount: Annotated[
        Optional[Decimal],
        BeforeValidator(validate_decimal),
        PlainSerializer(serialize_decimal(False)),
    ] = None
    r"""Amount in the bill payment currency."""

    description: OptionalNullable[str] = UNSET
    r"""Description of the account transaction."""

    record_ref: Annotated[
        Optional[AccountTransactionLineRecordRef], pydantic.Field(alias="recordRef")
    ] = None
    r"""Links an account transaction line to the underlying record that created it."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["amount", "description", "recordRef"]
        nullable_fields = ["description"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
