"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .banktransactiontype import BankTransactionType
from .links import Links, LinksTypedDict
from codat_accounting.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from codat_accounting.utils import serialize_decimal, validate_decimal
from decimal import Decimal
import pydantic
from pydantic import model_serializer
from pydantic.functional_serializers import PlainSerializer
from pydantic.functional_validators import BeforeValidator
from typing import List, Optional, TypedDict
from typing_extensions import Annotated, NotRequired


class AccountingBankAccountTransactionTypedDict(TypedDict):
    r"""> **Accessing Bank Accounts through Banking API**
    >
    > This datatype was originally used for accessing bank account data both in accounting integrations and open banking aggregators.
    >
    > To view bank account data through the Banking API, please refer to the new datatype [here](https://docs.codat.io/banking-api#/operations/list-all-banking-transactions)

    > View the coverage for bank transactions in the <a className=\"external\" href=\"https://knowledge.codat.io/supported-features/accounting?view=tab-by-data-type&dataType=bankTransactions\" target=\"_blank\">Data coverage explorer</a>.

    ## Overview

    Transactional banking data for a specific company and account.

    Bank transactions include the:
    * Amount of the transaction.
    * Current account balance.
    * Transaction type, for example, credit, debit, or transfer.
    """

    account_id: NotRequired[Nullable[str]]
    r"""Unique identifier to the `accountId` the bank transactions originates from."""
    amount: NotRequired[Decimal]
    r"""The amount transacted in the bank transaction."""
    balance: NotRequired[Decimal]
    r"""The remaining balance in the account with ID `accountId`."""
    cleared_on_date: NotRequired[str]
    r"""In Codat's data model, dates and times are represented using the <a class=\"external\" href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601 standard</a>. Date and time fields are formatted as strings; for example:

    ```
    2020-10-08T22:40:50Z
    2021-01-01T00:00:00
    ```



    When syncing data that contains `DateTime` fields from Codat, make sure you support the following cases when reading time information:

    - Coordinated Universal Time (UTC): `2021-11-15T06:00:00Z`
    - Unqualified local time: `2021-11-15T01:00:00`
    - UTC time offsets: `2021-11-15T01:00:00-05:00`

    > Time zones
    >
    > Not all dates from Codat will contain information about time zones.
    > Where it is not available from the underlying platform, Codat will return these as times local to the business whose data has been synced.
    """
    description: NotRequired[Nullable[str]]
    r"""Description of the bank transaction."""
    id: NotRequired[str]
    r"""Identifier for the bank transaction, unique to the company in the accounting software."""
    modified_date: NotRequired[str]
    reconciled: NotRequired[bool]
    r"""`True` if the bank transaction has been [reconciled](https://www.xero.com/uk/guides/what-is-bank-reconciliation/) in the accounting software."""
    source_modified_date: NotRequired[str]
    transaction_type: NotRequired[BankTransactionType]
    r"""Type of transaction for the bank statement line."""


class AccountingBankAccountTransaction(BaseModel):
    r"""> **Accessing Bank Accounts through Banking API**
    >
    > This datatype was originally used for accessing bank account data both in accounting integrations and open banking aggregators.
    >
    > To view bank account data through the Banking API, please refer to the new datatype [here](https://docs.codat.io/banking-api#/operations/list-all-banking-transactions)

    > View the coverage for bank transactions in the <a className=\"external\" href=\"https://knowledge.codat.io/supported-features/accounting?view=tab-by-data-type&dataType=bankTransactions\" target=\"_blank\">Data coverage explorer</a>.

    ## Overview

    Transactional banking data for a specific company and account.

    Bank transactions include the:
    * Amount of the transaction.
    * Current account balance.
    * Transaction type, for example, credit, debit, or transfer.
    """

    account_id: Annotated[OptionalNullable[str], pydantic.Field(alias="accountId")] = (
        UNSET
    )
    r"""Unique identifier to the `accountId` the bank transactions originates from."""

    amount: Annotated[
        Optional[Decimal],
        BeforeValidator(validate_decimal),
        PlainSerializer(serialize_decimal(False)),
    ] = None
    r"""The amount transacted in the bank transaction."""

    balance: Annotated[
        Optional[Decimal],
        BeforeValidator(validate_decimal),
        PlainSerializer(serialize_decimal(False)),
    ] = None
    r"""The remaining balance in the account with ID `accountId`."""

    cleared_on_date: Annotated[Optional[str], pydantic.Field(alias="clearedOnDate")] = (
        None
    )
    r"""In Codat's data model, dates and times are represented using the <a class=\"external\" href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601 standard</a>. Date and time fields are formatted as strings; for example:

    ```
    2020-10-08T22:40:50Z
    2021-01-01T00:00:00
    ```



    When syncing data that contains `DateTime` fields from Codat, make sure you support the following cases when reading time information:

    - Coordinated Universal Time (UTC): `2021-11-15T06:00:00Z`
    - Unqualified local time: `2021-11-15T01:00:00`
    - UTC time offsets: `2021-11-15T01:00:00-05:00`

    > Time zones
    >
    > Not all dates from Codat will contain information about time zones.
    > Where it is not available from the underlying platform, Codat will return these as times local to the business whose data has been synced.
    """

    description: OptionalNullable[str] = UNSET
    r"""Description of the bank transaction."""

    id: Optional[str] = None
    r"""Identifier for the bank transaction, unique to the company in the accounting software."""

    modified_date: Annotated[Optional[str], pydantic.Field(alias="modifiedDate")] = None

    reconciled: Optional[bool] = None
    r"""`True` if the bank transaction has been [reconciled](https://www.xero.com/uk/guides/what-is-bank-reconciliation/) in the accounting software."""

    source_modified_date: Annotated[
        Optional[str], pydantic.Field(alias="sourceModifiedDate")
    ] = None

    transaction_type: Annotated[
        Optional[BankTransactionType], pydantic.Field(alias="transactionType")
    ] = None
    r"""Type of transaction for the bank statement line."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "accountId",
            "amount",
            "balance",
            "clearedOnDate",
            "description",
            "id",
            "modifiedDate",
            "reconciled",
            "sourceModifiedDate",
            "transactionType",
        ]
        nullable_fields = ["accountId", "description"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class BankTransactionsTypedDict(TypedDict):
    links: LinksTypedDict
    page_number: int
    r"""Current page number."""
    page_size: int
    r"""Number of items to return in results array."""
    total_results: int
    r"""Total number of items."""
    results: NotRequired[List[AccountingBankAccountTransactionTypedDict]]


class BankTransactions(BaseModel):
    links: Annotated[Links, pydantic.Field(alias="_links")]

    page_number: Annotated[int, pydantic.Field(alias="pageNumber")]
    r"""Current page number."""

    page_size: Annotated[int, pydantic.Field(alias="pageSize")]
    r"""Number of items to return in results array."""

    total_results: Annotated[int, pydantic.Field(alias="totalResults")]
    r"""Total number of items."""

    results: Optional[List[AccountingBankAccountTransaction]] = None
