"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .accountingaddresstype import AccountingAddressType
from .phonenumbertype import PhoneNumberType
from .supplementaldata import SupplementalData, SupplementalDataTypedDict
from codat_accounting.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from enum import Enum
import pydantic
from pydantic import model_serializer
from typing import Dict, List, Optional, TypedDict
from typing_extensions import Annotated, NotRequired


class AccountingAddressTypedDict(TypedDict):
    type: AccountingAddressType
    r"""The type of the address"""
    city: NotRequired[Nullable[str]]
    r"""City of the customer address."""
    country: NotRequired[Nullable[str]]
    r"""Country of the customer address."""
    line1: NotRequired[Nullable[str]]
    r"""Line 1 of the customer address."""
    line2: NotRequired[Nullable[str]]
    r"""Line 2 of the customer address."""
    postal_code: NotRequired[Nullable[str]]
    r"""Postal code or zip code."""
    region: NotRequired[Nullable[str]]
    r"""Region of the customer address."""


class AccountingAddress(BaseModel):
    type: AccountingAddressType
    r"""The type of the address"""

    city: OptionalNullable[str] = UNSET
    r"""City of the customer address."""

    country: OptionalNullable[str] = UNSET
    r"""Country of the customer address."""

    line1: OptionalNullable[str] = UNSET
    r"""Line 1 of the customer address."""

    line2: OptionalNullable[str] = UNSET
    r"""Line 2 of the customer address."""

    postal_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCode")
    ] = UNSET
    r"""Postal code or zip code."""

    region: OptionalNullable[str] = UNSET
    r"""Region of the customer address."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["city", "country", "line1", "line2", "postalCode", "region"]
        nullable_fields = ["city", "country", "line1", "line2", "postalCode", "region"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PhoneTypedDict(TypedDict):
    type: PhoneNumberType
    r"""The type of phone number"""
    number: NotRequired[Nullable[str]]
    r"""A phone number."""


class Phone(BaseModel):
    type: PhoneNumberType
    r"""The type of phone number"""

    number: OptionalNullable[str] = UNSET
    r"""A phone number."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["number"]
        nullable_fields = ["number"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class Type(str, Enum):
    r"""The type of the weblink."""

    WEBSITE = "Website"
    SOCIAL = "Social"
    UNKNOWN = "Unknown"


class WeblinkTypedDict(TypedDict):
    r"""Weblink associated with the company."""

    type: NotRequired[Type]
    r"""The type of the weblink."""
    url: NotRequired[str]
    r"""The full URL for the weblink."""


class Weblink(BaseModel):
    r"""Weblink associated with the company."""

    type: Optional[Type] = None
    r"""The type of the weblink."""

    url: Optional[str] = None
    r"""The full URL for the weblink."""


class CompanyDatasetTypedDict(TypedDict):
    r"""> View the coverage for company profile in the <a className=\"external\" href=\"https://knowledge.codat.io/supported-features/accounting?view=tab-by-data-type&dataType=cashFlowStatement\" target=\"_blank\">Data coverage explorer</a>.

    Company info provides standard details about a linked company such as their address, phone number, and company registration.

    > **Company information or companies?**
    >
    > Company profile is standard information that is held in the accounting software about a company. `Companies` is an endpoint that lists businesses in the Codat system that have linked and shared their data sources.
    """

    accounting_platform_ref: NotRequired[Nullable[str]]
    r"""Identifier or reference for the company in the accounting software."""
    addresses: NotRequired[Nullable[List[AccountingAddressTypedDict]]]
    r"""An array of Addresses."""
    base_currency: NotRequired[Nullable[str]]
    r"""Currency set in the accounting software of the linked company. Used by the currency rate."""
    company_legal_name: NotRequired[Nullable[str]]
    r"""Registered legal name of the linked company."""
    company_name: NotRequired[Nullable[str]]
    r"""Name of the linked company."""
    created_date: NotRequired[str]
    r"""In Codat's data model, dates and times are represented using the <a class=\"external\" href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601 standard</a>. Date and time fields are formatted as strings; for example:

    ```
    2020-10-08T22:40:50Z
    2021-01-01T00:00:00
    ```



    When syncing data that contains `DateTime` fields from Codat, make sure you support the following cases when reading time information:

    - Coordinated Universal Time (UTC): `2021-11-15T06:00:00Z`
    - Unqualified local time: `2021-11-15T01:00:00`
    - UTC time offsets: `2021-11-15T01:00:00-05:00`

    > Time zones
    >
    > Not all dates from Codat will contain information about time zones.
    > Where it is not available from the underlying platform, Codat will return these as times local to the business whose data has been synced.
    """
    financial_year_start_date: NotRequired[str]
    r"""In Codat's data model, dates and times are represented using the <a class=\"external\" href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601 standard</a>. Date and time fields are formatted as strings; for example:

    ```
    2020-10-08T22:40:50Z
    2021-01-01T00:00:00
    ```



    When syncing data that contains `DateTime` fields from Codat, make sure you support the following cases when reading time information:

    - Coordinated Universal Time (UTC): `2021-11-15T06:00:00Z`
    - Unqualified local time: `2021-11-15T01:00:00`
    - UTC time offsets: `2021-11-15T01:00:00-05:00`

    > Time zones
    >
    > Not all dates from Codat will contain information about time zones.
    > Where it is not available from the underlying platform, Codat will return these as times local to the business whose data has been synced.
    """
    ledger_lock_date: NotRequired[str]
    r"""In Codat's data model, dates and times are represented using the <a class=\"external\" href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601 standard</a>. Date and time fields are formatted as strings; for example:

    ```
    2020-10-08T22:40:50Z
    2021-01-01T00:00:00
    ```



    When syncing data that contains `DateTime` fields from Codat, make sure you support the following cases when reading time information:

    - Coordinated Universal Time (UTC): `2021-11-15T06:00:00Z`
    - Unqualified local time: `2021-11-15T01:00:00`
    - UTC time offsets: `2021-11-15T01:00:00-05:00`

    > Time zones
    >
    > Not all dates from Codat will contain information about time zones.
    > Where it is not available from the underlying platform, Codat will return these as times local to the business whose data has been synced.
    """
    phone_numbers: NotRequired[Nullable[List[PhoneTypedDict]]]
    r"""An array of phone numbers."""
    registration_number: NotRequired[Nullable[str]]
    r"""Registration number given to the linked company by the companies authority in the country of origin. In the UK this is Companies House."""
    source_urls: NotRequired[Nullable[Dict[str, str]]]
    r"""URL addresses for the accounting source.

    For example, for Xero integrations two URLs are returned. These have many potential use cases, such as [deep linking](https://developer.xero.com/documentation/api-guides/deep-link-xero).
    """
    supplemental_data: NotRequired[SupplementalDataTypedDict]
    r"""Supplemental data is additional data you can include in our standard data types.

    It is referenced as a configured dynamic key value pair that is unique to the accounting software. [Learn more](https://docs.codat.io/using-the-api/supplemental-data/overview) about supplemental data.
    """
    tax_number: NotRequired[Nullable[str]]
    r"""Company tax number."""
    web_links: NotRequired[Nullable[List[WeblinkTypedDict]]]
    r"""An array of weblinks."""


class CompanyDataset(BaseModel):
    r"""> View the coverage for company profile in the <a className=\"external\" href=\"https://knowledge.codat.io/supported-features/accounting?view=tab-by-data-type&dataType=cashFlowStatement\" target=\"_blank\">Data coverage explorer</a>.

    Company info provides standard details about a linked company such as their address, phone number, and company registration.

    > **Company information or companies?**
    >
    > Company profile is standard information that is held in the accounting software about a company. `Companies` is an endpoint that lists businesses in the Codat system that have linked and shared their data sources.
    """

    accounting_platform_ref: Annotated[
        OptionalNullable[str], pydantic.Field(alias="accountingPlatformRef")
    ] = UNSET
    r"""Identifier or reference for the company in the accounting software."""

    addresses: OptionalNullable[List[AccountingAddress]] = UNSET
    r"""An array of Addresses."""

    base_currency: Annotated[
        OptionalNullable[str], pydantic.Field(alias="baseCurrency")
    ] = UNSET
    r"""Currency set in the accounting software of the linked company. Used by the currency rate."""

    company_legal_name: Annotated[
        OptionalNullable[str], pydantic.Field(alias="companyLegalName")
    ] = UNSET
    r"""Registered legal name of the linked company."""

    company_name: Annotated[
        OptionalNullable[str], pydantic.Field(alias="companyName")
    ] = UNSET
    r"""Name of the linked company."""

    created_date: Annotated[Optional[str], pydantic.Field(alias="createdDate")] = None
    r"""In Codat's data model, dates and times are represented using the <a class=\"external\" href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601 standard</a>. Date and time fields are formatted as strings; for example:

    ```
    2020-10-08T22:40:50Z
    2021-01-01T00:00:00
    ```



    When syncing data that contains `DateTime` fields from Codat, make sure you support the following cases when reading time information:

    - Coordinated Universal Time (UTC): `2021-11-15T06:00:00Z`
    - Unqualified local time: `2021-11-15T01:00:00`
    - UTC time offsets: `2021-11-15T01:00:00-05:00`

    > Time zones
    >
    > Not all dates from Codat will contain information about time zones.
    > Where it is not available from the underlying platform, Codat will return these as times local to the business whose data has been synced.
    """

    financial_year_start_date: Annotated[
        Optional[str], pydantic.Field(alias="financialYearStartDate")
    ] = None
    r"""In Codat's data model, dates and times are represented using the <a class=\"external\" href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601 standard</a>. Date and time fields are formatted as strings; for example:

    ```
    2020-10-08T22:40:50Z
    2021-01-01T00:00:00
    ```



    When syncing data that contains `DateTime` fields from Codat, make sure you support the following cases when reading time information:

    - Coordinated Universal Time (UTC): `2021-11-15T06:00:00Z`
    - Unqualified local time: `2021-11-15T01:00:00`
    - UTC time offsets: `2021-11-15T01:00:00-05:00`

    > Time zones
    >
    > Not all dates from Codat will contain information about time zones.
    > Where it is not available from the underlying platform, Codat will return these as times local to the business whose data has been synced.
    """

    ledger_lock_date: Annotated[
        Optional[str], pydantic.Field(alias="ledgerLockDate")
    ] = None
    r"""In Codat's data model, dates and times are represented using the <a class=\"external\" href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601 standard</a>. Date and time fields are formatted as strings; for example:

    ```
    2020-10-08T22:40:50Z
    2021-01-01T00:00:00
    ```



    When syncing data that contains `DateTime` fields from Codat, make sure you support the following cases when reading time information:

    - Coordinated Universal Time (UTC): `2021-11-15T06:00:00Z`
    - Unqualified local time: `2021-11-15T01:00:00`
    - UTC time offsets: `2021-11-15T01:00:00-05:00`

    > Time zones
    >
    > Not all dates from Codat will contain information about time zones.
    > Where it is not available from the underlying platform, Codat will return these as times local to the business whose data has been synced.
    """

    phone_numbers: Annotated[
        OptionalNullable[List[Phone]], pydantic.Field(alias="phoneNumbers")
    ] = UNSET
    r"""An array of phone numbers."""

    registration_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="registrationNumber")
    ] = UNSET
    r"""Registration number given to the linked company by the companies authority in the country of origin. In the UK this is Companies House."""

    source_urls: Annotated[
        OptionalNullable[Dict[str, str]], pydantic.Field(alias="sourceUrls")
    ] = UNSET
    r"""URL addresses for the accounting source.

    For example, for Xero integrations two URLs are returned. These have many potential use cases, such as [deep linking](https://developer.xero.com/documentation/api-guides/deep-link-xero).
    """

    supplemental_data: Annotated[
        Optional[SupplementalData], pydantic.Field(alias="supplementalData")
    ] = None
    r"""Supplemental data is additional data you can include in our standard data types.

    It is referenced as a configured dynamic key value pair that is unique to the accounting software. [Learn more](https://docs.codat.io/using-the-api/supplemental-data/overview) about supplemental data.
    """

    tax_number: Annotated[OptionalNullable[str], pydantic.Field(alias="taxNumber")] = (
        UNSET
    )
    r"""Company tax number."""

    web_links: Annotated[
        OptionalNullable[List[Weblink]], pydantic.Field(alias="webLinks")
    ] = UNSET
    r"""An array of weblinks."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "accountingPlatformRef",
            "addresses",
            "baseCurrency",
            "companyLegalName",
            "companyName",
            "createdDate",
            "financialYearStartDate",
            "ledgerLockDate",
            "phoneNumbers",
            "registrationNumber",
            "sourceUrls",
            "supplementalData",
            "taxNumber",
            "webLinks",
        ]
        nullable_fields = [
            "accountingPlatformRef",
            "addresses",
            "baseCurrency",
            "companyLegalName",
            "companyName",
            "phoneNumbers",
            "registrationNumber",
            "sourceUrls",
            "taxNumber",
            "webLinks",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
