"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .accountingcustomerref import AccountingCustomerRef, AccountingCustomerRefTypedDict
from .accountref import AccountRef, AccountRefTypedDict
from .billedtotype1 import BilledToType1
from .invoiceto import InvoiceTo, InvoiceToTypedDict
from .itemref import ItemRef, ItemRefTypedDict
from .projectref import ProjectRef, ProjectRefTypedDict
from .taxrateref import TaxRateRef, TaxRateRefTypedDict
from .trackingcategoryref import TrackingCategoryRef, TrackingCategoryRefTypedDict
from codat_accounting.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from codat_accounting.utils import serialize_decimal, validate_decimal
from decimal import Decimal
import pydantic
from pydantic import model_serializer
from pydantic.functional_serializers import PlainSerializer
from pydantic.functional_validators import BeforeValidator
from typing import List, Optional, TypedDict
from typing_extensions import Annotated, NotRequired


class CreditNoteLineItemTrackingTypedDict(TypedDict):
    r"""Categories, and a project and customer, against which the item is tracked."""

    category_refs: List[TrackingCategoryRefTypedDict]
    is_billed_to: BilledToType1
    r"""Defines if the bill or bill credit note is billed/rebilled to a project."""
    is_rebilled_to: BilledToType1
    r"""Defines if the bill or bill credit note is billed/rebilled to a project."""
    customer_ref: NotRequired[AccountingCustomerRefTypedDict]
    project_ref: NotRequired[ProjectRefTypedDict]
    record_ref: NotRequired[InvoiceToTypedDict]
    r"""Links the current record to the underlying record or data type that created it.

    For example, if a journal entry is generated based on an invoice, this property allows you to connect the journal entry to the underlying invoice in our data model.
    """


class CreditNoteLineItemTracking(BaseModel):
    r"""Categories, and a project and customer, against which the item is tracked."""

    category_refs: Annotated[
        List[TrackingCategoryRef], pydantic.Field(alias="categoryRefs")
    ]

    is_billed_to: Annotated[BilledToType1, pydantic.Field(alias="isBilledTo")]
    r"""Defines if the bill or bill credit note is billed/rebilled to a project."""

    is_rebilled_to: Annotated[BilledToType1, pydantic.Field(alias="isRebilledTo")]
    r"""Defines if the bill or bill credit note is billed/rebilled to a project."""

    customer_ref: Annotated[
        Optional[AccountingCustomerRef], pydantic.Field(alias="customerRef")
    ] = None

    project_ref: Annotated[Optional[ProjectRef], pydantic.Field(alias="projectRef")] = (
        None
    )

    record_ref: Annotated[Optional[InvoiceTo], pydantic.Field(alias="recordRef")] = None
    r"""Links the current record to the underlying record or data type that created it.

    For example, if a journal entry is generated based on an invoice, this property allows you to connect the journal entry to the underlying invoice in our data model.
    """


class CreditNoteLineItemTypedDict(TypedDict):
    quantity: Decimal
    r"""Number of units of the goods or service for which credit has been issued."""
    unit_amount: Decimal
    r"""Unit price of the goods or service."""
    account_ref: NotRequired[AccountRefTypedDict]
    r"""Data types that reference an account, for example bill and invoice line items, use an accountRef that includes the ID and name of the linked account."""
    description: NotRequired[Nullable[str]]
    r"""Friendly name of each line item. For example, the goods or service for which credit has been issued."""
    discount_amount: NotRequired[Nullable[Decimal]]
    r"""Value of any discounts applied."""
    discount_percentage: NotRequired[Nullable[Decimal]]
    r"""Percentage rate of any discount applied to the line item."""
    is_direct_income: NotRequired[bool]
    r"""The credit note is a direct income if `True`."""
    item_ref: NotRequired[ItemRefTypedDict]
    sub_total: NotRequired[Nullable[Decimal]]
    r"""Amount of credit associated with the line item, including discounts but excluding tax."""
    tax_amount: NotRequired[Nullable[Decimal]]
    r"""Amount of tax associated with the line item."""
    tax_rate_ref: NotRequired[TaxRateRefTypedDict]
    r"""Data types that reference a tax rate, for example invoice and bill line items, use a taxRateRef that includes the ID and name of the linked tax rate.

    Found on:

    - Bill line items
    - Bill Credit Note line items
    - Credit Note line items
    - Direct incomes line items
    - Invoice line items
    - Items
    """
    total_amount: NotRequired[Nullable[Decimal]]
    r"""Total amount of the line item, including discounts and tax."""
    tracking: NotRequired[CreditNoteLineItemTrackingTypedDict]
    r"""Categories, and a project and customer, against which the item is tracked."""
    tracking_category_refs: NotRequired[Nullable[List[TrackingCategoryRefTypedDict]]]
    r"""Reference to the tracking categories to which the line item is linked."""


class CreditNoteLineItem(BaseModel):
    quantity: Annotated[
        Decimal,
        BeforeValidator(validate_decimal),
        PlainSerializer(serialize_decimal(False)),
    ]
    r"""Number of units of the goods or service for which credit has been issued."""

    unit_amount: Annotated[
        Annotated[
            Decimal,
            BeforeValidator(validate_decimal),
            PlainSerializer(serialize_decimal(False)),
        ],
        pydantic.Field(alias="unitAmount"),
    ]
    r"""Unit price of the goods or service."""

    account_ref: Annotated[Optional[AccountRef], pydantic.Field(alias="accountRef")] = (
        None
    )
    r"""Data types that reference an account, for example bill and invoice line items, use an accountRef that includes the ID and name of the linked account."""

    description: OptionalNullable[str] = UNSET
    r"""Friendly name of each line item. For example, the goods or service for which credit has been issued."""

    discount_amount: Annotated[
        Annotated[
            OptionalNullable[Decimal],
            BeforeValidator(validate_decimal),
            PlainSerializer(serialize_decimal(False)),
        ],
        pydantic.Field(alias="discountAmount"),
    ] = UNSET
    r"""Value of any discounts applied."""

    discount_percentage: Annotated[
        Annotated[
            OptionalNullable[Decimal],
            BeforeValidator(validate_decimal),
            PlainSerializer(serialize_decimal(False)),
        ],
        pydantic.Field(alias="discountPercentage"),
    ] = UNSET
    r"""Percentage rate of any discount applied to the line item."""

    is_direct_income: Annotated[
        Optional[bool], pydantic.Field(alias="isDirectIncome")
    ] = None
    r"""The credit note is a direct income if `True`."""

    item_ref: Annotated[Optional[ItemRef], pydantic.Field(alias="itemRef")] = None

    sub_total: Annotated[
        Annotated[
            OptionalNullable[Decimal],
            BeforeValidator(validate_decimal),
            PlainSerializer(serialize_decimal(False)),
        ],
        pydantic.Field(alias="subTotal"),
    ] = UNSET
    r"""Amount of credit associated with the line item, including discounts but excluding tax."""

    tax_amount: Annotated[
        Annotated[
            OptionalNullable[Decimal],
            BeforeValidator(validate_decimal),
            PlainSerializer(serialize_decimal(False)),
        ],
        pydantic.Field(alias="taxAmount"),
    ] = UNSET
    r"""Amount of tax associated with the line item."""

    tax_rate_ref: Annotated[
        Optional[TaxRateRef], pydantic.Field(alias="taxRateRef")
    ] = None
    r"""Data types that reference a tax rate, for example invoice and bill line items, use a taxRateRef that includes the ID and name of the linked tax rate.

    Found on:

    - Bill line items
    - Bill Credit Note line items
    - Credit Note line items
    - Direct incomes line items
    - Invoice line items
    - Items
    """

    total_amount: Annotated[
        Annotated[
            OptionalNullable[Decimal],
            BeforeValidator(validate_decimal),
            PlainSerializer(serialize_decimal(False)),
        ],
        pydantic.Field(alias="totalAmount"),
    ] = UNSET
    r"""Total amount of the line item, including discounts and tax."""

    tracking: Optional[CreditNoteLineItemTracking] = None
    r"""Categories, and a project and customer, against which the item is tracked."""

    tracking_category_refs: Annotated[
        OptionalNullable[List[TrackingCategoryRef]],
        pydantic.Field(
            deprecated="warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible.",
            alias="trackingCategoryRefs",
        ),
    ] = UNSET
    r"""Reference to the tracking categories to which the line item is linked."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "accountRef",
            "description",
            "discountAmount",
            "discountPercentage",
            "isDirectIncome",
            "itemRef",
            "subTotal",
            "taxAmount",
            "taxRateRef",
            "totalAmount",
            "tracking",
            "trackingCategoryRefs",
        ]
        nullable_fields = [
            "description",
            "discountAmount",
            "discountPercentage",
            "subTotal",
            "taxAmount",
            "totalAmount",
            "trackingCategoryRefs",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
