"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .datasetstatus import DatasetStatus
from .datatype import DataType
from codat_accounting.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
import pydantic
from pydantic import model_serializer
from typing import Optional, TypedDict
from typing_extensions import Annotated, NotRequired


class DatasetTypedDict(TypedDict):
    company_id: str
    r"""Unique identifier for your SMB in Codat."""
    connection_id: str
    r"""Unique identifier for a company's data connection."""
    id: str
    r"""Identifier for the dataset."""
    is_completed: bool
    r"""`True` if the dataset completed successfully."""
    is_errored: bool
    r"""`True` if the dataset entered an error state."""
    progress: int
    r"""An integer signifying the progress of the dataset."""
    requested: str
    r"""In Codat's data model, dates and times are represented using the <a class=\"external\" href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601 standard</a>. Date and time fields are formatted as strings; for example:

    ```
    2020-10-08T22:40:50Z
    2021-01-01T00:00:00
    ```



    When syncing data that contains `DateTime` fields from Codat, make sure you support the following cases when reading time information:

    - Coordinated Universal Time (UTC): `2021-11-15T06:00:00Z`
    - Unqualified local time: `2021-11-15T01:00:00`
    - UTC time offsets: `2021-11-15T01:00:00-05:00`

    > Time zones
    >
    > Not all dates from Codat will contain information about time zones.
    > Where it is not available from the underlying platform, Codat will return these as times local to the business whose data has been synced.
    """
    status: DatasetStatus
    r"""The current status of the dataset."""
    completed: NotRequired[str]
    r"""In Codat's data model, dates and times are represented using the <a class=\"external\" href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601 standard</a>. Date and time fields are formatted as strings; for example:

    ```
    2020-10-08T22:40:50Z
    2021-01-01T00:00:00
    ```



    When syncing data that contains `DateTime` fields from Codat, make sure you support the following cases when reading time information:

    - Coordinated Universal Time (UTC): `2021-11-15T06:00:00Z`
    - Unqualified local time: `2021-11-15T01:00:00`
    - UTC time offsets: `2021-11-15T01:00:00-05:00`

    > Time zones
    >
    > Not all dates from Codat will contain information about time zones.
    > Where it is not available from the underlying platform, Codat will return these as times local to the business whose data has been synced.
    """
    data_type: NotRequired[DataType]
    r"""Available data types"""
    dataset_logs_url: NotRequired[Nullable[str]]
    r"""URI to the dataset's logs."""
    error_message: NotRequired[Nullable[str]]
    r"""A brief message about the error."""
    validation_information_url: NotRequired[Nullable[str]]
    r"""URI to the dataset's validation information."""


class Dataset(BaseModel):
    company_id: Annotated[str, pydantic.Field(alias="companyId")]
    r"""Unique identifier for your SMB in Codat."""

    connection_id: Annotated[str, pydantic.Field(alias="connectionId")]
    r"""Unique identifier for a company's data connection."""

    id: str
    r"""Identifier for the dataset."""

    is_completed: Annotated[bool, pydantic.Field(alias="isCompleted")]
    r"""`True` if the dataset completed successfully."""

    is_errored: Annotated[bool, pydantic.Field(alias="isErrored")]
    r"""`True` if the dataset entered an error state."""

    progress: int
    r"""An integer signifying the progress of the dataset."""

    requested: str
    r"""In Codat's data model, dates and times are represented using the <a class=\"external\" href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601 standard</a>. Date and time fields are formatted as strings; for example:

    ```
    2020-10-08T22:40:50Z
    2021-01-01T00:00:00
    ```



    When syncing data that contains `DateTime` fields from Codat, make sure you support the following cases when reading time information:

    - Coordinated Universal Time (UTC): `2021-11-15T06:00:00Z`
    - Unqualified local time: `2021-11-15T01:00:00`
    - UTC time offsets: `2021-11-15T01:00:00-05:00`

    > Time zones
    >
    > Not all dates from Codat will contain information about time zones.
    > Where it is not available from the underlying platform, Codat will return these as times local to the business whose data has been synced.
    """

    status: DatasetStatus
    r"""The current status of the dataset."""

    completed: Optional[str] = None
    r"""In Codat's data model, dates and times are represented using the <a class=\"external\" href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601 standard</a>. Date and time fields are formatted as strings; for example:

    ```
    2020-10-08T22:40:50Z
    2021-01-01T00:00:00
    ```



    When syncing data that contains `DateTime` fields from Codat, make sure you support the following cases when reading time information:

    - Coordinated Universal Time (UTC): `2021-11-15T06:00:00Z`
    - Unqualified local time: `2021-11-15T01:00:00`
    - UTC time offsets: `2021-11-15T01:00:00-05:00`

    > Time zones
    >
    > Not all dates from Codat will contain information about time zones.
    > Where it is not available from the underlying platform, Codat will return these as times local to the business whose data has been synced.
    """

    data_type: Annotated[Optional[DataType], pydantic.Field(alias="dataType")] = None
    r"""Available data types"""

    dataset_logs_url: Annotated[
        OptionalNullable[str], pydantic.Field(alias="datasetLogsUrl")
    ] = UNSET
    r"""URI to the dataset's logs."""

    error_message: Annotated[
        OptionalNullable[str], pydantic.Field(alias="errorMessage")
    ] = UNSET
    r"""A brief message about the error."""

    validation_information_url: Annotated[
        OptionalNullable[str], pydantic.Field(alias="validationInformationUrl")
    ] = UNSET
    r"""URI to the dataset's validation information."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "completed",
            "dataType",
            "datasetLogsUrl",
            "errorMessage",
            "validationInformationUrl",
        ]
        nullable_fields = ["datasetLogsUrl", "errorMessage", "validationInformationUrl"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
