"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .accountref import AccountRef, AccountRefTypedDict
from .itemref import ItemRef, ItemRefTypedDict
from .taxrateref import TaxRateRef, TaxRateRefTypedDict
from .tracking import Tracking, TrackingTypedDict
from .trackingcategoryref import TrackingCategoryRef, TrackingCategoryRefTypedDict
from codat_accounting.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from codat_accounting.utils import serialize_decimal, validate_decimal
from decimal import Decimal
import pydantic
from pydantic import model_serializer
from pydantic.functional_serializers import PlainSerializer
from pydantic.functional_validators import BeforeValidator
from typing import List, Optional, TypedDict
from typing_extensions import Annotated, NotRequired


class DirectCostLineItemTypedDict(TypedDict):
    quantity: Decimal
    r"""Number of units of goods or services received.

    Note: If the platform does not provide this information, the quantity will be mapped as 1.
    """
    unit_amount: Decimal
    r"""Price of each unit of goods or services.
    Note: If the platform does not provide this information, the unit amount will be mapped to the total amount.
    """
    account_ref: NotRequired[AccountRefTypedDict]
    r"""Data types that reference an account, for example bill and invoice line items, use an accountRef that includes the ID and name of the linked account."""
    description: NotRequired[Nullable[str]]
    r"""Friendly name of the goods or services."""
    discount_amount: NotRequired[Nullable[Decimal]]
    r"""Discount amount for the line before tax."""
    discount_percentage: NotRequired[Nullable[Decimal]]
    r"""Discount percentage for the line before tax."""
    item_ref: NotRequired[ItemRefTypedDict]
    sub_total: NotRequired[Nullable[Decimal]]
    r"""Amount of the line, inclusive of discounts but exclusive of tax."""
    tax_amount: NotRequired[Nullable[Decimal]]
    r"""Amount of tax for the line."""
    tax_rate_ref: NotRequired[TaxRateRefTypedDict]
    r"""Data types that reference a tax rate, for example invoice and bill line items, use a taxRateRef that includes the ID and name of the linked tax rate.

    Found on:

    - Bill line items
    - Bill Credit Note line items
    - Credit Note line items
    - Direct incomes line items
    - Invoice line items
    - Items
    """
    total_amount: NotRequired[Nullable[Decimal]]
    r"""Total amount of the line, including tax."""
    tracking: NotRequired[TrackingTypedDict]
    tracking_category_refs: NotRequired[Nullable[List[TrackingCategoryRefTypedDict]]]
    r"""Collection of categories against which this direct cost is tracked."""


class DirectCostLineItem(BaseModel):
    quantity: Annotated[
        Decimal,
        BeforeValidator(validate_decimal),
        PlainSerializer(serialize_decimal(False)),
    ]
    r"""Number of units of goods or services received.

    Note: If the platform does not provide this information, the quantity will be mapped as 1.
    """

    unit_amount: Annotated[
        Annotated[
            Decimal,
            BeforeValidator(validate_decimal),
            PlainSerializer(serialize_decimal(False)),
        ],
        pydantic.Field(alias="unitAmount"),
    ]
    r"""Price of each unit of goods or services.
    Note: If the platform does not provide this information, the unit amount will be mapped to the total amount.
    """

    account_ref: Annotated[Optional[AccountRef], pydantic.Field(alias="accountRef")] = (
        None
    )
    r"""Data types that reference an account, for example bill and invoice line items, use an accountRef that includes the ID and name of the linked account."""

    description: OptionalNullable[str] = UNSET
    r"""Friendly name of the goods or services."""

    discount_amount: Annotated[
        Annotated[
            OptionalNullable[Decimal],
            BeforeValidator(validate_decimal),
            PlainSerializer(serialize_decimal(False)),
        ],
        pydantic.Field(alias="discountAmount"),
    ] = UNSET
    r"""Discount amount for the line before tax."""

    discount_percentage: Annotated[
        Annotated[
            OptionalNullable[Decimal],
            BeforeValidator(validate_decimal),
            PlainSerializer(serialize_decimal(False)),
        ],
        pydantic.Field(alias="discountPercentage"),
    ] = UNSET
    r"""Discount percentage for the line before tax."""

    item_ref: Annotated[Optional[ItemRef], pydantic.Field(alias="itemRef")] = None

    sub_total: Annotated[
        Annotated[
            OptionalNullable[Decimal],
            BeforeValidator(validate_decimal),
            PlainSerializer(serialize_decimal(False)),
        ],
        pydantic.Field(alias="subTotal"),
    ] = UNSET
    r"""Amount of the line, inclusive of discounts but exclusive of tax."""

    tax_amount: Annotated[
        Annotated[
            OptionalNullable[Decimal],
            BeforeValidator(validate_decimal),
            PlainSerializer(serialize_decimal(False)),
        ],
        pydantic.Field(alias="taxAmount"),
    ] = UNSET
    r"""Amount of tax for the line."""

    tax_rate_ref: Annotated[
        Optional[TaxRateRef], pydantic.Field(alias="taxRateRef")
    ] = None
    r"""Data types that reference a tax rate, for example invoice and bill line items, use a taxRateRef that includes the ID and name of the linked tax rate.

    Found on:

    - Bill line items
    - Bill Credit Note line items
    - Credit Note line items
    - Direct incomes line items
    - Invoice line items
    - Items
    """

    total_amount: Annotated[
        Annotated[
            OptionalNullable[Decimal],
            BeforeValidator(validate_decimal),
            PlainSerializer(serialize_decimal(False)),
        ],
        pydantic.Field(alias="totalAmount"),
    ] = UNSET
    r"""Total amount of the line, including tax."""

    tracking: Optional[Tracking] = None

    tracking_category_refs: Annotated[
        OptionalNullable[List[TrackingCategoryRef]],
        pydantic.Field(
            deprecated="warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible.",
            alias="trackingCategoryRefs",
        ),
    ] = UNSET
    r"""Collection of categories against which this direct cost is tracked."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "accountRef",
            "description",
            "discountAmount",
            "discountPercentage",
            "itemRef",
            "subTotal",
            "taxAmount",
            "taxRateRef",
            "totalAmount",
            "tracking",
            "trackingCategoryRefs",
        ]
        nullable_fields = [
            "description",
            "discountAmount",
            "discountPercentage",
            "subTotal",
            "taxAmount",
            "totalAmount",
            "trackingCategoryRefs",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
