"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .billitem import BillItem, BillItemTypedDict
from .invoiceitem import InvoiceItem, InvoiceItemTypedDict
from .itemstatus import ItemStatus
from .itemtype import ItemType
from .metadata import Metadata, MetadataTypedDict
from .supplementaldata import SupplementalData, SupplementalDataTypedDict
from codat_accounting.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
import pydantic
from pydantic import model_serializer
from typing import Optional, TypedDict
from typing_extensions import Annotated, NotRequired


class ItemTypedDict(TypedDict):
    r"""> View the coverage for items in the <a className=\"external\" href=\"https://knowledge.codat.io/supported-features/accounting?view=tab-by-data-type&dataType=items\" target=\"_blank\">Data coverage explorer</a>.

    ## Overview

    **Items** allow your customers to save and track details of the products and services that they buy and sell.

    """

    is_bill_item: bool
    r"""Whether you can use this item for bills."""
    is_invoice_item: bool
    r"""Whether you can use this item for invoices."""
    item_status: ItemStatus
    r"""Current state of the item, either:

    - `Active`: Available for use
    - `Archived`: Unavailable
    - `Unknown`

    Due to a [limitation in Xero's API](https://docs.codat.io/integrations/accounting/xero/xero-faq#why-do-all-of-my-items-from-xero-have-their-status-as-unknown), all items from Xero are mapped as `Unknown`.
    """
    type: ItemType
    r"""Type of the item."""
    bill_item: NotRequired[BillItemTypedDict]
    r"""Item details that are only for bills."""
    code: NotRequired[Nullable[str]]
    r"""Friendly reference for the item."""
    id: NotRequired[str]
    r"""Identifier for the item that is unique to a company in the accounting software."""
    invoice_item: NotRequired[InvoiceItemTypedDict]
    r"""Item details that are only for bills."""
    metadata: NotRequired[MetadataTypedDict]
    modified_date: NotRequired[str]
    name: NotRequired[Nullable[str]]
    r"""Name of the item in the accounting software."""
    source_modified_date: NotRequired[str]
    supplemental_data: NotRequired[SupplementalDataTypedDict]
    r"""Supplemental data is additional data you can include in our standard data types.

    It is referenced as a configured dynamic key value pair that is unique to the accounting software. [Learn more](https://docs.codat.io/using-the-api/supplemental-data/overview) about supplemental data.
    """


class Item(BaseModel):
    r"""> View the coverage for items in the <a className=\"external\" href=\"https://knowledge.codat.io/supported-features/accounting?view=tab-by-data-type&dataType=items\" target=\"_blank\">Data coverage explorer</a>.

    ## Overview

    **Items** allow your customers to save and track details of the products and services that they buy and sell.

    """

    is_bill_item: Annotated[bool, pydantic.Field(alias="isBillItem")]
    r"""Whether you can use this item for bills."""

    is_invoice_item: Annotated[bool, pydantic.Field(alias="isInvoiceItem")]
    r"""Whether you can use this item for invoices."""

    item_status: Annotated[ItemStatus, pydantic.Field(alias="itemStatus")]
    r"""Current state of the item, either:

    - `Active`: Available for use
    - `Archived`: Unavailable
    - `Unknown`

    Due to a [limitation in Xero's API](https://docs.codat.io/integrations/accounting/xero/xero-faq#why-do-all-of-my-items-from-xero-have-their-status-as-unknown), all items from Xero are mapped as `Unknown`.
    """

    type: ItemType
    r"""Type of the item."""

    bill_item: Annotated[Optional[BillItem], pydantic.Field(alias="billItem")] = None
    r"""Item details that are only for bills."""

    code: OptionalNullable[str] = UNSET
    r"""Friendly reference for the item."""

    id: Optional[str] = None
    r"""Identifier for the item that is unique to a company in the accounting software."""

    invoice_item: Annotated[
        Optional[InvoiceItem], pydantic.Field(alias="invoiceItem")
    ] = None
    r"""Item details that are only for bills."""

    metadata: Optional[Metadata] = None

    modified_date: Annotated[Optional[str], pydantic.Field(alias="modifiedDate")] = None

    name: OptionalNullable[str] = UNSET
    r"""Name of the item in the accounting software."""

    source_modified_date: Annotated[
        Optional[str], pydantic.Field(alias="sourceModifiedDate")
    ] = None

    supplemental_data: Annotated[
        Optional[SupplementalData], pydantic.Field(alias="supplementalData")
    ] = None
    r"""Supplemental data is additional data you can include in our standard data types.

    It is referenced as a configured dynamic key value pair that is unique to the accounting software. [Learn more](https://docs.codat.io/using-the-api/supplemental-data/overview) about supplemental data.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "billItem",
            "code",
            "id",
            "invoiceItem",
            "metadata",
            "modifiedDate",
            "name",
            "sourceModifiedDate",
            "supplementalData",
        ]
        nullable_fields = ["code", "name"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
