"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .itemreceiptlineitem import ItemReceiptLineItem, ItemReceiptLineItemTypedDict
from .itemreceiptstatus import ItemReceiptStatus
from .metadata import Metadata, MetadataTypedDict
from .purchaseorderref import PurchaseOrderRef, PurchaseOrderRefTypedDict
from .supplementaldata import SupplementalData, SupplementalDataTypedDict
from .supplierref import SupplierRef, SupplierRefTypedDict
from codat_accounting.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from codat_accounting.utils import serialize_decimal, validate_decimal
from decimal import Decimal
import pydantic
from pydantic import model_serializer
from pydantic.functional_serializers import PlainSerializer
from pydantic.functional_validators import BeforeValidator
from typing import List, Optional, TypedDict
from typing_extensions import Annotated, NotRequired


class ItemReceiptTypedDict(TypedDict):
    r"""An item receipt records the receipt of items into a SMBs inventory. It links to a [purchase order](https://docs.codat.io/codat-api#/schemas/AccountingPurchaseOrder) and acts as an acknowledgement of items received.

    > **Language tip:** Item receipts may also be referred to as **Purchase receipt**, or **PO receiver inventory** in various accounting software.

    ADD SOMETHING ABOUT USAGE. E.g. a use case. or an example situation of where it can be used.
    """

    currency: NotRequired[str]
    r"""The currency data type in Codat is the [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code, e.g. _GBP_.

    ## Unknown currencies

    In line with the ISO 4217 specification, the code _XXX_ is used when the data source does not return a currency for a transaction.

    There are only a very small number of edge cases where this currency code is returned by the Codat system.
    """
    currency_rate: NotRequired[Nullable[Decimal]]
    r"""Rate to convert the total amount of the payment into the base currency for the company at the time of the payment.

    Currency rates in Codat are implemented as the multiple of foreign currency units to each base currency unit.

    It is not possible to perform the currency conversion with two or more non-base currencies participating in the transaction. For example, if a company's base currency is USD, and it has a bill issued in EUR, then the bill payment must happen in USD or EUR.

    Where the currency rate is provided by the underlying accounting software, it will be available from Codat with the same precision (up to a maximum of 9 decimal places).

    For accounting software which do not provide an explicit currency rate, it is calculated as `baseCurrency / foreignCurrency` and will be returned to 9 decimal places.

    ## Examples with base currency of GBP

    | Foreign Currency | Foreign Amount | Currency Rate | Base Currency Amount (GBP) |
    | :--------------- | :------------- | :------------ | :------------------------- |
    | **USD**          | $20            | 0.781         | £15.62                     |
    | **EUR**          | €20            | 0.885         | £17.70                     |
    | **RUB**          | ₽20            | 0.011         | £0.22                      |

    ## Examples with base currency of USD

    | Foreign Currency | Foreign Amount | Currency Rate | Base Currency Amount (USD) |
    | :--------------- | :------------- | :------------ | :------------------------- |
    | **GBP**          | £20            | 1.277         | $25.54                     |
    | **EUR**          | €20            | 1.134         | $22.68                     |
    | **RUB**          | ₽20            | 0.015         | $0.30                      |


    ### Integration-specific details

    | Integration       | Scenario                                        | System behavior                                                                                                                                                      |
    |-------------------|-------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------|
    | QuickBooks Online | Transaction currency differs from base currency | If currency rate value is left `null`, a rate of 1 will be used by QBO by default. To override this, specify a currencyRate in the request body.  |
    """
    id: NotRequired[str]
    r"""Identifier for the item receipt, unique for the company in the accounting software."""
    line_items: NotRequired[Nullable[List[ItemReceiptLineItemTypedDict]]]
    r"""Array of Item Receipt line items."""
    metadata: NotRequired[MetadataTypedDict]
    modified_date: NotRequired[str]
    note: NotRequired[Nullable[str]]
    r"""Any private, company notes about the item receipt, such as payment information."""
    purchase_order_refs: NotRequired[Nullable[List[PurchaseOrderRefTypedDict]]]
    received_date: NotRequired[str]
    reference: NotRequired[Nullable[str]]
    r"""User-friendly reference for the item receipt."""
    source_modified_date: NotRequired[str]
    status: NotRequired[ItemReceiptStatus]
    r"""Current status of the item receipt."""
    sub_total: NotRequired[Decimal]
    r"""Total amount of the item receipt, excluding any taxes."""
    supplemental_data: NotRequired[SupplementalDataTypedDict]
    r"""Supplemental data is additional data you can include in our standard data types.

    It is referenced as a configured dynamic key value pair that is unique to the accounting software. [Learn more](https://docs.codat.io/using-the-api/supplemental-data/overview) about supplemental data.
    """
    supplier_ref: NotRequired[SupplierRefTypedDict]
    r"""Reference to the supplier the record relates to."""
    total_amount: NotRequired[Decimal]
    r"""Amount of the item receipt, including tax."""


class ItemReceipt(BaseModel):
    r"""An item receipt records the receipt of items into a SMBs inventory. It links to a [purchase order](https://docs.codat.io/codat-api#/schemas/AccountingPurchaseOrder) and acts as an acknowledgement of items received.

    > **Language tip:** Item receipts may also be referred to as **Purchase receipt**, or **PO receiver inventory** in various accounting software.

    ADD SOMETHING ABOUT USAGE. E.g. a use case. or an example situation of where it can be used.
    """

    currency: Optional[str] = None
    r"""The currency data type in Codat is the [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code, e.g. _GBP_.

    ## Unknown currencies

    In line with the ISO 4217 specification, the code _XXX_ is used when the data source does not return a currency for a transaction.

    There are only a very small number of edge cases where this currency code is returned by the Codat system.
    """

    currency_rate: Annotated[
        Annotated[
            OptionalNullable[Decimal],
            BeforeValidator(validate_decimal),
            PlainSerializer(serialize_decimal(False)),
        ],
        pydantic.Field(alias="currencyRate"),
    ] = UNSET
    r"""Rate to convert the total amount of the payment into the base currency for the company at the time of the payment.

    Currency rates in Codat are implemented as the multiple of foreign currency units to each base currency unit.

    It is not possible to perform the currency conversion with two or more non-base currencies participating in the transaction. For example, if a company's base currency is USD, and it has a bill issued in EUR, then the bill payment must happen in USD or EUR.

    Where the currency rate is provided by the underlying accounting software, it will be available from Codat with the same precision (up to a maximum of 9 decimal places).

    For accounting software which do not provide an explicit currency rate, it is calculated as `baseCurrency / foreignCurrency` and will be returned to 9 decimal places.

    ## Examples with base currency of GBP

    | Foreign Currency | Foreign Amount | Currency Rate | Base Currency Amount (GBP) |
    | :--------------- | :------------- | :------------ | :------------------------- |
    | **USD**          | $20            | 0.781         | £15.62                     |
    | **EUR**          | €20            | 0.885         | £17.70                     |
    | **RUB**          | ₽20            | 0.011         | £0.22                      |

    ## Examples with base currency of USD

    | Foreign Currency | Foreign Amount | Currency Rate | Base Currency Amount (USD) |
    | :--------------- | :------------- | :------------ | :------------------------- |
    | **GBP**          | £20            | 1.277         | $25.54                     |
    | **EUR**          | €20            | 1.134         | $22.68                     |
    | **RUB**          | ₽20            | 0.015         | $0.30                      |


    ### Integration-specific details

    | Integration       | Scenario                                        | System behavior                                                                                                                                                      |
    |-------------------|-------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------|
    | QuickBooks Online | Transaction currency differs from base currency | If currency rate value is left `null`, a rate of 1 will be used by QBO by default. To override this, specify a currencyRate in the request body.  |
    """

    id: Optional[str] = None
    r"""Identifier for the item receipt, unique for the company in the accounting software."""

    line_items: Annotated[
        OptionalNullable[List[ItemReceiptLineItem]], pydantic.Field(alias="lineItems")
    ] = UNSET
    r"""Array of Item Receipt line items."""

    metadata: Optional[Metadata] = None

    modified_date: Annotated[Optional[str], pydantic.Field(alias="modifiedDate")] = None

    note: OptionalNullable[str] = UNSET
    r"""Any private, company notes about the item receipt, such as payment information."""

    purchase_order_refs: Annotated[
        OptionalNullable[List[PurchaseOrderRef]],
        pydantic.Field(alias="purchaseOrderRefs"),
    ] = UNSET

    received_date: Annotated[Optional[str], pydantic.Field(alias="receivedDate")] = None

    reference: OptionalNullable[str] = UNSET
    r"""User-friendly reference for the item receipt."""

    source_modified_date: Annotated[
        Optional[str], pydantic.Field(alias="sourceModifiedDate")
    ] = None

    status: Optional[ItemReceiptStatus] = None
    r"""Current status of the item receipt."""

    sub_total: Annotated[
        Annotated[
            Optional[Decimal],
            BeforeValidator(validate_decimal),
            PlainSerializer(serialize_decimal(False)),
        ],
        pydantic.Field(alias="subTotal"),
    ] = None
    r"""Total amount of the item receipt, excluding any taxes."""

    supplemental_data: Annotated[
        Optional[SupplementalData], pydantic.Field(alias="supplementalData")
    ] = None
    r"""Supplemental data is additional data you can include in our standard data types.

    It is referenced as a configured dynamic key value pair that is unique to the accounting software. [Learn more](https://docs.codat.io/using-the-api/supplemental-data/overview) about supplemental data.
    """

    supplier_ref: Annotated[
        Optional[SupplierRef], pydantic.Field(alias="supplierRef")
    ] = None
    r"""Reference to the supplier the record relates to."""

    total_amount: Annotated[
        Annotated[
            Optional[Decimal],
            BeforeValidator(validate_decimal),
            PlainSerializer(serialize_decimal(False)),
        ],
        pydantic.Field(alias="totalAmount"),
    ] = None
    r"""Amount of the item receipt, including tax."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "currency",
            "currencyRate",
            "id",
            "lineItems",
            "metadata",
            "modifiedDate",
            "note",
            "purchaseOrderRefs",
            "receivedDate",
            "reference",
            "sourceModifiedDate",
            "status",
            "subTotal",
            "supplementalData",
            "supplierRef",
            "totalAmount",
        ]
        nullable_fields = [
            "currencyRate",
            "lineItems",
            "note",
            "purchaseOrderRefs",
            "reference",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
