"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .accountref import AccountRef, AccountRefTypedDict
from .itemref import ItemRef, ItemRefTypedDict
from .trackingrecordref import TrackingRecordRef, TrackingRecordRefTypedDict
from codat_accounting.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from codat_accounting.utils import serialize_decimal, validate_decimal
from decimal import Decimal
from enum import Enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_serializers import PlainSerializer
from pydantic.functional_validators import BeforeValidator
from typing import List, Optional, TypedDict
from typing_extensions import Annotated, NotRequired


class ItemReceiptLineItemDataType(str, Enum):
    r"""Allowed name of the 'dataType'."""

    PURCHASE_ORDERS = "purchaseOrders"
    BILLS = "bills"


class RecordLineReferenceTypedDict(TypedDict):
    r"""Reference to the item receipt line this line was generated from."""

    data_type: NotRequired[ItemReceiptLineItemDataType]
    r"""Allowed name of the 'dataType'."""
    id: NotRequired[str]
    r"""'id' of the underlying record."""
    line_number: NotRequired[str]
    r"""Line number of the underlying record."""


class RecordLineReference(BaseModel):
    r"""Reference to the item receipt line this line was generated from."""

    data_type: Annotated[
        Optional[ItemReceiptLineItemDataType], pydantic.Field(alias="dataType")
    ] = None
    r"""Allowed name of the 'dataType'."""

    id: Optional[str] = None
    r"""'id' of the underlying record."""

    line_number: Annotated[Optional[str], pydantic.Field(alias="lineNumber")] = None
    r"""Line number of the underlying record."""


class ItemReceiptLineItemTrackingTypedDict(TypedDict):
    record_refs: NotRequired[Nullable[List[TrackingRecordRefTypedDict]]]


class ItemReceiptLineItemTracking(BaseModel):
    record_refs: Annotated[
        OptionalNullable[List[TrackingRecordRef]], pydantic.Field(alias="recordRefs")
    ] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["recordRefs"]
        nullable_fields = ["recordRefs"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ItemReceiptLineItemTypedDict(TypedDict):
    account_ref: NotRequired[AccountRefTypedDict]
    r"""Data types that reference an account, for example bill and invoice line items, use an accountRef that includes the ID and name of the linked account."""
    description: NotRequired[Nullable[str]]
    r"""Friendly name of the item or services received."""
    item_ref: NotRequired[ItemRefTypedDict]
    line_number: NotRequired[Nullable[str]]
    r"""The item receipt line's number."""
    purchase_order_line_ref: NotRequired[RecordLineReferenceTypedDict]
    quantity: NotRequired[Decimal]
    r"""Number of units of item or services received."""
    sub_total: NotRequired[Nullable[Decimal]]
    r"""Amount of the line, inclusive of discounts but exclusive of tax."""
    total_amount: NotRequired[Nullable[Decimal]]
    r"""Total amount of the line, including tax."""
    tracking: NotRequired[ItemReceiptLineItemTrackingTypedDict]
    unit_amount: NotRequired[Decimal]
    r"""Price of each unit of item or services."""
    unit_of_measurement: NotRequired[Nullable[str]]
    r"""The measurement which defines a unit for this item (e.g. 'kilogram', 'litre')."""


class ItemReceiptLineItem(BaseModel):
    account_ref: Annotated[Optional[AccountRef], pydantic.Field(alias="accountRef")] = (
        None
    )
    r"""Data types that reference an account, for example bill and invoice line items, use an accountRef that includes the ID and name of the linked account."""

    description: OptionalNullable[str] = UNSET
    r"""Friendly name of the item or services received."""

    item_ref: Annotated[Optional[ItemRef], pydantic.Field(alias="itemRef")] = None

    line_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="lineNumber")
    ] = UNSET
    r"""The item receipt line's number."""

    purchase_order_line_ref: Annotated[
        Optional[RecordLineReference], pydantic.Field(alias="purchaseOrderLineRef")
    ] = None

    quantity: Annotated[
        Optional[Decimal],
        BeforeValidator(validate_decimal),
        PlainSerializer(serialize_decimal(False)),
    ] = None
    r"""Number of units of item or services received."""

    sub_total: Annotated[
        Annotated[
            OptionalNullable[Decimal],
            BeforeValidator(validate_decimal),
            PlainSerializer(serialize_decimal(False)),
        ],
        pydantic.Field(alias="subTotal"),
    ] = UNSET
    r"""Amount of the line, inclusive of discounts but exclusive of tax."""

    total_amount: Annotated[
        Annotated[
            OptionalNullable[Decimal],
            BeforeValidator(validate_decimal),
            PlainSerializer(serialize_decimal(False)),
        ],
        pydantic.Field(alias="totalAmount"),
    ] = UNSET
    r"""Total amount of the line, including tax."""

    tracking: Optional[ItemReceiptLineItemTracking] = None

    unit_amount: Annotated[
        Annotated[
            Optional[Decimal],
            BeforeValidator(validate_decimal),
            PlainSerializer(serialize_decimal(False)),
        ],
        pydantic.Field(alias="unitAmount"),
    ] = None
    r"""Price of each unit of item or services."""

    unit_of_measurement: Annotated[
        OptionalNullable[str], pydantic.Field(alias="unitOfMeasurement")
    ] = UNSET
    r"""The measurement which defines a unit for this item (e.g. 'kilogram', 'litre')."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "accountRef",
            "description",
            "itemRef",
            "lineNumber",
            "purchaseOrderLineRef",
            "quantity",
            "subTotal",
            "totalAmount",
            "tracking",
            "unitAmount",
            "unitOfMeasurement",
        ]
        nullable_fields = [
            "description",
            "lineNumber",
            "subTotal",
            "totalAmount",
            "unitOfMeasurement",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
