"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .journalstatus import JournalStatus
from codat_accounting.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
import pydantic
from pydantic import model_serializer
from typing import Optional, TypedDict
from typing_extensions import Annotated, NotRequired


class JournalPrototypeTypedDict(TypedDict):
    created_on: NotRequired[str]
    r"""In Codat's data model, dates and times are represented using the <a class=\"external\" href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601 standard</a>. Date and time fields are formatted as strings; for example:

    ```
    2020-10-08T22:40:50Z
    2021-01-01T00:00:00
    ```



    When syncing data that contains `DateTime` fields from Codat, make sure you support the following cases when reading time information:

    - Coordinated Universal Time (UTC): `2021-11-15T06:00:00Z`
    - Unqualified local time: `2021-11-15T01:00:00`
    - UTC time offsets: `2021-11-15T01:00:00-05:00`

    > Time zones
    >
    > Not all dates from Codat will contain information about time zones.
    > Where it is not available from the underlying platform, Codat will return these as times local to the business whose data has been synced.
    """
    has_children: NotRequired[bool]
    r"""If the journal has child journals, this value is true. If it doesn’t, it is false."""
    journal_code: NotRequired[Nullable[str]]
    r"""Native journal number or code."""
    name: NotRequired[Nullable[str]]
    r"""Journal name.
    The maximum length for a journal name is 256 characters. All characters above that number will be truncated.
    """
    parent_id: NotRequired[Nullable[str]]
    r"""Parent journal ID.
    If the journal is a parent journal, this value is not present.
    """
    status: NotRequired[JournalStatus]
    r"""Current journal status."""
    type: NotRequired[Nullable[str]]
    r"""The type of the journal."""


class JournalPrototype(BaseModel):
    created_on: Annotated[Optional[str], pydantic.Field(alias="createdOn")] = None
    r"""In Codat's data model, dates and times are represented using the <a class=\"external\" href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601 standard</a>. Date and time fields are formatted as strings; for example:

    ```
    2020-10-08T22:40:50Z
    2021-01-01T00:00:00
    ```



    When syncing data that contains `DateTime` fields from Codat, make sure you support the following cases when reading time information:

    - Coordinated Universal Time (UTC): `2021-11-15T06:00:00Z`
    - Unqualified local time: `2021-11-15T01:00:00`
    - UTC time offsets: `2021-11-15T01:00:00-05:00`

    > Time zones
    >
    > Not all dates from Codat will contain information about time zones.
    > Where it is not available from the underlying platform, Codat will return these as times local to the business whose data has been synced.
    """

    has_children: Annotated[Optional[bool], pydantic.Field(alias="hasChildren")] = None
    r"""If the journal has child journals, this value is true. If it doesn’t, it is false."""

    journal_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="journalCode")
    ] = UNSET
    r"""Native journal number or code."""

    name: OptionalNullable[str] = UNSET
    r"""Journal name.
    The maximum length for a journal name is 256 characters. All characters above that number will be truncated.
    """

    parent_id: Annotated[OptionalNullable[str], pydantic.Field(alias="parentId")] = (
        UNSET
    )
    r"""Parent journal ID.
    If the journal is a parent journal, this value is not present.
    """

    status: Optional[JournalStatus] = None
    r"""Current journal status."""

    type: OptionalNullable[str] = UNSET
    r"""The type of the journal."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "createdOn",
            "hasChildren",
            "journalCode",
            "name",
            "parentId",
            "status",
            "type",
        ]
        nullable_fields = ["journalCode", "name", "parentId", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
