"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from codat_accounting.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import TypedDict
from typing_extensions import NotRequired


class JournalRefTypedDict(TypedDict):
    r"""Links journal entries to the relevant journal in accounting integrations that use multi-book accounting (multiple journals)."""

    id: str
    r"""GUID of the underlying journal."""
    name: NotRequired[Nullable[str]]
    r"""Name of journal"""


class JournalRef(BaseModel):
    r"""Links journal entries to the relevant journal in accounting integrations that use multi-book accounting (multiple journals)."""

    id: str
    r"""GUID of the underlying journal."""

    name: OptionalNullable[str] = UNSET
    r"""Name of journal"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["name"]
        nullable_fields = ["name"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
