"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from codat_accounting.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from codat_accounting.utils import serialize_decimal, validate_decimal
from decimal import Decimal
import pydantic
from pydantic import model_serializer
from pydantic.functional_serializers import PlainSerializer
from pydantic.functional_validators import BeforeValidator
from typing import List, TypedDict
from typing_extensions import Annotated, NotRequired


class ReportLineTypedDict(TypedDict):
    value: Decimal
    r"""Numerical value of the line item."""
    account_id: NotRequired[Nullable[str]]
    r"""Identifier for the account, unique for the company in the accounting software."""
    items: NotRequired[Nullable[List[ReportLineTypedDict]]]
    r"""An array of ReportLine items."""
    name: NotRequired[Nullable[str]]
    r"""Name of the report line item."""


class ReportLine(BaseModel):
    value: Annotated[
        Decimal,
        BeforeValidator(validate_decimal),
        PlainSerializer(serialize_decimal(False)),
    ]
    r"""Numerical value of the line item."""

    account_id: Annotated[OptionalNullable[str], pydantic.Field(alias="accountId")] = (
        UNSET
    )
    r"""Identifier for the account, unique for the company in the accounting software."""

    items: OptionalNullable[List[ReportLine]] = UNSET
    r"""An array of ReportLine items."""

    name: OptionalNullable[str] = UNSET
    r"""Name of the report line item."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["accountId", "items", "name"]
        nullable_fields = ["accountId", "items", "name"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
