"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .accountingcustomerref import AccountingCustomerRef, AccountingCustomerRefTypedDict
from .items import Items, ItemsTypedDict
from .metadata import Metadata, MetadataTypedDict
from .salesorderinvoicestatus import SalesOrderInvoiceStatus
from .salesorderlineitem import SalesOrderLineItem, SalesOrderLineItemTypedDict
from .salesorderstatus import SalesOrderStatus
from codat_accounting.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from codat_accounting.utils import serialize_decimal, validate_decimal
from decimal import Decimal
import pydantic
from pydantic import model_serializer
from pydantic.functional_serializers import PlainSerializer
from pydantic.functional_validators import BeforeValidator
from typing import List, Optional, TypedDict
from typing_extensions import Annotated, NotRequired


class SalesOrderContactTypedDict(TypedDict):
    r"""Details of the named contact at the delivery address."""

    email: NotRequired[Nullable[str]]
    r"""Email address of the contact at the delivery address."""
    name: NotRequired[Nullable[str]]
    r"""Name of the contact at the delivery address."""
    phone: NotRequired[Nullable[str]]
    r"""Phone number of the contact at the delivery address."""


class SalesOrderContact(BaseModel):
    r"""Details of the named contact at the delivery address."""

    email: OptionalNullable[str] = UNSET
    r"""Email address of the contact at the delivery address."""

    name: OptionalNullable[str] = UNSET
    r"""Name of the contact at the delivery address."""

    phone: OptionalNullable[str] = UNSET
    r"""Phone number of the contact at the delivery address."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["email", "name", "phone"]
        nullable_fields = ["email", "name", "phone"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SalesOrderShipToTypedDict(TypedDict):
    r"""Delivery details for any goods that have been ordered."""

    address: NotRequired[ItemsTypedDict]
    contact: NotRequired[SalesOrderContactTypedDict]
    r"""Details of the named contact at the delivery address."""


class SalesOrderShipTo(BaseModel):
    r"""Delivery details for any goods that have been ordered."""

    address: Optional[Items] = None

    contact: Optional[SalesOrderContact] = None
    r"""Details of the named contact at the delivery address."""


class SalesOrderTypedDict(TypedDict):
    r"""> View the coverage for sales orders in the <a className=\"external\" href=\"https://knowledge.codat.io/supported-features/accounting?view=tab-by-data-type&dataType=salesOrders\" target=\"_blank\">Data coverage explorer</a>.

    ## Overview

    A sales order represents a customer's intention to purchase goods or services from a seller and usually includes information such as the expected delivery date and shipping details. This information can be used to provide visibility on a business's expected receivables and to track sales through the full procurement process.

    A sales order is typically converted to an [invoice](https://docs.codat.io/accounting-api#/schemas/Invoice) after approval.
    """

    currency: NotRequired[str]
    r"""The currency data type in Codat is the [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code, e.g. _GBP_.

    ## Unknown currencies

    In line with the ISO 4217 specification, the code _XXX_ is used when the data source does not return a currency for a transaction.

    There are only a very small number of edge cases where this currency code is returned by the Codat system.
    """
    currency_rate: NotRequired[Nullable[Decimal]]
    r"""Rate to convert the total amount of the payment into the base currency for the company at the time of the payment.

    Currency rates in Codat are implemented as the multiple of foreign currency units to each base currency unit.

    It is not possible to perform the currency conversion with two or more non-base currencies participating in the transaction. For example, if a company's base currency is USD, and it has a bill issued in EUR, then the bill payment must happen in USD or EUR.

    Where the currency rate is provided by the underlying accounting software, it will be available from Codat with the same precision (up to a maximum of 9 decimal places).

    For accounting software which do not provide an explicit currency rate, it is calculated as `baseCurrency / foreignCurrency` and will be returned to 9 decimal places.

    ## Examples with base currency of GBP

    | Foreign Currency | Foreign Amount | Currency Rate | Base Currency Amount (GBP) |
    | :--------------- | :------------- | :------------ | :------------------------- |
    | **USD**          | $20            | 0.781         | £15.62                     |
    | **EUR**          | €20            | 0.885         | £17.70                     |
    | **RUB**          | ₽20            | 0.011         | £0.22                      |

    ## Examples with base currency of USD

    | Foreign Currency | Foreign Amount | Currency Rate | Base Currency Amount (USD) |
    | :--------------- | :------------- | :------------ | :------------------------- |
    | **GBP**          | £20            | 1.277         | $25.54                     |
    | **EUR**          | €20            | 1.134         | $22.68                     |
    | **RUB**          | ₽20            | 0.015         | $0.30                      |


    ### Integration-specific details

    | Integration       | Scenario                                        | System behavior                                                                                                                                                      |
    |-------------------|-------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------|
    | QuickBooks Online | Transaction currency differs from base currency | If currency rate value is left `null`, a rate of 1 will be used by QBO by default. To override this, specify a currencyRate in the request body.  |
    """
    customer_purchase_order_number: NotRequired[Nullable[str]]
    r"""A customer-supplied identifier for the purchase order in the customer's system."""
    customer_ref: NotRequired[AccountingCustomerRefTypedDict]
    expected_delivery_date: NotRequired[str]
    r"""In Codat's data model, dates and times are represented using the <a class=\"external\" href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601 standard</a>. Date and time fields are formatted as strings; for example:

    ```
    2020-10-08T22:40:50Z
    2021-01-01T00:00:00
    ```



    When syncing data that contains `DateTime` fields from Codat, make sure you support the following cases when reading time information:

    - Coordinated Universal Time (UTC): `2021-11-15T06:00:00Z`
    - Unqualified local time: `2021-11-15T01:00:00`
    - UTC time offsets: `2021-11-15T01:00:00-05:00`

    > Time zones
    >
    > Not all dates from Codat will contain information about time zones.
    > Where it is not available from the underlying platform, Codat will return these as times local to the business whose data has been synced.
    """
    id: NotRequired[str]
    r"""Identifier for the sales order, unique for the company in the accounting software."""
    invoicing_status: NotRequired[SalesOrderInvoiceStatus]
    r"""If the sales order is converted to an invoice, or will be in future, the invoicingStatus field indicates the current stage of the invoicing process."""
    issue_date: NotRequired[str]
    r"""In Codat's data model, dates and times are represented using the <a class=\"external\" href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601 standard</a>. Date and time fields are formatted as strings; for example:

    ```
    2020-10-08T22:40:50Z
    2021-01-01T00:00:00
    ```



    When syncing data that contains `DateTime` fields from Codat, make sure you support the following cases when reading time information:

    - Coordinated Universal Time (UTC): `2021-11-15T06:00:00Z`
    - Unqualified local time: `2021-11-15T01:00:00`
    - UTC time offsets: `2021-11-15T01:00:00-05:00`

    > Time zones
    >
    > Not all dates from Codat will contain information about time zones.
    > Where it is not available from the underlying platform, Codat will return these as times local to the business whose data has been synced.
    """
    line_items: NotRequired[Nullable[List[SalesOrderLineItemTypedDict]]]
    r"""An array of line items."""
    metadata: NotRequired[MetadataTypedDict]
    modified_date: NotRequired[str]
    note: NotRequired[Nullable[str]]
    r"""Any additional information associated with the sales order."""
    sales_order_number: NotRequired[Nullable[str]]
    r"""Friendly reference for the sales order, commonly generated by the accounting software."""
    ship_to: NotRequired[SalesOrderShipToTypedDict]
    r"""Delivery details for any goods that have been ordered."""
    source_modified_date: NotRequired[str]
    status: NotRequired[SalesOrderStatus]
    r"""Current state of the sales order."""
    sub_total: NotRequired[Decimal]
    r"""Total amount of the sales order, including discounts but excluding tax."""
    total_amount: NotRequired[Decimal]
    r"""Total amount of the sales order, including discounts and tax."""
    total_discount: NotRequired[Decimal]
    r"""Total value of any discounts applied to the sales order."""
    total_tax_amount: NotRequired[Decimal]
    r"""Total amount of tax included in the sales order."""


class SalesOrder(BaseModel):
    r"""> View the coverage for sales orders in the <a className=\"external\" href=\"https://knowledge.codat.io/supported-features/accounting?view=tab-by-data-type&dataType=salesOrders\" target=\"_blank\">Data coverage explorer</a>.

    ## Overview

    A sales order represents a customer's intention to purchase goods or services from a seller and usually includes information such as the expected delivery date and shipping details. This information can be used to provide visibility on a business's expected receivables and to track sales through the full procurement process.

    A sales order is typically converted to an [invoice](https://docs.codat.io/accounting-api#/schemas/Invoice) after approval.
    """

    currency: Optional[str] = None
    r"""The currency data type in Codat is the [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code, e.g. _GBP_.

    ## Unknown currencies

    In line with the ISO 4217 specification, the code _XXX_ is used when the data source does not return a currency for a transaction.

    There are only a very small number of edge cases where this currency code is returned by the Codat system.
    """

    currency_rate: Annotated[
        Annotated[
            OptionalNullable[Decimal],
            BeforeValidator(validate_decimal),
            PlainSerializer(serialize_decimal(False)),
        ],
        pydantic.Field(alias="currencyRate"),
    ] = UNSET
    r"""Rate to convert the total amount of the payment into the base currency for the company at the time of the payment.

    Currency rates in Codat are implemented as the multiple of foreign currency units to each base currency unit.

    It is not possible to perform the currency conversion with two or more non-base currencies participating in the transaction. For example, if a company's base currency is USD, and it has a bill issued in EUR, then the bill payment must happen in USD or EUR.

    Where the currency rate is provided by the underlying accounting software, it will be available from Codat with the same precision (up to a maximum of 9 decimal places).

    For accounting software which do not provide an explicit currency rate, it is calculated as `baseCurrency / foreignCurrency` and will be returned to 9 decimal places.

    ## Examples with base currency of GBP

    | Foreign Currency | Foreign Amount | Currency Rate | Base Currency Amount (GBP) |
    | :--------------- | :------------- | :------------ | :------------------------- |
    | **USD**          | $20            | 0.781         | £15.62                     |
    | **EUR**          | €20            | 0.885         | £17.70                     |
    | **RUB**          | ₽20            | 0.011         | £0.22                      |

    ## Examples with base currency of USD

    | Foreign Currency | Foreign Amount | Currency Rate | Base Currency Amount (USD) |
    | :--------------- | :------------- | :------------ | :------------------------- |
    | **GBP**          | £20            | 1.277         | $25.54                     |
    | **EUR**          | €20            | 1.134         | $22.68                     |
    | **RUB**          | ₽20            | 0.015         | $0.30                      |


    ### Integration-specific details

    | Integration       | Scenario                                        | System behavior                                                                                                                                                      |
    |-------------------|-------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------|
    | QuickBooks Online | Transaction currency differs from base currency | If currency rate value is left `null`, a rate of 1 will be used by QBO by default. To override this, specify a currencyRate in the request body.  |
    """

    customer_purchase_order_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="customerPurchaseOrderNumber")
    ] = UNSET
    r"""A customer-supplied identifier for the purchase order in the customer's system."""

    customer_ref: Annotated[
        Optional[AccountingCustomerRef], pydantic.Field(alias="customerRef")
    ] = None

    expected_delivery_date: Annotated[
        Optional[str], pydantic.Field(alias="expectedDeliveryDate")
    ] = None
    r"""In Codat's data model, dates and times are represented using the <a class=\"external\" href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601 standard</a>. Date and time fields are formatted as strings; for example:

    ```
    2020-10-08T22:40:50Z
    2021-01-01T00:00:00
    ```



    When syncing data that contains `DateTime` fields from Codat, make sure you support the following cases when reading time information:

    - Coordinated Universal Time (UTC): `2021-11-15T06:00:00Z`
    - Unqualified local time: `2021-11-15T01:00:00`
    - UTC time offsets: `2021-11-15T01:00:00-05:00`

    > Time zones
    >
    > Not all dates from Codat will contain information about time zones.
    > Where it is not available from the underlying platform, Codat will return these as times local to the business whose data has been synced.
    """

    id: Optional[str] = None
    r"""Identifier for the sales order, unique for the company in the accounting software."""

    invoicing_status: Annotated[
        Optional[SalesOrderInvoiceStatus], pydantic.Field(alias="invoicingStatus")
    ] = None
    r"""If the sales order is converted to an invoice, or will be in future, the invoicingStatus field indicates the current stage of the invoicing process."""

    issue_date: Annotated[Optional[str], pydantic.Field(alias="issueDate")] = None
    r"""In Codat's data model, dates and times are represented using the <a class=\"external\" href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601 standard</a>. Date and time fields are formatted as strings; for example:

    ```
    2020-10-08T22:40:50Z
    2021-01-01T00:00:00
    ```



    When syncing data that contains `DateTime` fields from Codat, make sure you support the following cases when reading time information:

    - Coordinated Universal Time (UTC): `2021-11-15T06:00:00Z`
    - Unqualified local time: `2021-11-15T01:00:00`
    - UTC time offsets: `2021-11-15T01:00:00-05:00`

    > Time zones
    >
    > Not all dates from Codat will contain information about time zones.
    > Where it is not available from the underlying platform, Codat will return these as times local to the business whose data has been synced.
    """

    line_items: Annotated[
        OptionalNullable[List[SalesOrderLineItem]], pydantic.Field(alias="lineItems")
    ] = UNSET
    r"""An array of line items."""

    metadata: Optional[Metadata] = None

    modified_date: Annotated[Optional[str], pydantic.Field(alias="modifiedDate")] = None

    note: OptionalNullable[str] = UNSET
    r"""Any additional information associated with the sales order."""

    sales_order_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="salesOrderNumber")
    ] = UNSET
    r"""Friendly reference for the sales order, commonly generated by the accounting software."""

    ship_to: Annotated[Optional[SalesOrderShipTo], pydantic.Field(alias="shipTo")] = (
        None
    )
    r"""Delivery details for any goods that have been ordered."""

    source_modified_date: Annotated[
        Optional[str], pydantic.Field(alias="sourceModifiedDate")
    ] = None

    status: Optional[SalesOrderStatus] = None
    r"""Current state of the sales order."""

    sub_total: Annotated[
        Annotated[
            Optional[Decimal],
            BeforeValidator(validate_decimal),
            PlainSerializer(serialize_decimal(False)),
        ],
        pydantic.Field(alias="subTotal"),
    ] = None
    r"""Total amount of the sales order, including discounts but excluding tax."""

    total_amount: Annotated[
        Annotated[
            Optional[Decimal],
            BeforeValidator(validate_decimal),
            PlainSerializer(serialize_decimal(False)),
        ],
        pydantic.Field(alias="totalAmount"),
    ] = None
    r"""Total amount of the sales order, including discounts and tax."""

    total_discount: Annotated[
        Annotated[
            Optional[Decimal],
            BeforeValidator(validate_decimal),
            PlainSerializer(serialize_decimal(False)),
        ],
        pydantic.Field(alias="totalDiscount"),
    ] = None
    r"""Total value of any discounts applied to the sales order."""

    total_tax_amount: Annotated[
        Annotated[
            Optional[Decimal],
            BeforeValidator(validate_decimal),
            PlainSerializer(serialize_decimal(False)),
        ],
        pydantic.Field(alias="totalTaxAmount"),
    ] = None
    r"""Total amount of tax included in the sales order."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "currency",
            "currencyRate",
            "customerPurchaseOrderNumber",
            "customerRef",
            "expectedDeliveryDate",
            "id",
            "invoicingStatus",
            "issueDate",
            "lineItems",
            "metadata",
            "modifiedDate",
            "note",
            "salesOrderNumber",
            "shipTo",
            "sourceModifiedDate",
            "status",
            "subTotal",
            "totalAmount",
            "totalDiscount",
            "totalTaxAmount",
        ]
        nullable_fields = [
            "currencyRate",
            "customerPurchaseOrderNumber",
            "lineItems",
            "note",
            "salesOrderNumber",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
