"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .metadata import Metadata, MetadataTypedDict
from .supplementaldata import SupplementalData, SupplementalDataTypedDict
from .taxratecomponent import TaxRateComponent, TaxRateComponentTypedDict
from .taxratestatus import TaxRateStatus
from .validdatatypelinks import ValidDataTypeLinks, ValidDataTypeLinksTypedDict
from codat_accounting.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from codat_accounting.utils import serialize_decimal, validate_decimal
from decimal import Decimal
import pydantic
from pydantic import model_serializer
from pydantic.functional_serializers import PlainSerializer
from pydantic.functional_validators import BeforeValidator
from typing import List, Optional, TypedDict
from typing_extensions import Annotated, NotRequired


class TaxRateTypedDict(TypedDict):
    r"""> View the coverage for tax rates in the <a className=\"external\" href=\"https://knowledge.codat.io/supported-features/accounting?view=tab-by-data-type&dataType=taxRates\" target=\"_blank\">Data coverage explorer</a>.

    ## Overview

    Accounting systems typically store a set of taxes and associated rates within the accounting software. This means that users don't have to look up or remember the rates for each type of tax. For example, applying the tax \"UK sales VAT\" to line items of an invoice adds the correct rate of 20%.

    ### Tax components

    In some cases, a tax is made up of multiple sub taxes, often called _components_ of the tax.  For example, you may have an item that is charged a tax rate called \"City import tax (8%)\" that has two components:

    - A city tax of 5%
    - An import tax of 3%

    > **Effective tax rates**
    > - Where there are multiple components of a tax, each component may be calculated on the original amount and added together. Alternatively, one tax may be calculated on the sub-total of the original amount plus another tax, which is referred to as _compounding_. When there is compounding, the effective tax rate is the rate that, if applied to the original amount, would result in the total amount of tax with compounding.
    >
    > **Example:**
    > A tax has two components. Both components have a rate of 10%, and one component is compound. In this case, there is a total tax rate of 20% but an effective tax rate of 21%.
    >
    > - For QuickBooks Online, Codat doesn't use compound rates. Instead, the calculated effective tax rate for each component is shown. This means that the effective and total rates are the same because the total tax rate is a sum of the component rates.
    """

    code: NotRequired[Nullable[str]]
    r"""Code for the tax rate from the accounting software."""
    components: NotRequired[Nullable[List[TaxRateComponentTypedDict]]]
    effective_tax_rate: NotRequired[Nullable[Decimal]]
    r"""See Effective tax rates description."""
    id: NotRequired[str]
    r"""Identifier for the tax rate, unique for the company in the accounting software."""
    metadata: NotRequired[MetadataTypedDict]
    modified_date: NotRequired[str]
    name: NotRequired[Nullable[str]]
    r"""Codat-augmented name of the tax rate in the accounting software."""
    source_modified_date: NotRequired[str]
    status: NotRequired[TaxRateStatus]
    r"""Status of the tax rate in the accounting software.
    - `Active` - An active tax rate in use by a company.
    - `Archived` - A tax rate that has been archived or is inactive in the accounting software.
    - `Unknown` - Where the status of the tax rate cannot be determined from the underlying platform.
    """
    supplemental_data: NotRequired[SupplementalDataTypedDict]
    r"""Supplemental data is additional data you can include in our standard data types.

    It is referenced as a configured dynamic key value pair that is unique to the accounting software. [Learn more](https://docs.codat.io/using-the-api/supplemental-data/overview) about supplemental data.
    """
    total_tax_rate: NotRequired[Nullable[Decimal]]
    r"""Total (not compounded) sum of the components of a tax rate."""
    valid_datatype_links: NotRequired[Nullable[List[ValidDataTypeLinksTypedDict]]]


class TaxRate(BaseModel):
    r"""> View the coverage for tax rates in the <a className=\"external\" href=\"https://knowledge.codat.io/supported-features/accounting?view=tab-by-data-type&dataType=taxRates\" target=\"_blank\">Data coverage explorer</a>.

    ## Overview

    Accounting systems typically store a set of taxes and associated rates within the accounting software. This means that users don't have to look up or remember the rates for each type of tax. For example, applying the tax \"UK sales VAT\" to line items of an invoice adds the correct rate of 20%.

    ### Tax components

    In some cases, a tax is made up of multiple sub taxes, often called _components_ of the tax.  For example, you may have an item that is charged a tax rate called \"City import tax (8%)\" that has two components:

    - A city tax of 5%
    - An import tax of 3%

    > **Effective tax rates**
    > - Where there are multiple components of a tax, each component may be calculated on the original amount and added together. Alternatively, one tax may be calculated on the sub-total of the original amount plus another tax, which is referred to as _compounding_. When there is compounding, the effective tax rate is the rate that, if applied to the original amount, would result in the total amount of tax with compounding.
    >
    > **Example:**
    > A tax has two components. Both components have a rate of 10%, and one component is compound. In this case, there is a total tax rate of 20% but an effective tax rate of 21%.
    >
    > - For QuickBooks Online, Codat doesn't use compound rates. Instead, the calculated effective tax rate for each component is shown. This means that the effective and total rates are the same because the total tax rate is a sum of the component rates.
    """

    code: OptionalNullable[str] = UNSET
    r"""Code for the tax rate from the accounting software."""

    components: OptionalNullable[List[TaxRateComponent]] = UNSET

    effective_tax_rate: Annotated[
        Annotated[
            OptionalNullable[Decimal],
            BeforeValidator(validate_decimal),
            PlainSerializer(serialize_decimal(False)),
        ],
        pydantic.Field(alias="effectiveTaxRate"),
    ] = UNSET
    r"""See Effective tax rates description."""

    id: Optional[str] = None
    r"""Identifier for the tax rate, unique for the company in the accounting software."""

    metadata: Optional[Metadata] = None

    modified_date: Annotated[Optional[str], pydantic.Field(alias="modifiedDate")] = None

    name: OptionalNullable[str] = UNSET
    r"""Codat-augmented name of the tax rate in the accounting software."""

    source_modified_date: Annotated[
        Optional[str], pydantic.Field(alias="sourceModifiedDate")
    ] = None

    status: Optional[TaxRateStatus] = None
    r"""Status of the tax rate in the accounting software.
    - `Active` - An active tax rate in use by a company.
    - `Archived` - A tax rate that has been archived or is inactive in the accounting software.
    - `Unknown` - Where the status of the tax rate cannot be determined from the underlying platform.
    """

    supplemental_data: Annotated[
        Optional[SupplementalData], pydantic.Field(alias="supplementalData")
    ] = None
    r"""Supplemental data is additional data you can include in our standard data types.

    It is referenced as a configured dynamic key value pair that is unique to the accounting software. [Learn more](https://docs.codat.io/using-the-api/supplemental-data/overview) about supplemental data.
    """

    total_tax_rate: Annotated[
        Annotated[
            OptionalNullable[Decimal],
            BeforeValidator(validate_decimal),
            PlainSerializer(serialize_decimal(False)),
        ],
        pydantic.Field(alias="totalTaxRate"),
    ] = UNSET
    r"""Total (not compounded) sum of the components of a tax rate."""

    valid_datatype_links: Annotated[
        OptionalNullable[List[ValidDataTypeLinks]],
        pydantic.Field(alias="validDatatypeLinks"),
    ] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "code",
            "components",
            "effectiveTaxRate",
            "id",
            "metadata",
            "modifiedDate",
            "name",
            "sourceModifiedDate",
            "status",
            "supplementalData",
            "totalTaxRate",
            "validDatatypeLinks",
        ]
        nullable_fields = [
            "code",
            "components",
            "effectiveTaxRate",
            "name",
            "totalTaxRate",
            "validDatatypeLinks",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
