"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from codat_accounting.types import BaseModel
from codat_accounting.utils import serialize_decimal, validate_decimal
from decimal import Decimal
import pydantic
from pydantic.functional_serializers import PlainSerializer
from pydantic.functional_validators import BeforeValidator
from typing import Optional, TypedDict
from typing_extensions import Annotated, NotRequired


class TaxRateRefTypedDict(TypedDict):
    r"""Data types that reference a tax rate, for example invoice and bill line items, use a taxRateRef that includes the ID and name of the linked tax rate.

    Found on:

    - Bill line items
    - Bill Credit Note line items
    - Credit Note line items
    - Direct incomes line items
    - Invoice line items
    - Items
    """

    effective_tax_rate: NotRequired[Decimal]
    r"""Applicable tax rate."""
    id: NotRequired[str]
    r"""Unique identifier for the tax rate in the accounting software."""
    name: NotRequired[str]
    r"""Name of the tax rate in the accounting software."""


class TaxRateRef(BaseModel):
    r"""Data types that reference a tax rate, for example invoice and bill line items, use a taxRateRef that includes the ID and name of the linked tax rate.

    Found on:

    - Bill line items
    - Bill Credit Note line items
    - Credit Note line items
    - Direct incomes line items
    - Invoice line items
    - Items
    """

    effective_tax_rate: Annotated[
        Annotated[
            Optional[Decimal],
            BeforeValidator(validate_decimal),
            PlainSerializer(serialize_decimal(False)),
        ],
        pydantic.Field(alias="effectiveTaxRate"),
    ] = None
    r"""Applicable tax rate."""

    id: Optional[str] = None
    r"""Unique identifier for the tax rate in the accounting software."""

    name: Optional[str] = None
    r"""Name of the tax rate in the accounting software."""
