"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .trackingrecordref import TrackingRecordRef, TrackingRecordRefTypedDict
from codat_accounting.types import BaseModel
import pydantic
from typing import List, Optional, TypedDict
from typing_extensions import Annotated, NotRequired


class RecordReferenceTypedDict(TypedDict):
    r"""Links the current record to the underlying record or data type that created it.

    For example, if a journal entry is generated based on an invoice, this property allows you to connect the journal entry to the underlying invoice in our data model.
    """

    data_type: NotRequired[str]
    r"""Allowed name of the 'dataType'."""
    id: NotRequired[str]
    r"""'id' of the underlying record or data type."""


class RecordReference(BaseModel):
    r"""Links the current record to the underlying record or data type that created it.

    For example, if a journal entry is generated based on an invoice, this property allows you to connect the journal entry to the underlying invoice in our data model.
    """

    data_type: Annotated[Optional[str], pydantic.Field(alias="dataType")] = None
    r"""Allowed name of the 'dataType'."""

    id: Optional[str] = None
    r"""'id' of the underlying record or data type."""


class TrackingTypedDict(TypedDict):
    record_refs: List[TrackingRecordRefTypedDict]
    invoice_to: NotRequired[RecordReferenceTypedDict]
    r"""Links the current record to the underlying record or data type that created it.

    For example, if a journal entry is generated based on an invoice, this property allows you to connect the journal entry to the underlying invoice in our data model.
    """


class Tracking(BaseModel):
    record_refs: Annotated[List[TrackingRecordRef], pydantic.Field(alias="recordRefs")]

    invoice_to: Annotated[
        Optional[RecordReference], pydantic.Field(alias="invoiceTo")
    ] = None
    r"""Links the current record to the underlying record or data type that created it.

    For example, if a journal entry is generated based on an invoice, this property allows you to connect the journal entry to the underlying invoice in our data model.
    """
