"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .metadata import Metadata, MetadataTypedDict
from .status import Status
from codat_accounting.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
import pydantic
from pydantic import model_serializer
from typing import Optional, TypedDict
from typing_extensions import Annotated, NotRequired


class TrackingCategoryTypedDict(TypedDict):
    r"""Details of a category used for tracking transactions.

    > Language tip
    >
    > Parameters used to track types of spend in various parts of an organization can be called  **dimensions**, **projects**, **classes**, or **locations** in different accounting software. In Codat, we refer to these as tracking categories.

    View the coverage for tracking categories in the <a className=\"external\" href=\"https://knowledge.codat.io/supported-features/accounting?view=tab-by-data-type&dataType=trackingCategories\" target=\"_blank\">Data coverage explorer</a>.

    ## Overview

    Tracking categories are used to monitor cost centres and control budgets that sit outside the standard chart of accounts. Customers may use tracking categories to group together and track the income and costs of specific departments, projects, locations or customers.

    From their accounting system, customers can:

    - Create and maintain tracking categories and tracking category types.
    - View all tracking categories that are available for use.
    - View the relationships between the categories.
    - Assign invoices, bills, credit notes, or bill credit notes to one or more categories.
    - View the categories that a transaction belongs to.
    - View all transactions in a tracking category.

    ### Tracking categories per platform

    Review the platform-specific tracking categories that Codat supports, and the level they are assigned to in the source platform.

    <table>
    <thead>
    <tr>
    <th>Platform</th>
    <th>Tracking category</th>
    <th>Tracking level</th>
    </tr>
    </thead>
    <tbody>
    <tr>
    <td><b>Dynamics 365</b></td>
    <td>Dimensions</td>
    <td>Line item</td>
    </tr>
    <tr>
    <td><b>Freshbooks</b></td>
    <td>Expense&nbsp;categories</td>
    <td>Line item</td>
    </tr>
    <tr>
    <td><b>MYOB</b></td>
    <td>Categories</td>
    <td>Transaction</td>
    </tr>
    <tr>
    <td rowspan=4><b>Netsuite</b></td>
    <td>Classes</td>
    <td>Line item</td>
    </tr>
    <tr>
    <td>Locations</td>
    <td>Line item</td>
    </tr>
    <tr>
    <td>Departments</td>
    <td>Line item</td>
    </tr>
    <tr>
    <td>Custom&nbsp;segments</td>
    <td>Line item</td>
    </tr>
    <tr>
    <td rowspan=2><b>QuickBooks Desktop</b></td>
    <td>Classes</td>
    <td>Line item or transaction level</td>
    </tr>
    <tr>
    <td>Locations</td>
    <td>Transaction</td>
    </tr>
    <tr>
    <td rowspan=2><b>QuickBooks Online</b></td>
    <td>Classes</td>
    <td>Line item or transaction level</td>
    </tr>
    <tr>
    <td>Locations</td>
    <td>Transaction</td>
    </tr>
    <tr>
    <td rowspan=3><b>Sage 200</b></td>
    <td>Cost&nbsp;centers</td>
    <td>Line item</td>
    </tr>
    <tr>
    <td>Departments</td>
    <td>Line item</td>
    </tr>
    <tr>
    <td>Analysis&nbsp;codes</td>
    <td>Transaction</td>
    </tr>
    <tr>
    <td rowspan=3><b>Sage 50</b></td>
    <td>Departments</td>
    <td>Line item</td>
    </tr>
    <tr>
    <td>Costcodes</td>
    <td>Line item</td>
    </tr>
    <tr>
    <td>Projects</td>
    <td>Line item</td>
    </tr>
    <tr>
    <td><b>Sage Intacct</b></td>
    <td>Dimensions</td>
    <td>Line item</td>
    </tr>
    <tr>
    <td><b>Xero</b></td>
    <td>Tracking&nbsp;categories</td>
    <td>Line item</td>
    </tr>
    </tbody>
    </table>

    > **Example use case**
    >
    > Monitor the budget for your annual conference using a tracking category called 'AnnualConference2020' with the **type** set to **Costing**.

    If a tracking category has a parent category, the ID of that parent category is displayed. There is also a `hasChildren` field that shows whether there are child subcategories nested beneath.
    """

    has_children: NotRequired[bool]
    r"""Boolean value indicating whether this category has SubCategories."""
    id: NotRequired[Nullable[str]]
    r"""The identifier for the item, unique per tracking category."""
    metadata: NotRequired[MetadataTypedDict]
    modified_date: NotRequired[str]
    name: NotRequired[Nullable[str]]
    r"""The name of the tracking category."""
    parent_id: NotRequired[Nullable[str]]
    r"""The identifier for this item's immediate parent."""
    source_modified_date: NotRequired[str]
    status: NotRequired[Status]
    r"""Current state of the tracking category."""


class TrackingCategory(BaseModel):
    r"""Details of a category used for tracking transactions.

    > Language tip
    >
    > Parameters used to track types of spend in various parts of an organization can be called  **dimensions**, **projects**, **classes**, or **locations** in different accounting software. In Codat, we refer to these as tracking categories.

    View the coverage for tracking categories in the <a className=\"external\" href=\"https://knowledge.codat.io/supported-features/accounting?view=tab-by-data-type&dataType=trackingCategories\" target=\"_blank\">Data coverage explorer</a>.

    ## Overview

    Tracking categories are used to monitor cost centres and control budgets that sit outside the standard chart of accounts. Customers may use tracking categories to group together and track the income and costs of specific departments, projects, locations or customers.

    From their accounting system, customers can:

    - Create and maintain tracking categories and tracking category types.
    - View all tracking categories that are available for use.
    - View the relationships between the categories.
    - Assign invoices, bills, credit notes, or bill credit notes to one or more categories.
    - View the categories that a transaction belongs to.
    - View all transactions in a tracking category.

    ### Tracking categories per platform

    Review the platform-specific tracking categories that Codat supports, and the level they are assigned to in the source platform.

    <table>
    <thead>
    <tr>
    <th>Platform</th>
    <th>Tracking category</th>
    <th>Tracking level</th>
    </tr>
    </thead>
    <tbody>
    <tr>
    <td><b>Dynamics 365</b></td>
    <td>Dimensions</td>
    <td>Line item</td>
    </tr>
    <tr>
    <td><b>Freshbooks</b></td>
    <td>Expense&nbsp;categories</td>
    <td>Line item</td>
    </tr>
    <tr>
    <td><b>MYOB</b></td>
    <td>Categories</td>
    <td>Transaction</td>
    </tr>
    <tr>
    <td rowspan=4><b>Netsuite</b></td>
    <td>Classes</td>
    <td>Line item</td>
    </tr>
    <tr>
    <td>Locations</td>
    <td>Line item</td>
    </tr>
    <tr>
    <td>Departments</td>
    <td>Line item</td>
    </tr>
    <tr>
    <td>Custom&nbsp;segments</td>
    <td>Line item</td>
    </tr>
    <tr>
    <td rowspan=2><b>QuickBooks Desktop</b></td>
    <td>Classes</td>
    <td>Line item or transaction level</td>
    </tr>
    <tr>
    <td>Locations</td>
    <td>Transaction</td>
    </tr>
    <tr>
    <td rowspan=2><b>QuickBooks Online</b></td>
    <td>Classes</td>
    <td>Line item or transaction level</td>
    </tr>
    <tr>
    <td>Locations</td>
    <td>Transaction</td>
    </tr>
    <tr>
    <td rowspan=3><b>Sage 200</b></td>
    <td>Cost&nbsp;centers</td>
    <td>Line item</td>
    </tr>
    <tr>
    <td>Departments</td>
    <td>Line item</td>
    </tr>
    <tr>
    <td>Analysis&nbsp;codes</td>
    <td>Transaction</td>
    </tr>
    <tr>
    <td rowspan=3><b>Sage 50</b></td>
    <td>Departments</td>
    <td>Line item</td>
    </tr>
    <tr>
    <td>Costcodes</td>
    <td>Line item</td>
    </tr>
    <tr>
    <td>Projects</td>
    <td>Line item</td>
    </tr>
    <tr>
    <td><b>Sage Intacct</b></td>
    <td>Dimensions</td>
    <td>Line item</td>
    </tr>
    <tr>
    <td><b>Xero</b></td>
    <td>Tracking&nbsp;categories</td>
    <td>Line item</td>
    </tr>
    </tbody>
    </table>

    > **Example use case**
    >
    > Monitor the budget for your annual conference using a tracking category called 'AnnualConference2020' with the **type** set to **Costing**.

    If a tracking category has a parent category, the ID of that parent category is displayed. There is also a `hasChildren` field that shows whether there are child subcategories nested beneath.
    """

    has_children: Annotated[Optional[bool], pydantic.Field(alias="hasChildren")] = None
    r"""Boolean value indicating whether this category has SubCategories."""

    id: OptionalNullable[str] = UNSET
    r"""The identifier for the item, unique per tracking category."""

    metadata: Optional[Metadata] = None

    modified_date: Annotated[Optional[str], pydantic.Field(alias="modifiedDate")] = None

    name: OptionalNullable[str] = UNSET
    r"""The name of the tracking category."""

    parent_id: Annotated[OptionalNullable[str], pydantic.Field(alias="parentId")] = (
        UNSET
    )
    r"""The identifier for this item's immediate parent."""

    source_modified_date: Annotated[
        Optional[str], pydantic.Field(alias="sourceModifiedDate")
    ] = None

    status: Optional[Status] = None
    r"""Current state of the tracking category."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "hasChildren",
            "id",
            "metadata",
            "modifiedDate",
            "name",
            "parentId",
            "sourceModifiedDate",
            "status",
        ]
        nullable_fields = ["id", "name", "parentId"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
