"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .metadata import Metadata, MetadataTypedDict
from .status import Status
from codat_accounting.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
import pydantic
from pydantic import model_serializer
from typing import List, Optional, TypedDict
from typing_extensions import Annotated, NotRequired


class TrackingCategoryTreeTypedDict(TypedDict):
    r"""The full structure of a specific tracking category including any child or subcategories."""

    has_children: NotRequired[bool]
    r"""Boolean value indicating whether this category has SubCategories"""
    id: NotRequired[Nullable[str]]
    r"""The identifier for the item, unique per tracking category"""
    metadata: NotRequired[MetadataTypedDict]
    modified_date: NotRequired[str]
    name: NotRequired[Nullable[str]]
    r"""The name of the tracking category"""
    parent_id: NotRequired[Nullable[str]]
    r"""The identifier for this item's immediate parent"""
    source_modified_date: NotRequired[str]
    status: NotRequired[Status]
    r"""Current state of the tracking category."""
    sub_categories: NotRequired[Nullable[List[TrackingCategoryTreeTypedDict]]]
    r"""A collection of subcategories that are nested beneath this category."""


class TrackingCategoryTree(BaseModel):
    r"""The full structure of a specific tracking category including any child or subcategories."""

    has_children: Annotated[Optional[bool], pydantic.Field(alias="hasChildren")] = None
    r"""Boolean value indicating whether this category has SubCategories"""

    id: OptionalNullable[str] = UNSET
    r"""The identifier for the item, unique per tracking category"""

    metadata: Optional[Metadata] = None

    modified_date: Annotated[Optional[str], pydantic.Field(alias="modifiedDate")] = None

    name: OptionalNullable[str] = UNSET
    r"""The name of the tracking category"""

    parent_id: Annotated[OptionalNullable[str], pydantic.Field(alias="parentId")] = (
        UNSET
    )
    r"""The identifier for this item's immediate parent"""

    source_modified_date: Annotated[
        Optional[str], pydantic.Field(alias="sourceModifiedDate")
    ] = None

    status: Optional[Status] = None
    r"""Current state of the tracking category."""

    sub_categories: Annotated[
        OptionalNullable[List[TrackingCategoryTree]],
        pydantic.Field(alias="subCategories"),
    ] = UNSET
    r"""A collection of subcategories that are nested beneath this category."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "hasChildren",
            "id",
            "metadata",
            "modifiedDate",
            "name",
            "parentId",
            "sourceModifiedDate",
            "status",
            "subCategories",
        ]
        nullable_fields = ["id", "name", "parentId", "subCategories"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
