"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from .httpclient import AsyncHttpClient, HttpClient
from .sdkconfiguration import SDKConfiguration
from .utils.logger import Logger, get_default_logger
from .utils.retries import RetryConfig
from codat_accounting import utils
from codat_accounting._hooks import SDKHooks
from codat_accounting.account_transactions import AccountTransactions
from codat_accounting.accounts import Accounts
from codat_accounting.bank_account_transactions import BankAccountTransactions
from codat_accounting.bank_accounts import BankAccounts
from codat_accounting.bill_credit_notes import BillCreditNotes
from codat_accounting.bill_payments import BillPayments
from codat_accounting.bills import Bills
from codat_accounting.company_info import CompanyInfo
from codat_accounting.credit_notes import CreditNotes
from codat_accounting.customers import Customers
from codat_accounting.direct_costs import DirectCosts
from codat_accounting.direct_incomes import DirectIncomes
from codat_accounting.invoices import Invoices
from codat_accounting.item_receipts import ItemReceipts
from codat_accounting.items import Items
from codat_accounting.journal_entries import JournalEntries
from codat_accounting.journals import Journals
from codat_accounting.models import shared
from codat_accounting.payment_methods import PaymentMethods
from codat_accounting.payments import Payments
from codat_accounting.purchase_orders import PurchaseOrders
from codat_accounting.reports import Reports
from codat_accounting.sales_orders import SalesOrders
from codat_accounting.suppliers import Suppliers
from codat_accounting.tax_rates import TaxRates
from codat_accounting.tracking_categories import TrackingCategories
from codat_accounting.transfers import Transfers
from codat_accounting.types import OptionalNullable, UNSET
import httpx
from typing import Callable, Dict, Optional, Union


class CodatAccounting(BaseSDK):
    r"""Accounting API: > ### New to Codat?
    >
    > Our Accounting API reference is relevant only to our existing clients.
    > Please reach out to your Codat contact so that we can find the right product for you.

    A flexible API for pulling accounting data, normalized and aggregated from 20 accounting integrations.

    Standardize how you connect to your customers’ accounting software. View, create, update, and delete data in the same way for all the leading accounting software.

    <!-- Start Codat Tags Table -->
    ## Endpoints

    | Endpoints | Description |
    | :- |:- |
    | Accounts | Access standardized Accounts from linked accounting software. |
    | Account transactions | Access standardized Account transactions from linked accounting software. |
    | Bank accounts | Access standardized Bank accounts from linked accounting software. |
    | Bank account transactions | Access standardized Bank transactions for bank accounts from linked accounting software. |
    | Bills | Access standardized Bills from linked accounting software. |
    | Bill credit notes | Access standardized Bill credit notes from linked accounting software. |
    | Bill payments | Access standardized Bill payments from linked accounting software. |
    | Credit notes | Access standardized Credit notes from linked accounting software. |
    | Customers | Access standardized Customers from linked accounting software. |
    | Direct costs | Access standardized Direct costs from linked accounting software. |
    | Direct incomes | Access standardized Direct incomes from linked accounting software. |
    | Company info | Access standardized Company info from linked accounting software. |
    | Invoices | Access standardized Invoices from linked accounting software. |
    | Item receipts | Access standardized Item receipts from linked accounting software. |
    | Items | Access standardized Items from linked accounting software. |
    | Journals | Access standardized Journals from linked accounting software. |
    | Journal entries | Access standardized Journal entries from linked accounting software. |
    | Payments | Access standardized Payments from linked accounting software. |
    | Payment methods | Access standardized Payment methods from linked accounting software. |
    | Purchase orders | Access standardized Purchase orders from linked accounting software. |
    | Sales orders | Access standardized Sales orders from linked accounting software. |
    | Suppliers | Access standardized Suppliers from linked accounting software. |
    | Tax rates | Access standardized Tax rates from linked accounting software. |
    | Tracking categories | Access standardized Tracking categories from linked accounting software. |
    | Transfers | Access standardized Transfers from linked accounting software. |
    | Reports | Access standardized Reports from linked accounting software. |
    <!-- End Codat Tags Table -->

    [Read more...](https://docs.codat.io/accounting-api/overview)

    [See our OpenAPI spec](https://github.com/codatio/oas)
    """

    account_transactions: AccountTransactions
    r"""Access standardized Account transactions from linked accounting software."""
    bank_accounts: BankAccounts
    r"""Access standardized Bank accounts from linked accounting software."""
    bank_account_transactions: BankAccountTransactions
    r"""Access standardized Bank transactions for bank accounts from linked accounting software."""
    bills: Bills
    r"""Access standardized Bills from linked accounting software."""
    customers: Customers
    r"""Access standardized Customers from linked accounting software."""
    direct_costs: DirectCosts
    r"""Access standardized Direct costs from linked accounting software."""
    direct_incomes: DirectIncomes
    r"""Access standardized Direct incomes from linked accounting software."""
    invoices: Invoices
    r"""Access standardized Invoices from linked accounting software."""
    item_receipts: ItemReceipts
    r"""Access standardized Item receipts from linked accounting software."""
    payments: Payments
    r"""Access standardized Payments from linked accounting software."""
    purchase_orders: PurchaseOrders
    r"""Access standardized Purchase orders from linked accounting software."""
    suppliers: Suppliers
    r"""Access standardized Suppliers from linked accounting software."""
    transfers: Transfers
    r"""Access standardized Transfers from linked accounting software."""
    bill_credit_notes: BillCreditNotes
    r"""Access standardized Bill credit notes from linked accounting software."""
    bill_payments: BillPayments
    r"""Access standardized Bill payments from linked accounting software."""
    accounts: Accounts
    r"""Access standardized Accounts from linked accounting software."""
    credit_notes: CreditNotes
    r"""Access standardized Credit notes from linked accounting software."""
    items: Items
    r"""Access standardized Items from linked accounting software."""
    journal_entries: JournalEntries
    r"""Access standardized Journal entries from linked accounting software."""
    journals: Journals
    r"""Access standardized Journals from linked accounting software."""
    reports: Reports
    r"""Access standardized Reports from linked accounting software."""
    company_info: CompanyInfo
    r"""Access standardized Company info from linked accounting software."""
    payment_methods: PaymentMethods
    r"""Access standardized Payment methods from linked accounting software."""
    sales_orders: SalesOrders
    r"""Access standardized Sales orders from linked accounting software."""
    tax_rates: TaxRates
    r"""Access standardized Tax rates from linked accounting software."""
    tracking_categories: TrackingCategories
    r"""Access standardized Tracking categories from linked accounting software."""

    def __init__(
        self,
        security: Union[shared.Security, Callable[[], shared.Security]],
        server_idx: Optional[int] = None,
        server_url: Optional[str] = None,
        url_params: Optional[Dict[str, str]] = None,
        client: Optional[HttpClient] = None,
        async_client: Optional[AsyncHttpClient] = None,
        retry_config: OptionalNullable[RetryConfig] = UNSET,
        timeout_ms: Optional[int] = None,
        debug_logger: Optional[Logger] = None,
    ) -> None:
        r"""Instantiates the SDK configuring it with the provided parameters.

        :param security: The security details required for authentication
        :param server_idx: The index of the server to use for all methods
        :param server_url: The server URL to use for all methods
        :param url_params: Parameters to optionally template the server URL with
        :param client: The HTTP client to use for all synchronous methods
        :param async_client: The Async HTTP client to use for all asynchronous methods
        :param retry_config: The retry configuration to use for all supported methods
        :param timeout_ms: Optional request timeout applied to each operation in milliseconds
        """
        if client is None:
            client = httpx.Client()

        assert issubclass(
            type(client), HttpClient
        ), "The provided client must implement the HttpClient protocol."

        if async_client is None:
            async_client = httpx.AsyncClient()

        if debug_logger is None:
            debug_logger = get_default_logger()

        assert issubclass(
            type(async_client), AsyncHttpClient
        ), "The provided async_client must implement the AsyncHttpClient protocol."

        if server_url is not None:
            if url_params is not None:
                server_url = utils.template_url(server_url, url_params)

        BaseSDK.__init__(
            self,
            SDKConfiguration(
                client=client,
                async_client=async_client,
                security=security,
                server_url=server_url,
                server_idx=server_idx,
                retry_config=retry_config,
                timeout_ms=timeout_ms,
                debug_logger=debug_logger,
            ),
        )

        hooks = SDKHooks()

        current_server_url, *_ = self.sdk_configuration.get_server_details()
        server_url, self.sdk_configuration.client = hooks.sdk_init(
            current_server_url, self.sdk_configuration.client
        )
        if current_server_url != server_url:
            self.sdk_configuration.server_url = server_url

        # pylint: disable=protected-access
        self.sdk_configuration.__dict__["_hooks"] = hooks

        self._init_sdks()

    def _init_sdks(self):
        self.account_transactions = AccountTransactions(self.sdk_configuration)
        self.bank_accounts = BankAccounts(self.sdk_configuration)
        self.bank_account_transactions = BankAccountTransactions(self.sdk_configuration)
        self.bills = Bills(self.sdk_configuration)
        self.customers = Customers(self.sdk_configuration)
        self.direct_costs = DirectCosts(self.sdk_configuration)
        self.direct_incomes = DirectIncomes(self.sdk_configuration)
        self.invoices = Invoices(self.sdk_configuration)
        self.item_receipts = ItemReceipts(self.sdk_configuration)
        self.payments = Payments(self.sdk_configuration)
        self.purchase_orders = PurchaseOrders(self.sdk_configuration)
        self.suppliers = Suppliers(self.sdk_configuration)
        self.transfers = Transfers(self.sdk_configuration)
        self.bill_credit_notes = BillCreditNotes(self.sdk_configuration)
        self.bill_payments = BillPayments(self.sdk_configuration)
        self.accounts = Accounts(self.sdk_configuration)
        self.credit_notes = CreditNotes(self.sdk_configuration)
        self.items = Items(self.sdk_configuration)
        self.journal_entries = JournalEntries(self.sdk_configuration)
        self.journals = Journals(self.sdk_configuration)
        self.reports = Reports(self.sdk_configuration)
        self.company_info = CompanyInfo(self.sdk_configuration)
        self.payment_methods = PaymentMethods(self.sdk_configuration)
        self.sales_orders = SalesOrders(self.sdk_configuration)
        self.tax_rates = TaxRates(self.sdk_configuration)
        self.tracking_categories = TrackingCategories(self.sdk_configuration)
