# coding: utf-8

"""
    Bacalhau API

    This page is the reference of the Bacalhau REST API. Project docs are available at https://docs.bacalhau.org/. Find more information about Bacalhau at https://github.com/bacalhau-project/bacalhau.  # noqa: E501

    OpenAPI spec version: ${VERSION}
    Contact: team@bacalhau.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from bacalhau_apiclient.api_client import ApiClient


class OrchestratorApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def orchestratorget_job(self, id, **kwargs):  # noqa: E501
        """Returns a job.  # noqa: E501

        Returns a job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orchestratorget_job(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: ID to get the job for (required)
        :param str include: Takes history and executions as options. If empty will not include anything else.
        :param int limit: Number of history or exeuctions to fetch. Should be used in conjugation with include
        :return: ApiGetJobResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orchestratorget_job_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.orchestratorget_job_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def orchestratorget_job_with_http_info(self, id, **kwargs):  # noqa: E501
        """Returns a job.  # noqa: E501

        Returns a job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orchestratorget_job_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: ID to get the job for (required)
        :param str include: Takes history and executions as options. If empty will not include anything else.
        :param int limit: Number of history or exeuctions to fetch. Should be used in conjugation with include
        :return: ApiGetJobResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'include', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orchestratorget_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `orchestratorget_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/orchestrator/jobs/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiGetJobResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orchestratorget_node(self, id, **kwargs):  # noqa: E501
        """Get an orchestrator node  # noqa: E501

        Get an orchestrator node  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orchestratorget_node(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: ID of the orchestrator node to fetch for. (required)
        :return: ApiGetNodeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orchestratorget_node_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.orchestratorget_node_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def orchestratorget_node_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get an orchestrator node  # noqa: E501

        Get an orchestrator node  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orchestratorget_node_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: ID of the orchestrator node to fetch for. (required)
        :return: ApiGetNodeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orchestratorget_node" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `orchestratorget_node`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/orchestrator/nodes/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiGetNodeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orchestratorjob_executions(self, id, order_by, **kwargs):  # noqa: E501
        """Returns the executions of a job.  # noqa: E501

        Returns the executions of a job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orchestratorjob_executions(id, order_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: ID to get the job executions for (required)
        :param str order_by: Order the executions by the given field (required)
        :param str namespace: Namespace to get the jobs for
        :param int limit: Limit the number of executions returned
        :param str next_token: Token to get the next page of executions
        :param bool reverse: Reverse the order of the executions
        :return: ApiListJobExecutionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orchestratorjob_executions_with_http_info(id, order_by, **kwargs)  # noqa: E501
        else:
            (data) = self.orchestratorjob_executions_with_http_info(id, order_by, **kwargs)  # noqa: E501
            return data

    def orchestratorjob_executions_with_http_info(self, id, order_by, **kwargs):  # noqa: E501
        """Returns the executions of a job.  # noqa: E501

        Returns the executions of a job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orchestratorjob_executions_with_http_info(id, order_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: ID to get the job executions for (required)
        :param str order_by: Order the executions by the given field (required)
        :param str namespace: Namespace to get the jobs for
        :param int limit: Limit the number of executions returned
        :param str next_token: Token to get the next page of executions
        :param bool reverse: Reverse the order of the executions
        :return: ApiListJobExecutionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'order_by', 'namespace', 'limit', 'next_token', 'reverse']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orchestratorjob_executions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `orchestratorjob_executions`")  # noqa: E501
        # verify the required parameter 'order_by' is set
        if ('order_by' not in params or
                params['order_by'] is None):
            raise ValueError("Missing the required parameter `order_by` when calling `orchestratorjob_executions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'namespace' in params:
            query_params.append(('namespace', params['namespace']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'next_token' in params:
            query_params.append(('next_token', params['next_token']))  # noqa: E501
        if 'reverse' in params:
            query_params.append(('reverse', params['reverse']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/orchestrator/jobs/{id}/executions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiListJobExecutionsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orchestratorjob_history(self, id, **kwargs):  # noqa: E501
        """Returns the history of a job.  # noqa: E501

        Returns the history of a job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orchestratorjob_history(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: ID to get the job history for (required)
        :param str since: Only return history since this time
        :param str event_type: Only return history of this event type
        :param str execution_id: Only return history of this execution ID
        :param str node_id: Only return history of this node ID
        :return: ApiListJobHistoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orchestratorjob_history_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.orchestratorjob_history_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def orchestratorjob_history_with_http_info(self, id, **kwargs):  # noqa: E501
        """Returns the history of a job.  # noqa: E501

        Returns the history of a job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orchestratorjob_history_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: ID to get the job history for (required)
        :param str since: Only return history since this time
        :param str event_type: Only return history of this event type
        :param str execution_id: Only return history of this execution ID
        :param str node_id: Only return history of this node ID
        :return: ApiListJobHistoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'since', 'event_type', 'execution_id', 'node_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orchestratorjob_history" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `orchestratorjob_history`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'since' in params:
            query_params.append(('since', params['since']))  # noqa: E501
        if 'event_type' in params:
            query_params.append(('event_type', params['event_type']))  # noqa: E501
        if 'execution_id' in params:
            query_params.append(('execution_id', params['execution_id']))  # noqa: E501
        if 'node_id' in params:
            query_params.append(('node_id', params['node_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/orchestrator/jobs/{id}/history', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiListJobHistoryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orchestratorjob_results(self, id, **kwargs):  # noqa: E501
        """Returns the results of a job.  # noqa: E501

        Returns the results of a job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orchestratorjob_results(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: ID to get the job results for (required)
        :return: ApiListJobResultsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orchestratorjob_results_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.orchestratorjob_results_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def orchestratorjob_results_with_http_info(self, id, **kwargs):  # noqa: E501
        """Returns the results of a job.  # noqa: E501

        Returns the results of a job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orchestratorjob_results_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: ID to get the job results for (required)
        :return: ApiListJobResultsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orchestratorjob_results" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `orchestratorjob_results`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/orchestrator/jobs/{id}/results', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiListJobResultsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orchestratorlist_jobs(self, **kwargs):  # noqa: E501
        """Returns a list of jobs.  # noqa: E501

        Returns a list of jobs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orchestratorlist_jobs(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: Namespace to get the jobs for
        :param int limit: Limit the number of jobs returned
        :param str next_token: Token to get the next page of jobs
        :param bool reverse: Reverse the order of the jobs
        :param str order_by: Order the jobs by the given field
        :return: ApiListJobsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orchestratorlist_jobs_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.orchestratorlist_jobs_with_http_info(**kwargs)  # noqa: E501
            return data

    def orchestratorlist_jobs_with_http_info(self, **kwargs):  # noqa: E501
        """Returns a list of jobs.  # noqa: E501

        Returns a list of jobs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orchestratorlist_jobs_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: Namespace to get the jobs for
        :param int limit: Limit the number of jobs returned
        :param str next_token: Token to get the next page of jobs
        :param bool reverse: Reverse the order of the jobs
        :param str order_by: Order the jobs by the given field
        :return: ApiListJobsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace', 'limit', 'next_token', 'reverse', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orchestratorlist_jobs" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'namespace' in params:
            query_params.append(('namespace', params['namespace']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'next_token' in params:
            query_params.append(('next_token', params['next_token']))  # noqa: E501
        if 'reverse' in params:
            query_params.append(('reverse', params['reverse']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/orchestrator/jobs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiListJobsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orchestratorlist_nodes(self, **kwargs):  # noqa: E501
        """Returns a list of orchestrator nodes.  # noqa: E501

        Returns a list of orchestrator nodes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orchestratorlist_nodes(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Limit the number of node returned
        :param str next_token: Token to get the next page of nodes
        :param bool reverse: Reverse the order of the nodes
        :param str order_by: Order the nodes by given field
        :param str filter_approval: Filter Approval
        :param str filter_status: Filter Status
        :return: ApiListNodesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orchestratorlist_nodes_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.orchestratorlist_nodes_with_http_info(**kwargs)  # noqa: E501
            return data

    def orchestratorlist_nodes_with_http_info(self, **kwargs):  # noqa: E501
        """Returns a list of orchestrator nodes.  # noqa: E501

        Returns a list of orchestrator nodes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orchestratorlist_nodes_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Limit the number of node returned
        :param str next_token: Token to get the next page of nodes
        :param bool reverse: Reverse the order of the nodes
        :param str order_by: Order the nodes by given field
        :param str filter_approval: Filter Approval
        :param str filter_status: Filter Status
        :return: ApiListNodesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'next_token', 'reverse', 'order_by', 'filter_approval', 'filter_status']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orchestratorlist_nodes" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'next_token' in params:
            query_params.append(('next_token', params['next_token']))  # noqa: E501
        if 'reverse' in params:
            query_params.append(('reverse', params['reverse']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'filter_approval' in params:
            query_params.append(('filter_approval', params['filter_approval']))  # noqa: E501
        if 'filter_status' in params:
            query_params.append(('filter-status', params['filter_status']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/orchestrator/nodes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiListNodesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orchestratorlogs(self, id, **kwargs):  # noqa: E501
        """Displays the logs for a current job/execution  # noqa: E501

        Shows the output from the job specified by `id` The output will be continuous until either, the client disconnects or the execution completes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orchestratorlogs(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: ID to get the job logs for (required)
        :param str execution_id: Fetch logs for a specific execution
        :param bool tail: Fetch historical logs
        :param bool follow: Follow the logs
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orchestratorlogs_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.orchestratorlogs_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def orchestratorlogs_with_http_info(self, id, **kwargs):  # noqa: E501
        """Displays the logs for a current job/execution  # noqa: E501

        Shows the output from the job specified by `id` The output will be continuous until either, the client disconnects or the execution completes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orchestratorlogs_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: ID to get the job logs for (required)
        :param str execution_id: Fetch logs for a specific execution
        :param bool tail: Fetch historical logs
        :param bool follow: Follow the logs
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'execution_id', 'tail', 'follow']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orchestratorlogs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `orchestratorlogs`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'execution_id' in params:
            query_params.append(('execution_id', params['execution_id']))  # noqa: E501
        if 'tail' in params:
            query_params.append(('tail', params['tail']))  # noqa: E501
        if 'follow' in params:
            query_params.append(('follow', params['follow']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/orchestrator/jobs/{id}/logs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orchestratorput_job(self, body, **kwargs):  # noqa: E501
        """Submits a job to the orchestrator.  # noqa: E501

        Submits a job to the orchestrator.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orchestratorput_job(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ApiPutJobRequest body: Job to submit (required)
        :return: ApiPutJobResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orchestratorput_job_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.orchestratorput_job_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def orchestratorput_job_with_http_info(self, body, **kwargs):  # noqa: E501
        """Submits a job to the orchestrator.  # noqa: E501

        Submits a job to the orchestrator.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orchestratorput_job_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ApiPutJobRequest body: Job to submit (required)
        :return: ApiPutJobResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orchestratorput_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `orchestratorput_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/orchestrator/jobs', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiPutJobResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orchestratorstop_job(self, id, **kwargs):  # noqa: E501
        """Stops a job.  # noqa: E501

        Stops a job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orchestratorstop_job(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: ID to stop the job for (required)
        :param str reason: Reason for stopping the job
        :return: ApiStopJobResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orchestratorstop_job_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.orchestratorstop_job_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def orchestratorstop_job_with_http_info(self, id, **kwargs):  # noqa: E501
        """Stops a job.  # noqa: E501

        Stops a job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orchestratorstop_job_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: ID to stop the job for (required)
        :param str reason: Reason for stopping the job
        :return: ApiStopJobResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'reason']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orchestratorstop_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `orchestratorstop_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'reason' in params:
            query_params.append(('reason', params['reason']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/orchestrator/jobs/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiStopJobResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orchestratorupdate_node(self, body, id, **kwargs):  # noqa: E501
        """Update an orchestrator node.  # noqa: E501

        Update an orchestrator node.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orchestratorupdate_node(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ApiPutNodeRequest body: Put Node Request (required)
        :param str id: ID of the orchestrator node. (required)
        :return: ApiPutNodeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orchestratorupdate_node_with_http_info(body, id, **kwargs)  # noqa: E501
        else:
            (data) = self.orchestratorupdate_node_with_http_info(body, id, **kwargs)  # noqa: E501
            return data

    def orchestratorupdate_node_with_http_info(self, body, id, **kwargs):  # noqa: E501
        """Update an orchestrator node.  # noqa: E501

        Update an orchestrator node.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orchestratorupdate_node_with_http_info(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ApiPutNodeRequest body: Put Node Request (required)
        :param str id: ID of the orchestrator node. (required)
        :return: ApiPutNodeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orchestratorupdate_node" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `orchestratorupdate_node`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `orchestratorupdate_node`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/orchestrator/nodes', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiPutNodeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
