# coding: utf-8

"""
    Bacalhau API

    This page is the reference of the Bacalhau REST API. Project docs are available at https://docs.bacalhau.org/. Find more information about Bacalhau at https://github.com/bacalhau-project/bacalhau.  # noqa: E501

    OpenAPI spec version: ${VERSION}
    Contact: team@bacalhau.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ApiHTTPCredential(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'params': 'dict(str, str)',
        'scheme': 'str',
        'value': 'str'
    }

    attribute_map = {
        'params': 'params',
        'scheme': 'scheme',
        'value': 'value'
    }

    def __init__(self, params=None, scheme=None, value=None):  # noqa: E501
        """ApiHTTPCredential - a model defined in Swagger"""  # noqa: E501
        self._params = None
        self._scheme = None
        self._value = None
        self.discriminator = None
        if params is not None:
            self.params = params
        if scheme is not None:
            self.scheme = scheme
        if value is not None:
            self.value = value

    @property
    def params(self):
        """Gets the params of this ApiHTTPCredential.  # noqa: E501

        For authorization schemes that provide multiple values, a map of names to values providing the credential  # noqa: E501

        :return: The params of this ApiHTTPCredential.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._params

    @params.setter
    def params(self, params):
        """Sets the params of this ApiHTTPCredential.

        For authorization schemes that provide multiple values, a map of names to values providing the credential  # noqa: E501

        :param params: The params of this ApiHTTPCredential.  # noqa: E501
        :type: dict(str, str)
        """

        self._params = params

    @property
    def scheme(self):
        """Gets the scheme of this ApiHTTPCredential.  # noqa: E501

        An HTTP authorization scheme, such as one registered with IANA https://www.iana.org/assignments/http-authschemes/http-authschemes.xhtml  # noqa: E501

        :return: The scheme of this ApiHTTPCredential.  # noqa: E501
        :rtype: str
        """
        return self._scheme

    @scheme.setter
    def scheme(self, scheme):
        """Sets the scheme of this ApiHTTPCredential.

        An HTTP authorization scheme, such as one registered with IANA https://www.iana.org/assignments/http-authschemes/http-authschemes.xhtml  # noqa: E501

        :param scheme: The scheme of this ApiHTTPCredential.  # noqa: E501
        :type: str
        """

        self._scheme = scheme

    @property
    def value(self):
        """Gets the value of this ApiHTTPCredential.  # noqa: E501

        For authorization schemes that only provide a single value, such as Basic, the single string value providing the credential  # noqa: E501

        :return: The value of this ApiHTTPCredential.  # noqa: E501
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """Sets the value of this ApiHTTPCredential.

        For authorization schemes that only provide a single value, such as Basic, the single string value providing the credential  # noqa: E501

        :param value: The value of this ApiHTTPCredential.  # noqa: E501
        :type: str
        """

        self._value = value

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ApiHTTPCredential, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ApiHTTPCredential):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
