# coding: utf-8

"""
    Bacalhau API

    This page is the reference of the Bacalhau REST API. Project docs are available at https://docs.bacalhau.org/. Find more information about Bacalhau at https://github.com/bacalhau-project/bacalhau.  # noqa: E501

    OpenAPI spec version: ${VERSION}
    Contact: team@bacalhau.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class Execution(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'allocated_resources': 'AllOfExecutionAllocatedResources',
        'compute_state': 'AllOfExecutionComputeState',
        'create_time': 'int',
        'desired_state': 'AllOfExecutionDesiredState',
        'eval_id': 'str',
        'followup_eval_id': 'str',
        'id': 'str',
        'job': 'AllOfExecutionJob',
        'job_id': 'str',
        'modify_time': 'int',
        'name': 'str',
        'namespace': 'str',
        'next_execution': 'str',
        'node_id': 'str',
        'previous_execution': 'str',
        'published_result': 'AllOfExecutionPublishedResult',
        'revision': 'int',
        'run_output': 'AllOfExecutionRunOutput'
    }

    attribute_map = {
        'allocated_resources': 'AllocatedResources',
        'compute_state': 'ComputeState',
        'create_time': 'CreateTime',
        'desired_state': 'DesiredState',
        'eval_id': 'EvalID',
        'followup_eval_id': 'FollowupEvalID',
        'id': 'ID',
        'job': 'Job',
        'job_id': 'JobID',
        'modify_time': 'ModifyTime',
        'name': 'Name',
        'namespace': 'Namespace',
        'next_execution': 'NextExecution',
        'node_id': 'NodeID',
        'previous_execution': 'PreviousExecution',
        'published_result': 'PublishedResult',
        'revision': 'Revision',
        'run_output': 'RunOutput'
    }

    def __init__(self, allocated_resources=None, compute_state=None, create_time=None, desired_state=None, eval_id=None, followup_eval_id=None, id=None, job=None, job_id=None, modify_time=None, name=None, namespace=None, next_execution=None, node_id=None, previous_execution=None, published_result=None, revision=None, run_output=None):  # noqa: E501
        """Execution - a model defined in Swagger"""  # noqa: E501
        self._allocated_resources = None
        self._compute_state = None
        self._create_time = None
        self._desired_state = None
        self._eval_id = None
        self._followup_eval_id = None
        self._id = None
        self._job = None
        self._job_id = None
        self._modify_time = None
        self._name = None
        self._namespace = None
        self._next_execution = None
        self._node_id = None
        self._previous_execution = None
        self._published_result = None
        self._revision = None
        self._run_output = None
        self.discriminator = None
        if allocated_resources is not None:
            self.allocated_resources = allocated_resources
        if compute_state is not None:
            self.compute_state = compute_state
        if create_time is not None:
            self.create_time = create_time
        if desired_state is not None:
            self.desired_state = desired_state
        if eval_id is not None:
            self.eval_id = eval_id
        if followup_eval_id is not None:
            self.followup_eval_id = followup_eval_id
        if id is not None:
            self.id = id
        if job is not None:
            self.job = job
        if job_id is not None:
            self.job_id = job_id
        if modify_time is not None:
            self.modify_time = modify_time
        if name is not None:
            self.name = name
        if namespace is not None:
            self.namespace = namespace
        if next_execution is not None:
            self.next_execution = next_execution
        if node_id is not None:
            self.node_id = node_id
        if previous_execution is not None:
            self.previous_execution = previous_execution
        if published_result is not None:
            self.published_result = published_result
        if revision is not None:
            self.revision = revision
        if run_output is not None:
            self.run_output = run_output

    @property
    def allocated_resources(self):
        """Gets the allocated_resources of this Execution.  # noqa: E501

        AllocatedResources is the total resources allocated for the execution tasks.  # noqa: E501

        :return: The allocated_resources of this Execution.  # noqa: E501
        :rtype: AllOfExecutionAllocatedResources
        """
        return self._allocated_resources

    @allocated_resources.setter
    def allocated_resources(self, allocated_resources):
        """Sets the allocated_resources of this Execution.

        AllocatedResources is the total resources allocated for the execution tasks.  # noqa: E501

        :param allocated_resources: The allocated_resources of this Execution.  # noqa: E501
        :type: AllOfExecutionAllocatedResources
        """

        self._allocated_resources = allocated_resources

    @property
    def compute_state(self):
        """Gets the compute_state of this Execution.  # noqa: E501

        ComputeState observed state of the execution on the compute node  # noqa: E501

        :return: The compute_state of this Execution.  # noqa: E501
        :rtype: AllOfExecutionComputeState
        """
        return self._compute_state

    @compute_state.setter
    def compute_state(self, compute_state):
        """Sets the compute_state of this Execution.

        ComputeState observed state of the execution on the compute node  # noqa: E501

        :param compute_state: The compute_state of this Execution.  # noqa: E501
        :type: AllOfExecutionComputeState
        """

        self._compute_state = compute_state

    @property
    def create_time(self):
        """Gets the create_time of this Execution.  # noqa: E501

        CreateTime is the time the execution has finished scheduling and been verified by the plan applier.  # noqa: E501

        :return: The create_time of this Execution.  # noqa: E501
        :rtype: int
        """
        return self._create_time

    @create_time.setter
    def create_time(self, create_time):
        """Sets the create_time of this Execution.

        CreateTime is the time the execution has finished scheduling and been verified by the plan applier.  # noqa: E501

        :param create_time: The create_time of this Execution.  # noqa: E501
        :type: int
        """

        self._create_time = create_time

    @property
    def desired_state(self):
        """Gets the desired_state of this Execution.  # noqa: E501

        DesiredState of the execution on the compute node  # noqa: E501

        :return: The desired_state of this Execution.  # noqa: E501
        :rtype: AllOfExecutionDesiredState
        """
        return self._desired_state

    @desired_state.setter
    def desired_state(self, desired_state):
        """Sets the desired_state of this Execution.

        DesiredState of the execution on the compute node  # noqa: E501

        :param desired_state: The desired_state of this Execution.  # noqa: E501
        :type: AllOfExecutionDesiredState
        """

        self._desired_state = desired_state

    @property
    def eval_id(self):
        """Gets the eval_id of this Execution.  # noqa: E501

        ID of the evaluation that generated this execution  # noqa: E501

        :return: The eval_id of this Execution.  # noqa: E501
        :rtype: str
        """
        return self._eval_id

    @eval_id.setter
    def eval_id(self, eval_id):
        """Sets the eval_id of this Execution.

        ID of the evaluation that generated this execution  # noqa: E501

        :param eval_id: The eval_id of this Execution.  # noqa: E501
        :type: str
        """

        self._eval_id = eval_id

    @property
    def followup_eval_id(self):
        """Gets the followup_eval_id of this Execution.  # noqa: E501

        FollowupEvalID captures a follow up evaluation created to handle a failed execution that can be rescheduled in the future  # noqa: E501

        :return: The followup_eval_id of this Execution.  # noqa: E501
        :rtype: str
        """
        return self._followup_eval_id

    @followup_eval_id.setter
    def followup_eval_id(self, followup_eval_id):
        """Sets the followup_eval_id of this Execution.

        FollowupEvalID captures a follow up evaluation created to handle a failed execution that can be rescheduled in the future  # noqa: E501

        :param followup_eval_id: The followup_eval_id of this Execution.  # noqa: E501
        :type: str
        """

        self._followup_eval_id = followup_eval_id

    @property
    def id(self):
        """Gets the id of this Execution.  # noqa: E501

        ID of the execution (UUID)  # noqa: E501

        :return: The id of this Execution.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Execution.

        ID of the execution (UUID)  # noqa: E501

        :param id: The id of this Execution.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def job(self):
        """Gets the job of this Execution.  # noqa: E501

        TODO: evaluate using a copy of the job instead of a pointer  # noqa: E501

        :return: The job of this Execution.  # noqa: E501
        :rtype: AllOfExecutionJob
        """
        return self._job

    @job.setter
    def job(self, job):
        """Sets the job of this Execution.

        TODO: evaluate using a copy of the job instead of a pointer  # noqa: E501

        :param job: The job of this Execution.  # noqa: E501
        :type: AllOfExecutionJob
        """

        self._job = job

    @property
    def job_id(self):
        """Gets the job_id of this Execution.  # noqa: E501

        Job is the parent job of the task being allocated. This is copied at execution time to avoid issues if the job definition is updated.  # noqa: E501

        :return: The job_id of this Execution.  # noqa: E501
        :rtype: str
        """
        return self._job_id

    @job_id.setter
    def job_id(self, job_id):
        """Sets the job_id of this Execution.

        Job is the parent job of the task being allocated. This is copied at execution time to avoid issues if the job definition is updated.  # noqa: E501

        :param job_id: The job_id of this Execution.  # noqa: E501
        :type: str
        """

        self._job_id = job_id

    @property
    def modify_time(self):
        """Gets the modify_time of this Execution.  # noqa: E501

        ModifyTime is the time the execution was last updated.  # noqa: E501

        :return: The modify_time of this Execution.  # noqa: E501
        :rtype: int
        """
        return self._modify_time

    @modify_time.setter
    def modify_time(self, modify_time):
        """Sets the modify_time of this Execution.

        ModifyTime is the time the execution was last updated.  # noqa: E501

        :param modify_time: The modify_time of this Execution.  # noqa: E501
        :type: int
        """

        self._modify_time = modify_time

    @property
    def name(self):
        """Gets the name of this Execution.  # noqa: E501

        Name is a logical name of the execution.  # noqa: E501

        :return: The name of this Execution.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Execution.

        Name is a logical name of the execution.  # noqa: E501

        :param name: The name of this Execution.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def namespace(self):
        """Gets the namespace of this Execution.  # noqa: E501

        Namespace is the namespace the execution is created in  # noqa: E501

        :return: The namespace of this Execution.  # noqa: E501
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """Sets the namespace of this Execution.

        Namespace is the namespace the execution is created in  # noqa: E501

        :param namespace: The namespace of this Execution.  # noqa: E501
        :type: str
        """

        self._namespace = namespace

    @property
    def next_execution(self):
        """Gets the next_execution of this Execution.  # noqa: E501

        NextExecution is the execution that this execution is being replaced by  # noqa: E501

        :return: The next_execution of this Execution.  # noqa: E501
        :rtype: str
        """
        return self._next_execution

    @next_execution.setter
    def next_execution(self, next_execution):
        """Sets the next_execution of this Execution.

        NextExecution is the execution that this execution is being replaced by  # noqa: E501

        :param next_execution: The next_execution of this Execution.  # noqa: E501
        :type: str
        """

        self._next_execution = next_execution

    @property
    def node_id(self):
        """Gets the node_id of this Execution.  # noqa: E501

        NodeID is the node this is being placed on  # noqa: E501

        :return: The node_id of this Execution.  # noqa: E501
        :rtype: str
        """
        return self._node_id

    @node_id.setter
    def node_id(self, node_id):
        """Sets the node_id of this Execution.

        NodeID is the node this is being placed on  # noqa: E501

        :param node_id: The node_id of this Execution.  # noqa: E501
        :type: str
        """

        self._node_id = node_id

    @property
    def previous_execution(self):
        """Gets the previous_execution of this Execution.  # noqa: E501

        PreviousExecution is the execution that this execution is replacing  # noqa: E501

        :return: The previous_execution of this Execution.  # noqa: E501
        :rtype: str
        """
        return self._previous_execution

    @previous_execution.setter
    def previous_execution(self, previous_execution):
        """Sets the previous_execution of this Execution.

        PreviousExecution is the execution that this execution is replacing  # noqa: E501

        :param previous_execution: The previous_execution of this Execution.  # noqa: E501
        :type: str
        """

        self._previous_execution = previous_execution

    @property
    def published_result(self):
        """Gets the published_result of this Execution.  # noqa: E501

        the published results for this execution  # noqa: E501

        :return: The published_result of this Execution.  # noqa: E501
        :rtype: AllOfExecutionPublishedResult
        """
        return self._published_result

    @published_result.setter
    def published_result(self, published_result):
        """Sets the published_result of this Execution.

        the published results for this execution  # noqa: E501

        :param published_result: The published_result of this Execution.  # noqa: E501
        :type: AllOfExecutionPublishedResult
        """

        self._published_result = published_result

    @property
    def revision(self):
        """Gets the revision of this Execution.  # noqa: E501

        Revision is increment each time the execution is updated.  # noqa: E501

        :return: The revision of this Execution.  # noqa: E501
        :rtype: int
        """
        return self._revision

    @revision.setter
    def revision(self, revision):
        """Sets the revision of this Execution.

        Revision is increment each time the execution is updated.  # noqa: E501

        :param revision: The revision of this Execution.  # noqa: E501
        :type: int
        """

        self._revision = revision

    @property
    def run_output(self):
        """Gets the run_output of this Execution.  # noqa: E501

        RunOutput is the output of the run command TODO: evaluate removing this from execution spec in favour of calling `bacalhau logs`  # noqa: E501

        :return: The run_output of this Execution.  # noqa: E501
        :rtype: AllOfExecutionRunOutput
        """
        return self._run_output

    @run_output.setter
    def run_output(self, run_output):
        """Sets the run_output of this Execution.

        RunOutput is the output of the run command TODO: evaluate removing this from execution spec in favour of calling `bacalhau logs`  # noqa: E501

        :param run_output: The run_output of this Execution.  # noqa: E501
        :type: AllOfExecutionRunOutput
        """

        self._run_output = run_output

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Execution, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Execution):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
