# coding: utf-8

"""
    Bacalhau API

    This page is the reference of the Bacalhau REST API. Project docs are available at https://docs.bacalhau.org/. Find more information about Bacalhau at https://github.com/bacalhau-project/bacalhau.  # noqa: E501

    OpenAPI spec version: ${VERSION}
    Contact: team@bacalhau.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class GPU(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'index': 'int',
        'memory': 'int',
        'name': 'str',
        'pciaddress': 'str',
        'vendor': 'AllOfGPUVendor'
    }

    attribute_map = {
        'index': 'index',
        'memory': 'memory',
        'name': 'name',
        'pciaddress': 'pciaddress',
        'vendor': 'vendor'
    }

    def __init__(self, index=None, memory=None, name=None, pciaddress=None, vendor=None):  # noqa: E501
        """GPU - a model defined in Swagger"""  # noqa: E501
        self._index = None
        self._memory = None
        self._name = None
        self._pciaddress = None
        self._vendor = None
        self.discriminator = None
        if index is not None:
            self.index = index
        if memory is not None:
            self.memory = memory
        if name is not None:
            self.name = name
        if pciaddress is not None:
            self.pciaddress = pciaddress
        if vendor is not None:
            self.vendor = vendor

    @property
    def index(self):
        """Gets the index of this GPU.  # noqa: E501

        Self-reported index of the device in the system  # noqa: E501

        :return: The index of this GPU.  # noqa: E501
        :rtype: int
        """
        return self._index

    @index.setter
    def index(self, index):
        """Sets the index of this GPU.

        Self-reported index of the device in the system  # noqa: E501

        :param index: The index of this GPU.  # noqa: E501
        :type: int
        """

        self._index = index

    @property
    def memory(self):
        """Gets the memory of this GPU.  # noqa: E501

        Total GPU memory in mebibytes (MiB)  # noqa: E501

        :return: The memory of this GPU.  # noqa: E501
        :rtype: int
        """
        return self._memory

    @memory.setter
    def memory(self, memory):
        """Sets the memory of this GPU.

        Total GPU memory in mebibytes (MiB)  # noqa: E501

        :param memory: The memory of this GPU.  # noqa: E501
        :type: int
        """

        self._memory = memory

    @property
    def name(self):
        """Gets the name of this GPU.  # noqa: E501

        Model name of the GPU e.g. Tesla T4  # noqa: E501

        :return: The name of this GPU.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this GPU.

        Model name of the GPU e.g. Tesla T4  # noqa: E501

        :param name: The name of this GPU.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def pciaddress(self):
        """Gets the pciaddress of this GPU.  # noqa: E501

        PCI address of the device, in the format AAAA:BB:CC.C Used to discover the correct device rendering cards  # noqa: E501

        :return: The pciaddress of this GPU.  # noqa: E501
        :rtype: str
        """
        return self._pciaddress

    @pciaddress.setter
    def pciaddress(self, pciaddress):
        """Sets the pciaddress of this GPU.

        PCI address of the device, in the format AAAA:BB:CC.C Used to discover the correct device rendering cards  # noqa: E501

        :param pciaddress: The pciaddress of this GPU.  # noqa: E501
        :type: str
        """

        self._pciaddress = pciaddress

    @property
    def vendor(self):
        """Gets the vendor of this GPU.  # noqa: E501

        Maker of the GPU, e.g. NVidia, AMD, Intel  # noqa: E501

        :return: The vendor of this GPU.  # noqa: E501
        :rtype: AllOfGPUVendor
        """
        return self._vendor

    @vendor.setter
    def vendor(self, vendor):
        """Sets the vendor of this GPU.

        Maker of the GPU, e.g. NVidia, AMD, Intel  # noqa: E501

        :param vendor: The vendor of this GPU.  # noqa: E501
        :type: AllOfGPUVendor
        """

        self._vendor = vendor

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(GPU, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GPU):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
