# coding: utf-8

"""
    Bacalhau API

    This page is the reference of the Bacalhau REST API. Project docs are available at https://docs.bacalhau.org/. Find more information about Bacalhau at https://github.com/bacalhau-project/bacalhau.  # noqa: E501

    OpenAPI spec version: ${VERSION}
    Contact: team@bacalhau.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class Job(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'constraints': 'list[LabelSelectorRequirement]',
        'count': 'int',
        'create_time': 'int',
        'id': 'str',
        'labels': 'dict(str, str)',
        'meta': 'dict(str, str)',
        'modify_time': 'int',
        'name': 'str',
        'namespace': 'str',
        'priority': 'int',
        'revision': 'int',
        'state': 'AllOfJobState',
        'tasks': 'list[Task]',
        'type': 'str',
        'version': 'int'
    }

    attribute_map = {
        'constraints': 'Constraints',
        'count': 'Count',
        'create_time': 'CreateTime',
        'id': 'ID',
        'labels': 'Labels',
        'meta': 'Meta',
        'modify_time': 'ModifyTime',
        'name': 'Name',
        'namespace': 'Namespace',
        'priority': 'Priority',
        'revision': 'Revision',
        'state': 'State',
        'tasks': 'Tasks',
        'type': 'Type',
        'version': 'Version'
    }

    def __init__(self, constraints=None, count=None, create_time=None, id=None, labels=None, meta=None, modify_time=None, name=None, namespace=None, priority=None, revision=None, state=None, tasks=None, type=None, version=None):  # noqa: E501
        """Job - a model defined in Swagger"""  # noqa: E501
        self._constraints = None
        self._count = None
        self._create_time = None
        self._id = None
        self._labels = None
        self._meta = None
        self._modify_time = None
        self._name = None
        self._namespace = None
        self._priority = None
        self._revision = None
        self._state = None
        self._tasks = None
        self._type = None
        self._version = None
        self.discriminator = None
        if constraints is not None:
            self.constraints = constraints
        if count is not None:
            self.count = count
        if create_time is not None:
            self.create_time = create_time
        if id is not None:
            self.id = id
        if labels is not None:
            self.labels = labels
        if meta is not None:
            self.meta = meta
        if modify_time is not None:
            self.modify_time = modify_time
        if name is not None:
            self.name = name
        if namespace is not None:
            self.namespace = namespace
        if priority is not None:
            self.priority = priority
        if revision is not None:
            self.revision = revision
        if state is not None:
            self.state = state
        if tasks is not None:
            self.tasks = tasks
        if type is not None:
            self.type = type
        if version is not None:
            self.version = version

    @property
    def constraints(self):
        """Gets the constraints of this Job.  # noqa: E501

        Constraints is a selector which must be true for the compute node to run this job.  # noqa: E501

        :return: The constraints of this Job.  # noqa: E501
        :rtype: list[LabelSelectorRequirement]
        """
        return self._constraints

    @constraints.setter
    def constraints(self, constraints):
        """Sets the constraints of this Job.

        Constraints is a selector which must be true for the compute node to run this job.  # noqa: E501

        :param constraints: The constraints of this Job.  # noqa: E501
        :type: list[LabelSelectorRequirement]
        """

        self._constraints = constraints

    @property
    def count(self):
        """Gets the count of this Job.  # noqa: E501

        Count is the number of replicas that should be scheduled.  # noqa: E501

        :return: The count of this Job.  # noqa: E501
        :rtype: int
        """
        return self._count

    @count.setter
    def count(self, count):
        """Sets the count of this Job.

        Count is the number of replicas that should be scheduled.  # noqa: E501

        :param count: The count of this Job.  # noqa: E501
        :type: int
        """

        self._count = count

    @property
    def create_time(self):
        """Gets the create_time of this Job.  # noqa: E501


        :return: The create_time of this Job.  # noqa: E501
        :rtype: int
        """
        return self._create_time

    @create_time.setter
    def create_time(self, create_time):
        """Sets the create_time of this Job.


        :param create_time: The create_time of this Job.  # noqa: E501
        :type: int
        """

        self._create_time = create_time

    @property
    def id(self):
        """Gets the id of this Job.  # noqa: E501

        ID is a unique identifier assigned to this job. It helps to distinguish jobs with the same name after they have been deleted and re-created. The ID is generated by the server and should not be set directly by the client.  # noqa: E501

        :return: The id of this Job.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Job.

        ID is a unique identifier assigned to this job. It helps to distinguish jobs with the same name after they have been deleted and re-created. The ID is generated by the server and should not be set directly by the client.  # noqa: E501

        :param id: The id of this Job.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def labels(self):
        """Gets the labels of this Job.  # noqa: E501

        Labels is used to associate arbitrary labels with this job, which can be used for filtering. key=value  # noqa: E501

        :return: The labels of this Job.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this Job.

        Labels is used to associate arbitrary labels with this job, which can be used for filtering. key=value  # noqa: E501

        :param labels: The labels of this Job.  # noqa: E501
        :type: dict(str, str)
        """

        self._labels = labels

    @property
    def meta(self):
        """Gets the meta of this Job.  # noqa: E501

        Meta is used to associate arbitrary metadata with this job.  # noqa: E501

        :return: The meta of this Job.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._meta

    @meta.setter
    def meta(self, meta):
        """Sets the meta of this Job.

        Meta is used to associate arbitrary metadata with this job.  # noqa: E501

        :param meta: The meta of this Job.  # noqa: E501
        :type: dict(str, str)
        """

        self._meta = meta

    @property
    def modify_time(self):
        """Gets the modify_time of this Job.  # noqa: E501


        :return: The modify_time of this Job.  # noqa: E501
        :rtype: int
        """
        return self._modify_time

    @modify_time.setter
    def modify_time(self, modify_time):
        """Sets the modify_time of this Job.


        :param modify_time: The modify_time of this Job.  # noqa: E501
        :type: int
        """

        self._modify_time = modify_time

    @property
    def name(self):
        """Gets the name of this Job.  # noqa: E501

        Name is the logical name of the job used to refer to it. Submitting a job with the same name as an existing job will result in an update to the existing job.  # noqa: E501

        :return: The name of this Job.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Job.

        Name is the logical name of the job used to refer to it. Submitting a job with the same name as an existing job will result in an update to the existing job.  # noqa: E501

        :param name: The name of this Job.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def namespace(self):
        """Gets the namespace of this Job.  # noqa: E501

        Namespace is the namespace this job is running in.  # noqa: E501

        :return: The namespace of this Job.  # noqa: E501
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """Sets the namespace of this Job.

        Namespace is the namespace this job is running in.  # noqa: E501

        :param namespace: The namespace of this Job.  # noqa: E501
        :type: str
        """

        self._namespace = namespace

    @property
    def priority(self):
        """Gets the priority of this Job.  # noqa: E501

        Priority defines the scheduling priority of this job.  # noqa: E501

        :return: The priority of this Job.  # noqa: E501
        :rtype: int
        """
        return self._priority

    @priority.setter
    def priority(self, priority):
        """Sets the priority of this Job.

        Priority defines the scheduling priority of this job.  # noqa: E501

        :param priority: The priority of this Job.  # noqa: E501
        :type: int
        """

        self._priority = priority

    @property
    def revision(self):
        """Gets the revision of this Job.  # noqa: E501

        Revision is a per-job monotonically increasing revision number that is incremented on each update to the job's state or specification  # noqa: E501

        :return: The revision of this Job.  # noqa: E501
        :rtype: int
        """
        return self._revision

    @revision.setter
    def revision(self, revision):
        """Sets the revision of this Job.

        Revision is a per-job monotonically increasing revision number that is incremented on each update to the job's state or specification  # noqa: E501

        :param revision: The revision of this Job.  # noqa: E501
        :type: int
        """

        self._revision = revision

    @property
    def state(self):
        """Gets the state of this Job.  # noqa: E501

        State is the current state of the job.  # noqa: E501

        :return: The state of this Job.  # noqa: E501
        :rtype: AllOfJobState
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this Job.

        State is the current state of the job.  # noqa: E501

        :param state: The state of this Job.  # noqa: E501
        :type: AllOfJobState
        """

        self._state = state

    @property
    def tasks(self):
        """Gets the tasks of this Job.  # noqa: E501


        :return: The tasks of this Job.  # noqa: E501
        :rtype: list[Task]
        """
        return self._tasks

    @tasks.setter
    def tasks(self, tasks):
        """Sets the tasks of this Job.


        :param tasks: The tasks of this Job.  # noqa: E501
        :type: list[Task]
        """

        self._tasks = tasks

    @property
    def type(self):
        """Gets the type of this Job.  # noqa: E501

        Type is the type of job this is, e.g. \"daemon\" or \"batch\".  # noqa: E501

        :return: The type of this Job.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this Job.

        Type is the type of job this is, e.g. \"daemon\" or \"batch\".  # noqa: E501

        :param type: The type of this Job.  # noqa: E501
        :type: str
        """

        self._type = type

    @property
    def version(self):
        """Gets the version of this Job.  # noqa: E501

        Version is a per-job monotonically increasing version number that is incremented on each job specification update.  # noqa: E501

        :return: The version of this Job.  # noqa: E501
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this Job.

        Version is a per-job monotonically increasing version number that is incremented on each job specification update.  # noqa: E501

        :param version: The version of this Job.  # noqa: E501
        :type: int
        """

        self._version = version

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Job, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Job):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
