# coding: utf-8

"""
    Bacalhau API

    This page is the reference of the Bacalhau REST API. Project docs are available at https://docs.bacalhau.org/. Find more information about Bacalhau at https://github.com/bacalhau-project/bacalhau.  # noqa: E501

    OpenAPI spec version: ${VERSION}
    Contact: team@bacalhau.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class RunCommandResult(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'error_msg': 'str',
        'exit_code': 'int',
        'stderr_truncated': 'bool',
        'stdout': 'str',
        'stdout_truncated': 'bool',
        'stderr': 'str'
    }

    attribute_map = {
        'error_msg': 'ErrorMsg',
        'exit_code': 'ExitCode',
        'stderr_truncated': 'StderrTruncated',
        'stdout': 'Stdout',
        'stdout_truncated': 'StdoutTruncated',
        'stderr': 'stderr'
    }

    def __init__(self, error_msg=None, exit_code=None, stderr_truncated=None, stdout=None, stdout_truncated=None, stderr=None):  # noqa: E501
        """RunCommandResult - a model defined in Swagger"""  # noqa: E501
        self._error_msg = None
        self._exit_code = None
        self._stderr_truncated = None
        self._stdout = None
        self._stdout_truncated = None
        self._stderr = None
        self.discriminator = None
        if error_msg is not None:
            self.error_msg = error_msg
        if exit_code is not None:
            self.exit_code = exit_code
        if stderr_truncated is not None:
            self.stderr_truncated = stderr_truncated
        if stdout is not None:
            self.stdout = stdout
        if stdout_truncated is not None:
            self.stdout_truncated = stdout_truncated
        if stderr is not None:
            self.stderr = stderr

    @property
    def error_msg(self):
        """Gets the error_msg of this RunCommandResult.  # noqa: E501

        Runner error  # noqa: E501

        :return: The error_msg of this RunCommandResult.  # noqa: E501
        :rtype: str
        """
        return self._error_msg

    @error_msg.setter
    def error_msg(self, error_msg):
        """Sets the error_msg of this RunCommandResult.

        Runner error  # noqa: E501

        :param error_msg: The error_msg of this RunCommandResult.  # noqa: E501
        :type: str
        """

        self._error_msg = error_msg

    @property
    def exit_code(self):
        """Gets the exit_code of this RunCommandResult.  # noqa: E501

        exit code of the run.  # noqa: E501

        :return: The exit_code of this RunCommandResult.  # noqa: E501
        :rtype: int
        """
        return self._exit_code

    @exit_code.setter
    def exit_code(self, exit_code):
        """Sets the exit_code of this RunCommandResult.

        exit code of the run.  # noqa: E501

        :param exit_code: The exit_code of this RunCommandResult.  # noqa: E501
        :type: int
        """

        self._exit_code = exit_code

    @property
    def stderr_truncated(self):
        """Gets the stderr_truncated of this RunCommandResult.  # noqa: E501

        bool describing if stderr was truncated  # noqa: E501

        :return: The stderr_truncated of this RunCommandResult.  # noqa: E501
        :rtype: bool
        """
        return self._stderr_truncated

    @stderr_truncated.setter
    def stderr_truncated(self, stderr_truncated):
        """Sets the stderr_truncated of this RunCommandResult.

        bool describing if stderr was truncated  # noqa: E501

        :param stderr_truncated: The stderr_truncated of this RunCommandResult.  # noqa: E501
        :type: bool
        """

        self._stderr_truncated = stderr_truncated

    @property
    def stdout(self):
        """Gets the stdout of this RunCommandResult.  # noqa: E501

        stdout of the run. Yaml provided for `describe` output  # noqa: E501

        :return: The stdout of this RunCommandResult.  # noqa: E501
        :rtype: str
        """
        return self._stdout

    @stdout.setter
    def stdout(self, stdout):
        """Sets the stdout of this RunCommandResult.

        stdout of the run. Yaml provided for `describe` output  # noqa: E501

        :param stdout: The stdout of this RunCommandResult.  # noqa: E501
        :type: str
        """

        self._stdout = stdout

    @property
    def stdout_truncated(self):
        """Gets the stdout_truncated of this RunCommandResult.  # noqa: E501

        bool describing if stdout was truncated  # noqa: E501

        :return: The stdout_truncated of this RunCommandResult.  # noqa: E501
        :rtype: bool
        """
        return self._stdout_truncated

    @stdout_truncated.setter
    def stdout_truncated(self, stdout_truncated):
        """Sets the stdout_truncated of this RunCommandResult.

        bool describing if stdout was truncated  # noqa: E501

        :param stdout_truncated: The stdout_truncated of this RunCommandResult.  # noqa: E501
        :type: bool
        """

        self._stdout_truncated = stdout_truncated

    @property
    def stderr(self):
        """Gets the stderr of this RunCommandResult.  # noqa: E501

        stderr of the run.  # noqa: E501

        :return: The stderr of this RunCommandResult.  # noqa: E501
        :rtype: str
        """
        return self._stderr

    @stderr.setter
    def stderr(self, stderr):
        """Sets the stderr of this RunCommandResult.

        stderr of the run.  # noqa: E501

        :param stderr: The stderr of this RunCommandResult.  # noqa: E501
        :type: str
        """

        self._stderr = stderr

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RunCommandResult, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RunCommandResult):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
