# coding: utf-8

"""
    Bacalhau API

    This page is the reference of the Bacalhau REST API. Project docs are available at https://docs.bacalhau.org/. Find more information about Bacalhau at https://github.com/bacalhau-project/bacalhau.  # noqa: E501

    OpenAPI spec version: ${VERSION}
    Contact: team@bacalhau.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class Task(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'engine': 'SpecConfig',
        'env': 'dict(str, str)',
        'input_sources': 'list[InputSource]',
        'meta': 'dict(str, str)',
        'name': 'str',
        'network': 'NetworkConfig',
        'publisher': 'SpecConfig',
        'resources': 'AllOfTaskResources',
        'result_paths': 'list[ResultPath]',
        'timeouts': 'TimeoutConfig'
    }

    attribute_map = {
        'engine': 'Engine',
        'env': 'Env',
        'input_sources': 'InputSources',
        'meta': 'Meta',
        'name': 'Name',
        'network': 'Network',
        'publisher': 'Publisher',
        'resources': 'Resources',
        'result_paths': 'ResultPaths',
        'timeouts': 'Timeouts'
    }

    def __init__(self, engine=None, env=None, input_sources=None, meta=None, name=None, network=None, publisher=None, resources=None, result_paths=None, timeouts=None):  # noqa: E501
        """Task - a model defined in Swagger"""  # noqa: E501
        self._engine = None
        self._env = None
        self._input_sources = None
        self._meta = None
        self._name = None
        self._network = None
        self._publisher = None
        self._resources = None
        self._result_paths = None
        self._timeouts = None
        self.discriminator = None
        if engine is not None:
            self.engine = engine
        if env is not None:
            self.env = env
        if input_sources is not None:
            self.input_sources = input_sources
        if meta is not None:
            self.meta = meta
        if name is not None:
            self.name = name
        if network is not None:
            self.network = network
        if publisher is not None:
            self.publisher = publisher
        if resources is not None:
            self.resources = resources
        if result_paths is not None:
            self.result_paths = result_paths
        if timeouts is not None:
            self.timeouts = timeouts

    @property
    def engine(self):
        """Gets the engine of this Task.  # noqa: E501


        :return: The engine of this Task.  # noqa: E501
        :rtype: SpecConfig
        """
        return self._engine

    @engine.setter
    def engine(self, engine):
        """Sets the engine of this Task.


        :param engine: The engine of this Task.  # noqa: E501
        :type: SpecConfig
        """

        self._engine = engine

    @property
    def env(self):
        """Gets the env of this Task.  # noqa: E501

        Map of environment variables to be used by the driver  # noqa: E501

        :return: The env of this Task.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._env

    @env.setter
    def env(self, env):
        """Sets the env of this Task.

        Map of environment variables to be used by the driver  # noqa: E501

        :param env: The env of this Task.  # noqa: E501
        :type: dict(str, str)
        """

        self._env = env

    @property
    def input_sources(self):
        """Gets the input_sources of this Task.  # noqa: E501

        InputSources is a list of remote artifacts to be downloaded before running the task and mounted into the task.  # noqa: E501

        :return: The input_sources of this Task.  # noqa: E501
        :rtype: list[InputSource]
        """
        return self._input_sources

    @input_sources.setter
    def input_sources(self, input_sources):
        """Sets the input_sources of this Task.

        InputSources is a list of remote artifacts to be downloaded before running the task and mounted into the task.  # noqa: E501

        :param input_sources: The input_sources of this Task.  # noqa: E501
        :type: list[InputSource]
        """

        self._input_sources = input_sources

    @property
    def meta(self):
        """Gets the meta of this Task.  # noqa: E501

        Meta is used to associate arbitrary metadata with this task.  # noqa: E501

        :return: The meta of this Task.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._meta

    @meta.setter
    def meta(self, meta):
        """Sets the meta of this Task.

        Meta is used to associate arbitrary metadata with this task.  # noqa: E501

        :param meta: The meta of this Task.  # noqa: E501
        :type: dict(str, str)
        """

        self._meta = meta

    @property
    def name(self):
        """Gets the name of this Task.  # noqa: E501

        Name of the task  # noqa: E501

        :return: The name of this Task.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Task.

        Name of the task  # noqa: E501

        :param name: The name of this Task.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def network(self):
        """Gets the network of this Task.  # noqa: E501


        :return: The network of this Task.  # noqa: E501
        :rtype: NetworkConfig
        """
        return self._network

    @network.setter
    def network(self, network):
        """Sets the network of this Task.


        :param network: The network of this Task.  # noqa: E501
        :type: NetworkConfig
        """

        self._network = network

    @property
    def publisher(self):
        """Gets the publisher of this Task.  # noqa: E501


        :return: The publisher of this Task.  # noqa: E501
        :rtype: SpecConfig
        """
        return self._publisher

    @publisher.setter
    def publisher(self, publisher):
        """Sets the publisher of this Task.


        :param publisher: The publisher of this Task.  # noqa: E501
        :type: SpecConfig
        """

        self._publisher = publisher

    @property
    def resources(self):
        """Gets the resources of this Task.  # noqa: E501

        ResourcesConfig is the resources needed by this task  # noqa: E501

        :return: The resources of this Task.  # noqa: E501
        :rtype: AllOfTaskResources
        """
        return self._resources

    @resources.setter
    def resources(self, resources):
        """Sets the resources of this Task.

        ResourcesConfig is the resources needed by this task  # noqa: E501

        :param resources: The resources of this Task.  # noqa: E501
        :type: AllOfTaskResources
        """

        self._resources = resources

    @property
    def result_paths(self):
        """Gets the result_paths of this Task.  # noqa: E501

        ResultPaths is a list of task volumes to be included in the task's published result  # noqa: E501

        :return: The result_paths of this Task.  # noqa: E501
        :rtype: list[ResultPath]
        """
        return self._result_paths

    @result_paths.setter
    def result_paths(self, result_paths):
        """Sets the result_paths of this Task.

        ResultPaths is a list of task volumes to be included in the task's published result  # noqa: E501

        :param result_paths: The result_paths of this Task.  # noqa: E501
        :type: list[ResultPath]
        """

        self._result_paths = result_paths

    @property
    def timeouts(self):
        """Gets the timeouts of this Task.  # noqa: E501


        :return: The timeouts of this Task.  # noqa: E501
        :rtype: TimeoutConfig
        """
        return self._timeouts

    @timeouts.setter
    def timeouts(self, timeouts):
        """Sets the timeouts of this Task.


        :param timeouts: The timeouts of this Task.  # noqa: E501
        :type: TimeoutConfig
        """

        self._timeouts = timeouts

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Task, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Task):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
